/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import oracle.ide.model.DataContainer;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.TriStateBoolean;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.common.ConnectionDefault;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.CdaPacketFactory;
import oracle.jdevimpl.deploy.fwk.JarUtil;

public class ProfileDeployer
extends AbstractDeployer {
    private final Profile _profile;

    public ProfileDeployer(int deploySequenceId, DeployShell shell) {
        super(deploySequenceId);
        this._profile = DeployUtil.getProfile(shell);
        if (this._profile.getDataContainer() == null) {
            throw new IllegalArgumentException("profile.getDataContainer() returns null");
        }
    }

    protected Profile getProfile() {
        return this._profile;
    }

    @Deprecated
    protected DataContainer getProfileContainer() {
        return this._profile.getDataContainer();
    }

    @Deprecated
    public static String getConnectionName(DeployShell dsh, ConnectionDefault cd) {
        String conn = dsh.getConnectionName();
        return conn != null ? conn : cd.getDefaultConnection();
    }

    protected void processFileGroups(FileGroups fileGroups, Archive archive) {
        FileGroupPackager packager = FileGroupPackager.newInstance(fileGroups, this.getProfileContainer(), this._profile, archive);
        packager.process();
    }

    protected String getJarClassesDir() {
        return "";
    }

    protected static final JarUtil createJarUtil(boolean hasManifest) {
        return JarUtil.create(hasManifest, DeployUtil.isForceJarRewrite());
    }

    public static JarUtil createJarUtil(ArchiveOptions archiveOptions) {
        return ProfileDeployer.createJarUtil(archiveOptions.getHasManifest());
    }

    @Override
    protected void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
    }

    private static class CPF
    extends CdaPacketFactory {
        private final SelectionRules _rules;
        private final URLPath _contribPath;

        CPF(URLPath contribPath, SelectionRules rules) {
            URLPath contribs = new URLPath(contribPath);
            URLPath regularFiles = FileGroupPackager.stripRegularFiles(contribs);
            if (rules != null) {
                for (URL url : regularFiles) {
                    String name = URLFileSystem.getFileName((URL)url);
                    if (!rules.isIncluded(name)) continue;
                    this.add(new CdaPacket(name, url));
                }
            }
            this._contribPath = contribs;
            this._rules = rules;
        }

        @Override
        protected boolean shouldRecurseInto(URL url) {
            if (this._rules != null) {
                TriStateBoolean inference = this._rules.inferFromRules(this._contribPath.toRelativePath(url));
                return inference.isTrue() || inference.isTriState();
            }
            return false;
        }

        @Override
        protected boolean shouldAdd(URL url) {
            String relPath = this._contribPath.toRelativePath(url);
            return relPath == null || this._rules != null && this._rules.isIncluded(relPath);
        }
    }
}

