/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.net.URLPath;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.LibraryDependencies;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryAdapter;
import oracle.jdevimpl.deploy.common.AbstractDependentLibraryBuilder;
import oracle.jdevimpl.deploy.common.DependentLibrary;
import oracle.jdevimpl.deploy.common.DependentLibraryList;
import oracle.jdevimpl.deploy.common.LibraryToolkit;

public class ProfileDependentLibraryBuilder
extends AbstractDependentLibraryBuilder {
    public ProfileDependentLibraryBuilder(Class<? extends Toolkit> tkClass, ToolkitContext tkContext) {
        super(tkClass, tkContext);
    }

    protected void addSelfAsLibraryIfNeeded(LibraryToolkit toolkit, Profile profile) {
        Boolean reportSelfAsLibrary = this.getIdeContext().getBoolean("ReportProfileAsLibrary");
        if (reportSelfAsLibrary != null && reportSelfAsLibrary.booleanValue() && profile instanceof ArchiveProfile && !profile.equals(this.getOriginalBuildElement())) {
            ArchiveProfile archiveProfile = (ArchiveProfile)profile;
            JLibraryAdapter library = new JLibraryAdapter(HashStructure.newInstance());
            library.setName(archiveProfile.getShortLabel());
            library.setID((Object)archiveProfile.getShortLabel());
            library.setClassPath(new URLPath(archiveProfile.getJarURL()));
            library.setDeployedByDefault(Boolean.TRUE);
            library.setLocked(true);
            DependentLibrary depLib = new DependentLibrary((JLibrary)library);
            toolkit.add(depLib);
        }
    }

    protected void flagLibraries(Profile profile, LibraryToolkit toolkit) {
        LibraryDependencies libraryDependencies = profile.getLibraryDependencies();
        Object[] userExcludedLibraries = libraryDependencies.getUnselectedLibraryNames();
        List<Object> userExcludedLibraryList = new ArrayList();
        if (userExcludedLibraries != null) {
            userExcludedLibraryList = Arrays.asList(userExcludedLibraries);
        }
        for (DependentLibrary library : toolkit.getDependentLibraries(null)) {
            if (library.getExcludedBy() == null && userExcludedLibraryList.contains(library.getLibrary().getID())) {
                library.setExcludedBy(profile);
            }
            if (library.getResolvedBy() != null || !profile.resolvesLibrary(library)) continue;
            library.setResolvedBy(profile);
        }
    }

    protected Boolean reportDependentProfilesAsLibraries() {
        return Boolean.TRUE;
    }

    @Override
    protected LibraryToolkit buildImpl() {
        Profile profile = (Profile)this.getIdeContext().getElement();
        LibraryToolkit preBuiltLibraryToolkit = (LibraryToolkit)this.getIdeContext().getProperty("PreBuiltLibraryToolkit");
        if (preBuiltLibraryToolkit != null) {
            LibraryToolkit copy = (LibraryToolkit)preBuiltLibraryToolkit.copyTo(null);
            for (DependentLibrary library : copy.getDependentLibraries(null)) {
                library.setExcludedBy(null);
                library.setIgnoredBy(null);
                library.setResolvedBy(null);
            }
            this.flagLibraries(profile, copy);
            return copy;
        }
        DependentLibraryList toolkit = new DependentLibraryList(this.getElement());
        Boolean traverseDependencies = profile.getLibraryDependencies() != null ? Boolean.valueOf(profile.getLibraryDependencies().isIncludeLibrariesFromOtherContainers()) : Boolean.FALSE;
        this.addSelfAsLibraryIfNeeded(toolkit, profile);
        Context context = new Context();
        context.setElement((Element)profile.getDataContainer());
        context.setProperty("traverseDependencies", (Object)traverseDependencies);
        LibraryToolkit[] toolkits = this.buildLibraryToolkits(context);
        if (toolkits != null) {
            toolkit.add(toolkits);
        }
        if (traverseDependencies.booleanValue()) {
            Iterator<Dependable> iter = profile.getDependencies();
            while (iter.hasNext()) {
                Dependable dep = iter.next();
                Context depContext = new Context();
                depContext.setElement(dep.getSource());
                depContext.setBoolean("ReportProfileAsLibrary", this.reportDependentProfilesAsLibraries().booleanValue());
                LibraryToolkit[] depToolkits = this.buildLibraryToolkits(depContext);
                if (depToolkits == null) continue;
                toolkit.add(depToolkits);
            }
        }
        this.flagLibraries(profile, toolkit);
        return toolkit;
    }
}

