/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.io.PrintWriter;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.DependencyGraph;
import oracle.jdevimpl.deploy.common.ProfileDeployer;

public class ProfileDependencyAnalyzer
extends ProfileDeployer {
    public static final String IGNORE_DEPENDENCIES = "ignoreDependencies";

    public ProfileDependencyAnalyzer(int sequence, DeployShell shell) {
        super(sequence, shell);
    }

    @Override
    protected void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        PrintWriter log = shell.getLog();
        if (shell.getFlag(IGNORE_DEPENDENCIES)) {
            return;
        }
        try {
            log.println(DeployArb.getString(75));
            DependencyGraph graph = new DependencyGraph(this.getProfile());
            this.printDependencyGraphErrors(shell, graph);
            shell.put(DependencyGraph.DATA_KEY, graph);
        }
        catch (IllegalAccessException e) {
            throw new DeployException(e);
        }
        catch (InstantiationException e) {
            throw new DeployException(e);
        }
    }

    protected void printDependencyGraphErrors(DeployShell shell, DependencyGraph graph) {
        PrintWriter log = shell.getLog();
        for (Exception e : graph.getExceptions()) {
            if (e instanceof DependencyGraph.DependencyCycleException) {
                log.println(e.getMessage());
                continue;
            }
            e.printStackTrace(log);
        }
    }
}

