/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.JCheckBox;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.ArrayElementList;
import oracle.jdevimpl.xml.TwoColumnPanel;

public class PackagingProjectPanel
extends TwoColumnPanel
implements ItemListener {
    private final JCheckBox _cbOutputDirectory = this.addCheckBoxImpl(CommonArb.getString(116), 2);
    private final JCheckBox _cbSourcePath = this.addCheckBoxImpl(CommonArb.getString(117), 6);
    private final JCheckBox _cbAdditionalClasspath = this.addCheckBoxImpl(CommonArb.getString(118), 3);
    private final JCheckBox _cbHtmlRootDirectory = this.addCheckBoxImpl(CommonArb.getString(119), 5);
    private transient ArrayElementList _elementList;

    public PackagingProjectPanel() {
        this.addFill();
    }

    private JCheckBox addCheckBoxImpl(String label, int type) {
        JCheckBox cb = this.addCheckBox(label);
        cb.addItemListener(this);
        cb.putClientProperty("contrib-type", new Integer(type));
        return cb;
    }

    public void onEntry(TraversableContext tc) {
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        Object[] contribs = pfg.getContributors();
        this._elementList = new ArrayElementList(Contributor.class, contribs);
        boolean outputDirectory = false;
        boolean sourcePath = false;
        boolean additionalClasspath = false;
        boolean htmlRootDirectory = false;
        Iterator iter = this._elementList.iterator();
        while (iter.hasNext()) {
            Contributor contrib = (Contributor)iter.next();
            if (contrib == null) continue;
            switch (contrib.getType()) {
                case 2: {
                    outputDirectory = true;
                    break;
                }
                case 6: {
                    sourcePath = true;
                    break;
                }
                case 3: {
                    additionalClasspath = true;
                    break;
                }
                case 5: {
                    htmlRootDirectory = true;
                }
            }
        }
        this._cbOutputDirectory.setSelected(outputDirectory);
        this._cbSourcePath.setSelected(sourcePath);
        this._cbAdditionalClasspath.setSelected(additionalClasspath);
        this._cbHtmlRootDirectory.setSelected(htmlRootDirectory);
    }

    public void onExit(TraversableContext tc) {
        PackagingFileGroup pfg = FileGroupsEditor.getPackagingFileGroup((Namespace)tc);
        pfg.setContributors((Contributor[])this._elementList.getData());
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        JCheckBox cb = (JCheckBox)event.getSource();
        Integer typeInt = (Integer)cb.getClientProperty("contrib-type");
        int type = typeInt;
        boolean selected = cb.isSelected();
        Iterator iter = this._elementList.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            Contributor contrib = (Contributor)iter.next();
            if (contrib == null || contrib.getType() != type) continue;
            found = true;
            if (selected) continue;
            iter.remove();
        }
        if (!found && selected) {
            this._elementList.add(new Contributor(type, null));
        }
    }
}

