/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import javax.swing.JCheckBox;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.xml.bind.ElementListEvent;
import oracle.javatools.xml.bind.ElementListListener;
import oracle.jdeveloper.deploy.common.Contributor;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.PackagingOtherPanel;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.xml.TwoColumnPanel;

public final class PackagingContributorsPanel
extends TwoColumnPanel
implements ItemListener {
    private final JCheckBox _cbApplicationSourcePath = this.addCheckBoxImpl(CommonArb.getString(99), 9);
    private final JCheckBox _cbAdfSourceDirectory = this.addCheckBoxImpl(CommonArb.getString(100), 10);
    private final JCheckBox _cbOutputDirectory = this.addCheckBoxImpl(CommonArb.getString(94), 2);
    private final JCheckBox _cbSourcePath;
    private final JCheckBox _cbAdditionalClasspath;
    private final JCheckBox _cbHtmlRootDirectory = this.addCheckBoxImpl(CommonArb.getString(95), 5);
    private final JCheckBox _cbProjectDeps;
    private final PackagingOtherPanel _otherPanel;
    private transient ElementListListener _listener;

    PackagingContributorsPanel() {
        this._cbSourcePath = this.addCheckBoxImpl(CommonArb.getString(96), 6);
        this._cbAdditionalClasspath = this.addCheckBoxImpl(CommonArb.getString(97), 3);
        this._cbProjectDeps = this.addCheckBoxImpl(CommonArb.getString(98), 7);
        this._otherPanel = new PackagingOtherPanel();
        this.add((Component)((Object)this._otherPanel), this.gbc(this._lastX, this._lastY++, 2, 1, 1.0, 1.0, 18, 1, this._insets));
        this.setHelpID("f1_depfgpkgcont_html");
    }

    private JCheckBox addCheckBoxImpl(String label, int type) {
        JCheckBox cb = this.addCheckBox(label);
        cb.addItemListener(this);
        cb.putClientProperty("contrib-type", new Integer(type));
        return cb;
    }

    public void onEntry(TraversableContext tc) {
        this._otherPanel.onEntry(tc);
        this.updateCheckboxVisibility(tc);
        this.updateCheckboxStates();
        if (this._listener == null) {
            this._listener = new ElementListListener(){

                public void elementsAdded(ElementListEvent e) {
                    PackagingContributorsPanel.this.updateCheckboxStates();
                }

                public void elementsRemoved(ElementListEvent e) {
                    PackagingContributorsPanel.this.updateCheckboxStates();
                }

                public void elementsChanged(ElementListEvent e) {
                    PackagingContributorsPanel.this.updateCheckboxStates();
                }
            };
        }
        this._otherPanel._list.addElementListListener(this._listener);
    }

    private void updateCheckboxVisibility(TraversableContext tc) {
        DataContainer container = this.getDataContainer(tc);
        boolean isAppLevel = container instanceof Workspace;
        boolean isProjectLevel = container instanceof Project;
        this._cbApplicationSourcePath.setVisible(isAppLevel);
        this._cbAdfSourceDirectory.setVisible(isAppLevel);
        this._cbOutputDirectory.setVisible(isProjectLevel);
        this._cbSourcePath.setVisible(isProjectLevel);
        this._cbAdditionalClasspath.setVisible(isProjectLevel);
        this._cbHtmlRootDirectory.setVisible(isProjectLevel);
        this._cbProjectDeps.setVisible(isProjectLevel);
    }

    private DataContainer getDataContainer(TraversableContext tc) {
        if (tc.find("stored-proc-profile") != null) {
            return (Project)CommonEditor.getProject((Namespace)tc);
        }
        Profile profile = CommonEditor.getProfile((Namespace)tc);
        if (profile != null) {
            return profile.getDataContainer();
        }
        throw new RuntimeException("profile should be set in context by scatterData in ModalEditor subclass");
    }

    private void updateCheckboxStates() {
        boolean applicationSourcePath = false;
        boolean adfSourceDirectory = false;
        boolean outputDirectory = false;
        boolean sourcePath = false;
        boolean additionalClasspath = false;
        boolean htmlRootDirectory = false;
        boolean projectDeps = false;
        Iterator iter = this._otherPanel._list.iterator();
        while (iter.hasNext()) {
            Contributor contrib = (Contributor)iter.next();
            if (contrib == null) continue;
            switch (contrib.getType()) {
                case 9: {
                    applicationSourcePath = true;
                    break;
                }
                case 10: {
                    adfSourceDirectory = true;
                    break;
                }
                case 2: {
                    outputDirectory = true;
                    break;
                }
                case 6: {
                    sourcePath = true;
                    break;
                }
                case 3: {
                    additionalClasspath = true;
                    break;
                }
                case 5: {
                    htmlRootDirectory = true;
                    break;
                }
                case 7: {
                    projectDeps = true;
                }
            }
        }
        this._cbApplicationSourcePath.setSelected(applicationSourcePath);
        this._cbAdfSourceDirectory.setSelected(adfSourceDirectory);
        this._cbOutputDirectory.setSelected(outputDirectory);
        this._cbSourcePath.setSelected(sourcePath);
        this._cbAdditionalClasspath.setSelected(additionalClasspath);
        this._cbHtmlRootDirectory.setSelected(htmlRootDirectory);
        this._cbProjectDeps.setSelected(projectDeps);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        this._otherPanel.onExit(tc);
        this._otherPanel._list.removeElementListListener(this._listener);
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        JCheckBox cb = (JCheckBox)event.getSource();
        Integer typeInt = (Integer)cb.getClientProperty("contrib-type");
        int type = typeInt;
        boolean selected = cb.isSelected();
        Iterator iter = this._otherPanel._list.iterator();
        boolean found = false;
        while (iter.hasNext()) {
            Contributor contrib = (Contributor)iter.next();
            if (contrib == null || contrib.getType() != type) continue;
            found = true;
            if (selected) continue;
            iter.remove();
        }
        if (!found && selected) {
            this._otherPanel._list.add(new Contributor(type, null));
        }
    }
}

