/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import oracle.ide.Context;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentConstants;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.DependencyGraph;

public class ModulePackagerImpl {
    public Profile[] getProfilesFromGraph(DeployShell shell) throws DeployException {
        Profile[] profiles;
        boolean ignoreDependencies = shell.getFlag("ignoreDependencies");
        if (ignoreDependencies) {
            profiles = new Profile[]{DeployUtil.getProfile(shell)};
        } else {
            DependencyGraph graph = DependencyGraph.findInNamespace(shell);
            if (graph == null) {
                throw new DeployException("Dependency graph not found");
            }
            profiles = graph.getProfiles();
        }
        return profiles;
    }

    public void deployProfiles(Profile[] profiles, DeployShell shell) throws DeployException {
        DeployShellFactory shellFactory = shell.getDeployShellFactory();
        shell.getLog().println(profiles.length == 1 ? DeployArb.getString(76) : DeployArb.format(77, profiles.length));
        for (Profile profile : profiles) {
            int deploySequence = DeploymentConstants.DEFAULT_SEQUENCE;
            Context context = new Context(shell.getContext());
            DeployUtil.setProfile(context, (Profile)profile.copyTo(null));
            DeployShell childShell = shellFactory.create(deploySequence, context, shell);
            try {
                DeploymentManager.deploy(deploySequence, childShell);
            }
            catch (Exception e) {
                if (e instanceof DeployException) {
                    throw (DeployException)e;
                }
                throw new RuntimeException(e);
            }
        }
    }
}

