/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import oracle.ide.Context;
import oracle.ide.index.QueryCriteria;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdevimpl.deploy.common.DependentLibrary;
import oracle.jdevimpl.deploy.common.LibraryToolkit;

public class LibraryToolkitHelper {
    public static final String PROGRESS_MONITOR = "ProgressMonitor";
    private List<LibraryToolkit> _libraryToolkits = new ArrayList<LibraryToolkit>();
    private Context _lastContextBuilt;
    private boolean _isCacheValid = false;

    private boolean isSameContext(Context context) {
        return context != null || context.getElement() != null && this._lastContextBuilt != null || this._lastContextBuilt.getElement() != null && context.getElement().equals(this._lastContextBuilt.getElement());
    }

    public synchronized void buildDependentLibraries(Context context) {
        if (!this.isSameContext(context) || !this._isCacheValid) {
            this._libraryToolkits.clear();
            ToolkitRegistry reg = ToolkitRegistry.getInstance();
            try {
                Object[] built;
                ToolkitBuilder builder = reg.getBuilder(context.getElement(), context, LibraryToolkit.class);
                if (builder != null && (built = builder.narrowBuildToolkits()) != null) {
                    for (Object object : built) {
                        if (!(object instanceof LibraryToolkit)) continue;
                        this._libraryToolkits.add((LibraryToolkit)object);
                    }
                }
                this._isCacheValid = true;
                this._lastContextBuilt = context;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void invalidateCache() {
        this._isCacheValid = false;
    }

    public DependentLibrary[] getDependentLibraries(QueryCriteria criteria) {
        ArrayList<DependentLibrary> dependentLibraryList = new ArrayList<DependentLibrary>();
        for (LibraryToolkit libraryToolkit : this._libraryToolkits) {
            for (DependentLibrary dependentLibrary : libraryToolkit.getDependentLibraries(criteria)) {
                if (dependentLibraryList.contains(dependentLibrary)) continue;
                dependentLibraryList.add(dependentLibrary);
            }
        }
        return dependentLibraryList.toArray(new DependentLibrary[0]);
    }

    public Map<JLibrary, List<DependentLibrary>> getLibraryMap(QueryCriteria criteria) {
        DependentLibrary[] dependentLibraries;
        LinkedHashMap<JLibrary, List<DependentLibrary>> JLibraryMap = new LinkedHashMap<JLibrary, List<DependentLibrary>>();
        for (DependentLibrary dependentLibrary : dependentLibraries = this.getDependentLibraries(criteria)) {
            List<DependentLibrary> dependentLibraryList = JLibraryMap.get(dependentLibrary.getLibrary());
            if (dependentLibraryList == null) {
                dependentLibraryList = new ArrayList<DependentLibrary>();
                dependentLibraryList.add(dependentLibrary);
                JLibraryMap.put(dependentLibrary.getLibrary(), dependentLibraryList);
                continue;
            }
            if (dependentLibraryList.contains(dependentLibrary)) continue;
            dependentLibraryList.add(dependentLibrary);
        }
        return JLibraryMap;
    }

    private List<DependentLibrary> getLibraryListFromMap(LinkedHashMap<JLibrary, List<DependentLibrary>> libraryMap, JLibrary library) {
        Set<JLibrary> librarySet = libraryMap.keySet();
        for (JLibrary jlibrary : librarySet) {
            if (!jlibrary.getID().equals(library.getID())) continue;
            List<DependentLibrary> liblist = libraryMap.get(jlibrary);
            return liblist;
        }
        return null;
    }
}

