/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controls.tree.CustomJTree;
import oracle.ide.controls.tree.JMutableTreeNode;
import oracle.ide.controls.tree.JTreeCellData;
import oracle.ide.controls.tree.TreeCellCheckedEvent;
import oracle.ide.controls.tree.TreeCellCheckedListener;
import oracle.ide.index.QueryCriteria;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.ide.util.SwingWorker;
import oracle.ide.util.TriStateBoolean;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.LibraryDependencies;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.Library;
import oracle.jdevimpl.deploy.common.CommonEditor;
import oracle.jdevimpl.deploy.common.LibraryToolkitHelper;
import oracle.jdevimpl.deploy.res.CommonArb;

public class LibraryDependenciesPanel
extends DefaultTraversablePanel
implements ItemListener,
TreeCellCheckedListener {
    private Profile _profile;
    private final JScrollPane spTree = new JScrollPane();
    private final CustomJTree tree = new CustomJTree();
    private JCheckBox _cbProjectDeps;
    private TraversableContext _tc;

    public LibraryDependenciesPanel() {
        this.setLayout(new GridBagLayout());
        JLabel lblTree = new JLabel();
        ResourceUtils.resLabel((JLabel)lblTree, (Component)this.tree, (String)CommonArb.getString(93));
        this.tree.setRootVisible(false);
        this.tree.setShowsRootHandles(false);
        Insets defaultInsets = new Insets(5, 5, 5, 5);
        this.spTree.getViewport().add((Component)this.tree, null);
        this.add(lblTree, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 0, defaultInsets));
        this.add(this.spTree, this.gbc(0, 1, 1, 1, 1.0, 1.0, 18, 1, defaultInsets));
        this._cbProjectDeps = this.addCheckBoxImpl(CommonArb.getString(137));
        this.tree.addTreeCellCheckedListener((TreeCellCheckedListener)this);
        GridBagConstraints constraints = new GridBagConstraints(0, 10, 1, 1, 0.0, 0.0, 17, 0, defaultInsets, 0, 0);
        this.add(this._cbProjectDeps, constraints);
        this.setHelpID("f1_libdep_html");
    }

    public void onEntry(TraversableContext tc) {
        this._tc = tc;
        this._profile = CommonEditor.getProfile((Namespace)tc);
        this._cbProjectDeps.removeItemListener(this);
        if (this._profile.getDataContainer() instanceof Project) {
            this._cbProjectDeps.setVisible(true);
            this._cbProjectDeps.setSelected(this._profile.getLibraryDependencies().isIncludeLibrariesFromOtherContainers());
            this._cbProjectDeps.addItemListener(this);
        } else {
            this._cbProjectDeps.setSelected(true);
            this._cbProjectDeps.setVisible(false);
        }
        this.load();
    }

    public void onExit(TraversableContext tc) {
        LibraryDependencies libraryDependencies = this._profile.getLibraryDependencies();
        libraryDependencies.setIncludeLibrariesFromOtherContainers(this._cbProjectDeps.isSelected());
        libraryDependencies.setUnselectedLibraryNames(this.commit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load() {
        final JMutableTreeNode root = new JMutableTreeNode();
        LibraryToolkitHelper libraryToolkitHelper = CommonEditor.getLibraryToolkitHelper((Namespace)this._tc);
        synchronized (libraryToolkitHelper) {
            final IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), CommonArb.getString(138));
            progressMonitor.setMillisToPopup(1000);
            progressMonitor.setCancellable(true);
            progressMonitor.setCloseOnFinish(true);
            progressMonitor.start();
            SwingWorker swingWorker = new SwingWorker(){

                public Object construct() {
                    LibraryDependenciesPanel.loadLibraries(LibraryDependenciesPanel.this._tc, root, LibraryDependenciesPanel.this._profile, LibraryDependenciesPanel.this._cbProjectDeps, progressMonitor);
                    return null;
                }

                public void finished() {
                    progressMonitor.close();
                    LibraryDependenciesPanel.this.tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)root));
                    IdeUtil.expandAllTreeRows((JTree)LibraryDependenciesPanel.this.tree);
                    root.descendingUpdateNodes();
                }
            };
            swingWorker.start();
        }
    }

    private static void loadLibraries(TraversableContext tc, JMutableTreeNode root, Profile profile, JCheckBox includeLibFromOtherProjects, IndeterminateProgressMonitor progressMonitor) {
        LibraryToolkitHelper helper = CommonEditor.getLibraryToolkitHelper((Namespace)tc);
        LibraryDependencies libraryDependencies = profile.getLibraryDependencies();
        Object[] unselectedLibraryDependencyNames = libraryDependencies.getUnselectedLibraryNames();
        if (unselectedLibraryDependencyNames == null) {
            unselectedLibraryDependencyNames = new Object[]{};
        }
        Profile copy = (Profile)profile.copyTo(null);
        copy.getLibraryDependencies().setIncludeLibrariesFromOtherContainers(includeLibFromOtherProjects.isSelected());
        Context context = new Context();
        context.setElement((Element)copy);
        context.setProperty("ProgressMonitor", (Object)progressMonitor);
        helper.buildDependentLibraries(context);
        QueryCriteria criteria = new QueryCriteria();
        criteria.put((Object)"libraries.excludedByDependents", (Object)Boolean.FALSE);
        criteria.put((Object)"libraries.unresolvedByDependents", (Object)Boolean.TRUE);
        Set<JLibrary> keySet = helper.getLibraryMap(criteria).keySet();
        for (JLibrary library : keySet) {
            if (library == null) continue;
            Object libID = library.getID();
            if (DeployUtil.isDirectoryLibrary(library)) continue;
            JTreeCellData libCellData = new JTreeCellData(library.getIcon(), library.getName(), true);
            libCellData.setUserObject((Object)library);
            List<Object> unselectedList = Arrays.asList(unselectedLibraryDependencyNames);
            libCellData.setCheckBoxState(!unselectedList.contains(libID));
            libCellData.setCheckBoxSelectable(true);
            libCellData.setCheckBoxEnabled(true);
            JMutableTreeNode libNode = new JMutableTreeNode(libCellData);
            root.add((MutableTreeNode)libNode);
        }
    }

    private JCheckBox addCheckBoxImpl(String label) {
        JCheckBox cb = new JCheckBox();
        cb.setText(StringUtils.stripMnemonic((String)label));
        cb.setMnemonic(StringUtils.getMnemonicKeyCode((String)label));
        return cb;
    }

    private String[] commit() {
        ArrayList<String> resultList = new ArrayList<String>();
        JMutableTreeNode root = (JMutableTreeNode)this.tree.getModel().getRoot();
        Enumeration en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            Object userObj;
            JMutableTreeNode node = (JMutableTreeNode)en.nextElement();
            JTreeCellData data = node.getModel();
            if (data == null || !((userObj = data.getUserObject()) instanceof Library) || data.getCheckBoxState() != TriStateBoolean.FALSE) continue;
            resultList.add(((Library)userObj).getID().toString());
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    private void invalidateLibrayToolkitHelperCache() {
        LibraryToolkitHelper helper = CommonEditor.getLibraryToolkitHelper((Namespace)this._tc);
        if (helper != null) {
            helper.invalidateCache();
        }
    }

    public void cellChecked(TreeCellCheckedEvent e) {
        this.invalidateLibrayToolkitHelperCache();
    }

    public void cellUnchecked(TreeCellCheckedEvent e) {
        this.invalidateLibrayToolkitHelperCache();
    }

    @Override
    public void itemStateChanged(ItemEvent event) {
        this.invalidateLibrayToolkitHelperCache();
        this.load();
    }
}

