/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import oracle.ide.model.Element;
import oracle.ide.model.Locatable;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.model.J2eeSettings;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.deploy.common.JProjectSelectionFilter;

public class JavaSelectionFilter
extends JProjectSelectionFilter {
    private transient URL _htmlRootDir;
    private boolean _checkHtmlRoot = false;

    @Override
    public boolean canBeSelected(Element element) {
        if (this._checkHtmlRoot && element instanceof Locatable) {
            URL url = ((Locatable)element).getURL();
            return URLFileSystem.toRelativeSpec((URL)url, (URL)this._htmlRootDir, (boolean)true) == null;
        }
        return true;
    }

    @Override
    protected void setProject(Project project) {
        super.setProject(project);
        this._htmlRootDir = J2eeSettings.getInstance(project).getHtmlRootDirectory();
        URLPath sourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
        this._checkHtmlRoot = !sourcePath.contains(this._htmlRootDir);
    }
}

