/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.util.Namespace;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.Profile;

public class DependencyGraph {
    static final String DATA_KEY = DependencyGraph.class.getName();
    protected final ProfileDependable rootDependable_;
    private transient ArrayList exceptions_;
    private transient Dependable[] dependables_;

    DependencyGraph(ProfileDependable root) {
        this.rootDependable_ = root;
        this.buildGraph();
    }

    DependencyGraph(Profile profile) throws IllegalAccessException, InstantiationException {
        this((ProfileDependable)Deployment.getDependableFactory().findOrCreate((Element)profile, (Folder)profile.getDataContainer()));
    }

    protected void buildGraph() {
        ArrayList<Dependable> dependables = new ArrayList<Dependable>();
        ArrayList<Dependable> cycles = new ArrayList<Dependable>();
        dependables.add(this.rootDependable_);
        this.buildGraphImpl(this.rootDependable_, dependables, cycles);
        Collections.reverse(dependables);
        this.dependables_ = dependables.toArray(new Dependable[dependables.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildGraphImpl(ProfileDependable root, ArrayList<Dependable> dependables, ArrayList<Dependable> cycles) {
        try {
            this.push(root, cycles);
            Profile profile = root.getProfile();
            Dependable[] depsFromProfile = DeployUtil.getDependables((Interdependency)profile, Dependable.class);
            for (int i = 0; i < depsFromProfile.length; ++i) {
                ProfileDependable profDep;
                Dependable dep = depsFromProfile[i];
                if (dep instanceof ProfileDependable && !((ProfileDependable)dep).doesExist() || dep instanceof NodeDependable && !((NodeDependable)dep).doesExist()) continue;
                if (cycles.contains(dep)) {
                    this.cacheException(new DependencyCycleException(cycles, dep));
                    continue;
                }
                if (dependables.contains(dep)) continue;
                dependables.add(dep);
                if (!(dep instanceof ProfileDependable) || !(profDep = (ProfileDependable)dep).doesExist()) continue;
                this.buildGraphImpl(profDep, dependables, cycles);
            }
        }
        catch (Exception e) {
            this.cacheException(e);
        }
        finally {
            this.pop(cycles);
        }
    }

    public Profile[] getProfiles() {
        ProfileDependable[] profileDependables = this.getDependables(ProfileDependable.class);
        Profile[] profiles = new Profile[profileDependables.length];
        for (int i = 0; i < profiles.length; ++i) {
            profiles[i] = profileDependables[i].getProfile();
        }
        return profiles;
    }

    public <T> T[] getDependables(Class<T> clazz) {
        if (clazz == Dependable.class) {
            return this.dependables_;
        }
        ArrayList<Dependable> filtered = new ArrayList<Dependable>();
        for (int i = 0; i < this.dependables_.length; ++i) {
            if (!clazz.isAssignableFrom(this.dependables_[i].getClass())) continue;
            filtered.add(this.dependables_[i]);
        }
        return filtered.toArray((Object[])Array.newInstance(clazz, filtered.size()));
    }

    public Dependable[] getAllDependables() {
        return this.getDependables(Dependable.class);
    }

    public Exception[] getExceptions() {
        if (this.exceptions_ == null || this.exceptions_.size() == 0) {
            return new Exception[0];
        }
        return this.exceptions_.toArray(new Exception[this.exceptions_.size()]);
    }

    public static DependencyGraph findInNamespace(Namespace namespace) {
        DependencyGraph graph = (DependencyGraph)namespace.find(DATA_KEY);
        return graph;
    }

    private void push(Dependable dep, ArrayList<Dependable> list) {
        list.add(dep);
    }

    private void pop(ArrayList<Dependable> list) {
        list.remove(list.size() - 1);
    }

    protected void cacheException(Exception e) {
        if (this.exceptions_ == null) {
            this.exceptions_ = new ArrayList();
        }
        this.exceptions_.add(e);
    }

    public static class DependencyCycleException
    extends Exception {
        private final ArrayList<Dependable> cycle_ = new ArrayList();

        DependencyCycleException(ArrayList<Dependable> stack, Dependable duplicate) {
            int i = stack.indexOf(duplicate);
            while (i < stack.size()) {
                this.cycle_.add(stack.get(i++));
            }
            this.cycle_.add(duplicate);
        }

        public Dependable[] getCycle() {
            return this.cycle_.toArray(new Dependable[this.cycle_.size()]);
        }

        @Override
        public String getMessage() {
            StringBuffer sbuf = new StringBuffer("Warning: Cyclic dependency: ");
            for (int i = 0; i < this.cycle_.size(); ++i) {
                Dependable dep = this.cycle_.get(i);
                if (i != 0) {
                    sbuf.append(" -> ");
                }
                sbuf.append(dep.getSource());
                sbuf.append("(");
                sbuf.append(dep.getSourceOwner());
                sbuf.append(")");
            }
            return sbuf.toString();
        }
    }
}

