/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import oracle.ide.model.Dependable;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.HashStructureAdapter;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.deploy.common.Interdependency;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;

public class DependableContainer
extends HashStructureAdapter
implements Interdependency {
    private List _dependencyList;
    public static String DEPENDENCY_KEY = "dependencyList";

    public DependableContainer() {
        this(HashStructure.newInstance());
    }

    public DependableContainer(HashStructure hash) {
        super(hash);
        this.initDependencyList();
    }

    private void initDependencyList() {
        ListStructure list = this._hash.getListStructure(DEPENDENCY_KEY);
        this._dependencyList = new ArrayList();
        if (list != null) {
            int n = list.size();
            for (int i = 0; i < n; ++i) {
                HashStructure dependableHash = (HashStructure)list.get(i);
                try {
                    Dependable dependable = AbstractHashDependable.createDependable(dependableHash);
                    this._dependencyList.add(dependable);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public Iterator<Dependable> getDependencies() {
        return this._dependencyList.iterator();
    }

    @Override
    public void addDependency(Dependable dependable) {
        if (this._dependencyList.contains(dependable)) {
            this.removeDependency(dependable);
        }
        ListStructure list = this._hash.getOrCreateListStructure(DEPENDENCY_KEY);
        list.add((Object)((AbstractHashDependable)dependable).getHashStructure());
        this._dependencyList.add(dependable);
    }

    private int getDependableIndex(Dependable dependable) {
        return this._dependencyList.indexOf(dependable);
    }

    @Override
    public Dependable removeDependency(Dependable dependable) {
        ListStructure list = this._hash.getListStructure(DEPENDENCY_KEY);
        int index = this.getDependableIndex(dependable);
        if (index != -1) {
            list.remove(index);
            this._dependencyList.remove(index);
        }
        return dependable;
    }
}

