/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import oracle.ide.index.Index;
import oracle.ide.index.IndexManager;
import oracle.ide.index.QueryCriteria;
import oracle.ide.index.task.BackgroundTask;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Locatable;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.common.ArchiveElement;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.dt.AbstractHashDependable;

public class DefaultNodeDependable
extends AbstractHashDependable
implements NodeDependable,
ArchiveElement {
    protected Node source_;
    protected Folder owner_;

    public DefaultNodeDependable(Node source, Folder owner) {
        this.source_ = source;
        this.owner_ = owner;
        this._hash.putURL("sourceURL", source.getURL());
        if (owner instanceof Locatable) {
            this._hash.putURL("ownerURL", ((Locatable)owner).getURL());
        }
        this.setReload(false);
    }

    public DefaultNodeDependable(HashStructure hash) {
        super(hash);
    }

    @Override
    public URL getNodeURL() {
        return this._hash.getURL("sourceURL");
    }

    @Override
    public Iterator getDependencies() {
        return Arrays.asList(new Object[0]).iterator();
    }

    @Override
    public Node getNode() {
        return (Node)this.getSource();
    }

    @Override
    public boolean doesExist() {
        if (this.source_ != null && NodeFactory.find((URL)this.source_.getURL()) != null) {
            return true;
        }
        return URLFileSystem.exists((URL)this.getNodeURL());
    }

    @Override
    @Deprecated
    public String getPathInArchive() {
        return this._hash.getString("pathInEar");
    }

    @Override
    @Deprecated
    public void setPathInArchive(String path) {
        this._hash.putString("pathInEar", path);
    }

    @Override
    public boolean cache() {
        this.cacheImpl();
        return this.source_ != null && this.owner_ != null;
    }

    @Override
    protected Element getSourceImpl() {
        return this.source_;
    }

    @Override
    protected Folder getSourceOwnerImpl() {
        return this.owner_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cacheImpl() {
        block10: {
            try {
                URL sourceURL = this._hash.getURL("sourceURL");
                URL ownerURL = this._hash.getURL("ownerURL");
                this.owner_ = (Folder)NodeFactory.find((URL)ownerURL);
                this.source_ = null;
                if (this.owner_ == null) break block10;
                if (!(this.owner_ instanceof Project)) {
                    this.source_ = NodeFactory.findInFolder((Folder)this.owner_, (URL)sourceURL);
                    break block10;
                }
                Index index = IndexManager.getIndexManager().getIndex((Project)this.owner_);
                QueryCriteria criteria = new QueryCriteria();
                String name = URLFileSystem.getName((URL)sourceURL);
                String suffix = URLFileSystem.getSuffix((URL)sourceURL);
                criteria.put((Object)"file.name", (Object)name);
                criteria.put((Object)"file.extension", (Object)suffix);
                BackgroundTask query = index.query(criteria);
                try {
                    URL[] results = (URL[])query.get();
                    boolean urlFound = false;
                    for (URL url : results) {
                        if (!url.getPath().equals(sourceURL.getPath())) continue;
                        urlFound = true;
                        break;
                    }
                    if (urlFound) {
                        this.source_ = NodeFactory.findOrCreate((URL)sourceURL);
                    }
                }
                catch (Exception e) {
                    return;
                }
                finally {
                    index.release();
                }
            }
            catch (Exception e) {
                this.source_ = null;
                this.owner_ = null;
            }
        }
    }
}

