/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.io.PrintWriter;
import java.net.URL;
import java.util.Map;
import oracle.ide.log.LogPage;
import oracle.ide.log.LogPrintWriter;
import oracle.ide.net.URLTempFile;
import oracle.ide.runner.SimpleProcess;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdevimpl.deploy.CommandLineTokenizer;
import oracle.jdevimpl.deploy.res.ToolsArb;

public class CommandLine {
    private final PrintWriter _log;
    private final LogPage _logPage;

    public CommandLine() {
        this(null);
    }

    public CommandLine(PrintWriter log) {
        if (log == null) {
            this._log = null;
            this._logPage = null;
        } else {
            this._log = log;
            this._logPage = this._log instanceof LogPrintWriter ? ((LogPrintWriter)this._log).getWrappedLogPage() : Deployment.getLogPage();
        }
    }

    public SimpleProcess createSimpleProcess(String cmdLine, Map macros, String title) {
        return this.createSimpleProcess(cmdLine, macros, title, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SimpleProcess createSimpleProcess(String cmdLine, Map macros, String title, String passwordSuppress) {
        CommandLineTokenizer clTok = new CommandLineTokenizer();
        String[] args = clTok.toArgs(cmdLine, macros);
        SimpleProcess sp = new SimpleProcess(args);
        LogPage logPage = this.getLogPage();
        if (logPage != null) {
            sp.setLogPage(logPage);
        }
        if (title != null) {
            sp.setLabel(title);
        }
        if (passwordSuppress != null) {
            String password = macros.put(passwordSuppress, ToolsArb.getString(17));
            String[] argsNoPass = null;
            try {
                argsNoPass = clTok.toArgs(cmdLine, macros);
                sp.setCommandStringForLog(ModelUtil.concat((String[])argsNoPass));
            }
            finally {
                macros.put(passwordSuppress, password);
            }
        }
        return sp;
    }

    protected final PrintWriter getLog() {
        return this._log;
    }

    protected final LogPage getLogPage() {
        return this._logPage;
    }

    protected final void logln(String line) {
        if (this._logPage != null) {
            this._logPage.log((Object)(line + "\n"));
        }
    }

    protected final void log(Object mesg) {
        if (this._logPage != null) {
            this._logPage.log(mesg);
        }
    }

    protected void addToMacros(Map macros) {
    }

    protected final void addToMacros(Map macros, URL earFile, String j2eeAppName) {
        this.addToMacros(macros);
        URLTempFile urlTempFile = new URLTempFile(earFile);
        macros.put(urlTempFile, urlTempFile);
        macros.put("ear.file", urlTempFile.getFile().getAbsolutePath());
        macros.put("j2ee.app.name", j2eeAppName);
    }
}

