/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.common.SelectedArchives;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.LibrarySelectionPanel;
import oracle.jdevimpl.deploy.res.CommonArb;

public class CdaPanel
extends DefaultTraversablePanel
implements GridBagConstants {
    private final LibrarySelectionPanel libPanel = new LibrarySelectionPanel();
    private final JRadioButton rbExpandedAndIncluded = new JRadioButton();
    private final JRadioButton rbIncludedAsJars = new JRadioButton();
    private final JRadioButton rbAddedToClassPath = new JRadioButton();

    public CdaPanel() {
        JLabel lblMode = new JLabel();
        ResourceUtils.resLabel((JLabel)lblMode, (Component)this.libPanel.getLabelFor(), (String)CommonArb.getString(52));
        JLabel lblHowShouldLibrariesBeUsed = new JLabel(CommonArb.getString(55));
        ResourceUtils.resButton((AbstractButton)this.rbAddedToClassPath, (String)CommonArb.getString(53));
        ResourceUtils.resButton((AbstractButton)this.rbIncludedAsJars, (String)CommonArb.getString(56));
        ResourceUtils.resButton((AbstractButton)this.rbExpandedAndIncluded, (String)CommonArb.getString(54));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.rbExpandedAndIncluded);
        buttonGroup.add(this.rbIncludedAsJars);
        buttonGroup.add(this.rbAddedToClassPath);
        this.rbExpandedAndIncluded.setSelected(true);
        this.setLayout(new GridBagLayout());
        Insets insets = new Insets(5, 5, 5, 5);
        Insets rbInsets = new Insets(0, 20, 5, 5);
        this.add(lblMode, this.gbc(0, 0, 1, 1, 0.0, 0.0, 18, 0, insets));
        this.add((Component)((Object)this.libPanel), this.gbc(0, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 5, 5, 5)));
        this.add(lblHowShouldLibrariesBeUsed, this.gbc(0, 2, 1, 1, 0.0, 0.0, 18, 0, insets));
        this.add(this.rbExpandedAndIncluded, this.gbc(0, 3, 1, 1, 0.0, 0.0, 18, 0, rbInsets));
        this.add(this.rbIncludedAsJars, this.gbc(0, 4, 1, 1, 0.0, 0.0, 18, 0, rbInsets));
        this.add(this.rbAddedToClassPath, this.gbc(0, 5, 1, 1, 0.0, 0.0, 18, 0, rbInsets));
        this.setHelpID("f1_depfgdalibcont_html");
    }

    public void onEntry(TraversableContext tc) {
        this.libPanel.onEntry(tc);
        CdaSettings cdas = CdaPanel.findCdaSettings(tc);
        SelectedArchives sa = cdas.getSelectedArchives();
        int selectionMode = sa.getSelectionMode();
        switch (selectionMode) {
            case 1: {
                this.rbIncludedAsJars.setSelected(true);
                break;
            }
            case 2: {
                this.rbAddedToClassPath.setSelected(true);
                break;
            }
            default: {
                this.rbExpandedAndIncluded.setSelected(true);
            }
        }
    }

    public void onExit(TraversableContext tc) {
        this.libPanel.onExit(tc);
        CdaSettings cdas = CdaPanel.findCdaSettings(tc);
        SelectedArchives sa = cdas.getSelectedArchives();
        if (this.rbExpandedAndIncluded.isSelected()) {
            sa.setSelectionMode(0);
        } else if (this.rbIncludedAsJars.isSelected()) {
            sa.setSelectionMode(1);
        } else {
            sa.setSelectionMode(2);
        }
    }

    private static CdaSettings findCdaSettings(TraversableContext tc) {
        ProjectFileGroup pfg = FileGroupsEditor.getProjectFileGroup((Namespace)tc);
        return pfg.getFilters();
    }
}

