/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.util.ResourceUtils;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.res.UtilArb;

public class CdaPacketPanel
extends JPanel
implements GridBagConstants,
ListSelectionListener,
ListCellRenderer {
    private JScrollPane jScrollPane1 = new JScrollPane();
    private JLabel urlLabel = new JLabel();
    private JTextField tfURL = new JTextField();
    private JList jList1 = new JList();
    private DefaultListCellRenderer defaultRenderer = new DefaultListCellRenderer();
    private transient CdaPacket curPacket = null;

    public CdaPacketPanel() {
        ResourceUtils.resLabel((JLabel)this.urlLabel, (Component)this.tfURL, (String)UtilArb.getString(6));
        this.tfURL.setEditable(false);
        this.tfURL.setOpaque(false);
        this.jList1.addListSelectionListener(this);
        this.jList1.setCellRenderer(this);
        this.jList1.setSelectionMode(0);
        this.jScrollPane1.getViewport().add((Component)this.jList1, null);
        this.setLayout(new GridBagLayout());
        Insets in5555 = new Insets(5, 5, 5, 5);
        this.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 2, 1, 1.0, 1.0, 10, 1, in5555, 0, 0));
        this.add((Component)this.urlLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, in5555, 0, 0));
        this.add((Component)this.tfURL, new GridBagConstraints(1, 1, 1, 1, 1.0, 0.0, 17, 2, in5555, 0, 0));
    }

    public void load(CdaPacket[] cdaPackets) {
        ArrayList<CdaPacket> list = new ArrayList<CdaPacket>();
        for (CdaPacket packet : cdaPackets) {
            if (packet == null) continue;
            list.add(packet);
        }
        this.jList1.setListData(list.toArray());
    }

    public void load(Iterator<ArchiveEntry> archiveEntries) {
        ArrayList<ArchiveEntry> list = new ArrayList<ArchiveEntry>();
        while (archiveEntries != null && archiveEntries.hasNext()) {
            ArchiveEntry entry = archiveEntries.next();
            if (entry == null) continue;
            list.add(entry);
        }
        this.jList1.setListData(list.toArray());
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        Object selectedValue = this.jList1.getSelectedValue();
        if (selectedValue != this.curPacket) {
            ArchiveEntry archiveEntry = (ArchiveEntry)selectedValue;
            URL url = archiveEntry.getURL();
            this.tfURL.setText(url != null ? url.toString() : UtilArb.getString(7));
        }
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        boolean urlIsNull = false;
        try {
            ArchiveEntry archiveEntry = (ArchiveEntry)value;
            urlIsNull = archiveEntry.getURL() == null;
        }
        catch (ClassCastException e) {
            e.printStackTrace();
        }
        this.defaultRenderer.getListCellRendererComponent((JList<?>)list, value, index, isSelected && !urlIsNull, cellHasFocus);
        if (urlIsNull) {
            this.defaultRenderer.setForeground(Color.red);
        }
        return this.defaultRenderer;
    }
}

