/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.common;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.Context;
import oracle.ide.model.Element;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.deploy.tk.Toolkit;
import oracle.jdeveloper.deploy.tk.ToolkitBuilder;
import oracle.jdeveloper.deploy.tk.ToolkitRegistry;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;
import oracle.jdevimpl.deploy.common.LibraryToolkit;
import oracle.jdevimpl.deploy.res.CommonArb;

public abstract class AbstractDependentLibraryBuilder
extends AbstractToolkitBuilder {
    private Element _element;
    private Map<Element, LibraryToolkit> _builtElements = new LinkedHashMap<Element, LibraryToolkit>();
    private boolean _preBuiltLibraryToolkitFound = false;
    private LibraryToolkit _preBuiltLibraryToolkit;
    private IndeterminateProgressMonitor _progressMonitor = null;
    protected static final String BUILT_ELEMENTS = "BUILT_ELEMENTS";
    protected static final String TRAVERSE_DEPENDENCIES = "traverseDependencies";
    protected static final String REPORT_PROFILE_AS_LIBRARY = "ReportProfileAsLibrary";
    protected static final String ORIGINAL_BUILD_ELEMENT = "OriginalBuildElement";
    protected static final String PREBUILT_LIBRARY_TOOLKIT = "PreBuiltLibraryToolkit";

    public AbstractDependentLibraryBuilder(Class<? extends Toolkit> tkClass, ToolkitContext tkContext) {
        super(tkClass, tkContext);
        Object builtElementsObject;
        Object reportProfilesAsLibraries;
        Context context = tkContext.getIdeContext();
        this._element = context.getElement();
        Object originatingElementObject = context.getProperty(ORIGINAL_BUILD_ELEMENT);
        if (originatingElementObject == null) {
            context.setProperty(ORIGINAL_BUILD_ELEMENT, (Object)this._element);
        }
        if ((reportProfilesAsLibraries = context.getProperty(REPORT_PROFILE_AS_LIBRARY)) == null) {
            context.setBoolean(REPORT_PROFILE_AS_LIBRARY, Boolean.TRUE.booleanValue());
        }
        if ((builtElementsObject = context.getProperty(BUILT_ELEMENTS)) != null && builtElementsObject instanceof Map) {
            this._builtElements = (Map)builtElementsObject;
        }
        if (!this._builtElements.containsKey(this._element)) {
            this._builtElements.put(this._element, null);
        }
        this._progressMonitor = (IndeterminateProgressMonitor)context.getProperty("ProgressMonitor");
        if (this._progressMonitor != null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    AbstractDependentLibraryBuilder.this._progressMonitor.getPanel().setNote(CommonArb.getString(139) + " " + AbstractDependentLibraryBuilder.this._element.getShortLabel());
                }
            });
        }
    }

    @Override
    protected final Toolkit build() {
        if (this.isProcessCancelled()) {
            return null;
        }
        LibraryToolkit libraryToolkit = this.buildImpl();
        this._builtElements.put(this.getElement(), libraryToolkit);
        return libraryToolkit;
    }

    protected abstract LibraryToolkit buildImpl();

    protected boolean isProcessCancelled() {
        if (this._progressMonitor == null) {
            return false;
        }
        return this._progressMonitor.isCancelled();
    }

    protected Element getOriginalBuildElement() {
        return (Element)this.getIdeContext().getProperty(ORIGINAL_BUILD_ELEMENT);
    }

    protected Element getElement() {
        return this._element;
    }

    protected Context getIdeContext() {
        return this.getBuilderContext().getIdeContext();
    }

    protected LibraryToolkit[] buildLibraryToolkits(Context context) {
        ArrayList<LibraryToolkit> libraryToolkits = new ArrayList<LibraryToolkit>();
        if (!this.isProcessCancelled()) {
            context.setProperty("ProgressMonitor", (Object)this._progressMonitor);
            context.setProperty(BUILT_ELEMENTS, this._builtElements);
            context.setProperty(ORIGINAL_BUILD_ELEMENT, (Object)this.getOriginalBuildElement());
            this.setupPreBuiltLibraryToolkit(context.getElement());
            if (this._preBuiltLibraryToolkitFound && this._preBuiltLibraryToolkit == null) {
                return new LibraryToolkit[0];
            }
            context.setProperty(PREBUILT_LIBRARY_TOOLKIT, (Object)this._preBuiltLibraryToolkit);
            ToolkitRegistry reg = this.getBuilderContext().getMainToolkitRegistry();
            try {
                Object[] built;
                ToolkitBuilder builder = reg.getBuilder(context.getElement(), context, LibraryToolkit.class);
                if (builder != null && (built = builder.narrowBuildToolkits()) != null) {
                    for (Object object : built) {
                        if (!(object instanceof LibraryToolkit)) continue;
                        libraryToolkits.add((LibraryToolkit)object);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return libraryToolkits.toArray(new LibraryToolkit[0]);
    }

    private void setupPreBuiltLibraryToolkit(Element element) {
        this._preBuiltLibraryToolkitFound = false;
        this._preBuiltLibraryToolkit = null;
        for (Element elem : this._builtElements.keySet()) {
            if (!elem.equals(element)) continue;
            this._preBuiltLibraryToolkitFound = true;
            this._preBuiltLibraryToolkit = this._builtElements.get(elem);
            return;
        }
    }
}

