/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controller.Menubar;
import oracle.ide.controls.ToggleAction;
import oracle.ide.feedback.FeedbackManager;
import oracle.ide.gallery.GalleryManager;
import oracle.ide.gallery.ObjectGallery;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.view.View;
import oracle.javatools.dialogs.MessageDialog;
import oracle.jdeveloper.JDeveloperMenuConstants;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.dt.DeployMenuManager;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.dt.wizard.DeployWizard;
import oracle.jdeveloper.deploy.prf.ProfileBuilder;
import oracle.jdeveloper.deploy.prf.ProfileRecognizer;
import oracle.jdevimpl.deploy.DeployCommandHistory;
import oracle.jdevimpl.deploy.res.DtArb;

public class DeployMenuManager
extends oracle.jdeveloper.deploy.dt.DeployMenuManager {
    private ArrayList<DeployMenuManager.MenuListener> cmListeners_ = new ArrayList();
    private boolean showProfiles_ = true;
    private boolean showHistory_ = true;
    private int maximumHistory_ = 5;
    private JMenu appnavDeployMenu_;
    private JMenu buildDeployMenu_;
    private JMenu appDeployMenu_;

    void install() {
        this.addMenuListener(new NewProfileMenuBuilder());
        this.addMenuListener(new ProfilesMenuBuilder());
        this.addMenuListener(new HistoryMenuBuilder());
        String prop = String.valueOf(System.getProperty("deployment.features"));
        if (prop.matches("(\\w*,)*defaultProfiles(,\\w*)*")) {
            this.addMenuListener(new DefaultProfilesMenuBuilder());
        }
        ContextMenu cm = NavigatorManager.getApplicationNavigatorManager().getContextMenu();
        cm.addContextMenuListener((ContextMenuListener)new IdeContextMenuListener(this.getAppNavigatorDeployMenu((MenuManager)cm)));
        Menubar menuMgr = Ide.getMenubar();
        JMenu buildMenu = MenuManager.getJMenu((String)"Build");
        menuMgr.add((Component)this.getBuildDeployMenu(), buildMenu, JDeveloperMenuConstants.SECTION_BUILD_TOOLS);
        this.getBuildDeployMenu().addMenuListener(new BuildDeployMenuListener((MenuManager)menuMgr));
        JMenu applicationMenu = MenuManager.getJMenu((String)"APPLICATION_MENU");
        assert (applicationMenu != null);
        menuMgr.add((Component)this.getApplicationDeployMenu(), applicationMenu);
        this.getApplicationDeployMenu().addMenuListener(new ApplicationDeployMenuListener((MenuManager)menuMgr));
    }

    private JMenu getBuildDeployMenu() {
        if (this.buildDeployMenu_ == null) {
            Menubar menuMgr = Ide.getMenubar();
            this.buildDeployMenu_ = menuMgr.createSubMenu(DtArb.getString(21), DtArb.getInteger(22), JDeveloperMenuConstants.SECTION_BUILD_MAKE);
            MenuManager.setMenuId((JMenu)this.buildDeployMenu_, (String)"build.deploymenu");
        }
        return this.buildDeployMenu_;
    }

    private JMenu getAppNavigatorDeployMenu(MenuManager menuMgr) {
        if (this.appnavDeployMenu_ == null) {
            this.appnavDeployMenu_ = menuMgr.createSubMenu(DtArb.getString(21), DtArb.getInteger(22));
        }
        return this.appnavDeployMenu_;
    }

    private JMenu getApplicationDeployMenu() {
        if (this.appDeployMenu_ == null) {
            Menubar menuMgr = Ide.getMenubar();
            float weight = 1005.0f;
            Float section = menuMgr.lookupMenuSection("APPLICATION_MENU", "APPLICATION_MENU_SECTION_FOUR");
            this.appDeployMenu_ = menuMgr.createSubMenu(DtArb.getString(21), DtArb.getInteger(22), weight, section.floatValue());
            MenuManager.setMenuId((JMenu)this.appDeployMenu_, (String)"application.deploymenu");
        }
        return this.appDeployMenu_;
    }

    @Override
    public void addMenuListener(DeployMenuManager.MenuListener listener) {
        this.cmListeners_.add(listener);
    }

    @Override
    public boolean removeMenuListener(DeployMenuManager.MenuListener listener) {
        return this.cmListeners_.remove(listener);
    }

    @Override
    public JMenu getDeployMenu(MenuManager mgr, Context ideContext) {
        JMenu menu = this.getAppNavigatorDeployMenu(mgr);
        this.menuWillShow(menu, mgr, ideContext);
        return menu;
    }

    static boolean runCommand(DeployCommand command) {
        if (command.getStatus() != DeployCommand.Status.READY) {
            MessageDialog.critical((Component)Ide.getMainWindow(), (Object)DtArb.getString(144), (String)DtArb.getString(145), null);
            return false;
        }
        try {
            CommandProcessor.getInstance().invoke((Command)command);
        }
        catch (Exception e) {
            FeedbackManager.reportException((Throwable)e);
        }
        return true;
    }

    private void menuWillShow(JMenu menu, MenuManager menuMgr, Context context) {
        menu.removeAll();
        for (DeployMenuManager.MenuListener l : this.cmListeners_) {
            l.menuWillShow(menu, menuMgr, context);
        }
    }

    private void menuWillHide(JMenu menu, MenuManager menuMgr, Context context) {
        for (DeployMenuManager.MenuListener l : this.cmListeners_) {
            l.menuWillHide(menu, menuMgr, context);
        }
    }

    private void maybeAddHint(JMenu menu) {
        if (menu.getItemCount() == 0) {
            JMenuItem mi = new JMenuItem(DtArb.getString(147));
            mi.setEnabled(false);
            menu.add(mi);
        }
    }

    private class ApplicationDeployMenuListener
    extends BuildDeployMenuListener {
        ApplicationDeployMenuListener(MenuManager menuMgr) {
            super(menuMgr);
        }

        @Override
        protected Context makeContext() {
            Context ctx = super.makeContext();
            ctx.setElement((Element)ctx.getWorkspace());
            return ctx;
        }
    }

    private class BuildDeployMenuListener
    implements MenuListener {
        final MenuManager menuMgr_;

        BuildDeployMenuListener(MenuManager menuMgr) {
            this.menuMgr_ = menuMgr;
        }

        @Override
        public void menuSelected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            DeployMenuManager.this.menuWillShow(menu, this.menuMgr_, this.makeContext());
            DeployMenuManager.this.maybeAddHint(menu);
        }

        protected Context makeContext() {
            return Context.newIdeContext();
        }

        @Override
        public void menuDeselected(MenuEvent e) {
            JMenu menu = (JMenu)e.getSource();
            DeployMenuManager.this.menuWillHide(menu, this.menuMgr_, this.makeContext());
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }

    private class IdeContextMenuListener
    implements ContextMenuListener {
        JMenu menu_;
        MenuListener listener_;

        IdeContextMenuListener(JMenu menu) {
            this.menu_ = menu;
        }

        public void menuWillShow(final ContextMenu contextMenu) {
            Class<?> c = contextMenu.getContext().getElement().getClass();
            if (c != Project.class && c != Workspace.class) {
                return;
            }
            View v = contextMenu.getContext().getView();
            if (!"ApplicationNavigatorWindow.ApplicationNavigatorName".equals(v.getId()) && !(v instanceof ProjectNavigatorWindow)) {
                return;
            }
            contextMenu.add((Component)this.menu_, MenuConstants.SECTION_BUILD_CTXT_MENU);
            this.listener_ = new MenuListener(){

                @Override
                public void menuSelected(MenuEvent e) {
                    DeployMenuManager.this.menuWillShow(IdeContextMenuListener.this.menu_, (MenuManager)contextMenu, contextMenu.getContext());
                    DeployMenuManager.this.maybeAddHint(IdeContextMenuListener.this.menu_);
                }

                @Override
                public void menuDeselected(MenuEvent e) {
                    DeployMenuManager.this.menuWillHide(IdeContextMenuListener.this.menu_, (MenuManager)contextMenu, contextMenu.getContext());
                }

                @Override
                public void menuCanceled(MenuEvent e) {
                }
            };
            this.menu_.addMenuListener(this.listener_);
        }

        public void menuWillHide(ContextMenu contextMenu) {
            if (this.listener_ != null) {
                this.menu_.removeMenuListener(this.listener_);
                this.listener_ = null;
            }
        }

        public boolean handleDefaultAction(Context context) {
            for (DeployMenuManager.MenuListener l : DeployMenuManager.this.cmListeners_) {
                if (!l.handleDefaultAction(context)) continue;
                return true;
            }
            return false;
        }
    }

    private static class HistoryAction
    extends ToggleAction {
        final DeployCommand command;

        HistoryAction(DeployCommand cmd, int position) {
            super(HistoryAction.label(cmd, position), cmd.getIcon());
            this.command = cmd;
            this.setEnabled(this.command.getStatus() == DeployCommand.Status.READY);
            this.putValue("menu-addin-section-id", Float.valueOf(20.0f));
        }

        public void actionPerformed(ActionEvent e) {
            DeployMenuManager.runCommand(this.command);
        }

        private static String label(DeployCommand cmd, int pos) {
            return String.format("&%-2d %s", pos, cmd.getLongLabel());
        }
    }

    private static class ProfileAction
    extends ToggleAction {
        final Profile profile;
        final Context context;
        final DataContainer container;

        ProfileAction(Profile p, Context c, DataContainer dc) {
            super(p.getName() + "...", null);
            this.context = c;
            this.profile = p;
            this.container = dc;
            this.putValue("menu-section-id", Float.valueOf(10.0f));
        }

        public void actionPerformed(ActionEvent e) {
            DeployCommand command;
            this.context.setElement((Element)this.profile);
            DeployWizard wizard = new DeployWizard();
            if (wizard.invoke(this.context) && DeployMenuManager.runCommand(command = wizard.getCommand())) {
                DeployCommandHistory history = DeployCommandHistory.getInstance(this.container);
                history.addCommand(command);
            }
        }
    }

    private static class NewProfileAction
    extends ToggleAction {
        private static final String GALLERY_CATEGORY_KEY = "Deployment Profiles";
        final Context context_;

        NewProfileAction(Context context) {
            super(DtArb.getString(23), null);
            this.context_ = context;
        }

        public void actionPerformed(ActionEvent e) {
            ObjectGallery gallery;
            GalleryManager gm = GalleryManager.getGalleryManager();
            if (gm != null && (gallery = gm.getGallery()) != null) {
                gallery.runDialog(this.context_, GALLERY_CATEGORY_KEY, null);
            }
        }
    }

    private class HistoryMenuBuilder
    implements DeployMenuManager.MenuListener {
        private HistoryMenuBuilder() {
        }

        @Override
        public void menuWillShow(JMenu menu, MenuManager mgr, Context context) {
            if (!DeployMenuManager.this.showHistory_) {
                return;
            }
            if (context.getElement() instanceof DataContainer) {
                DataContainer dc = (DataContainer)context.getElement();
                DeployCommandHistory history = DeployCommandHistory.getInstance(dc);
                Iterator<DeployCommand> iter = history.iterator();
                int i = 1;
                while (iter.hasNext()) {
                    if (i == 1) {
                        menu.addSeparator();
                    }
                    DeployCommand cmd = iter.next();
                    cmd.setContext(context);
                    HistoryAction action = new HistoryAction(cmd, i);
                    menu.add((Action)((Object)action));
                    ++i;
                }
            }
        }

        @Override
        public void menuWillHide(JMenu menu, MenuManager mgr, Context context) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class ProfilesMenuBuilder
    implements DeployMenuManager.MenuListener {
        private ProfilesMenuBuilder() {
        }

        @Override
        public void menuWillShow(JMenu menu, MenuManager menuMgr, Context context) {
            if (!DeployMenuManager.this.showProfiles_) {
                return;
            }
            if (context.getElement() instanceof DataContainer) {
                DataContainer dc = (DataContainer)context.getElement();
                DeploymentProfiles profiles = DeploymentProfiles.getInstance(dc);
                for (Object o : profiles.getProfileNames()) {
                    Profile p = profiles.getProfileByName((String)o);
                    if (p == null) continue;
                    ProfileAction action = new ProfileAction(p, context, dc);
                    JMenuItem item = menuMgr.createMenuItem((ToggleAction)action);
                    menu.add(item);
                }
            }
        }

        @Override
        public void menuWillHide(JMenu menu, MenuManager menuMgr, Context context) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }

    private class DefaultProfilesMenuBuilder
    implements DeployMenuManager.MenuListener,
    Controller {
        final int DEPLOY_DEFAULT_PROFILE_CMD = Ide.findOrCreateCmdID((String)"Deployment.deployDefaultProfiles");
        final String DEPLOY_DEFAULT_PROFILE_MENULABEL = DtArb.getString(146);
        transient boolean defaultDeploymentRunning_ = false;
        final IdeAction deployDefaultProfileAction_ = IdeAction.get((int)this.DEPLOY_DEFAULT_PROFILE_CMD, (String)StringUtils.stripMnemonic((String)this.DEPLOY_DEFAULT_PROFILE_MENULABEL), (Integer)StringUtils.getMnemonicIndex((String)this.DEPLOY_DEFAULT_PROFILE_MENULABEL));

        DefaultProfilesMenuBuilder() {
            this.deployDefaultProfileAction_.addController((Controller)this);
        }

        @Override
        public void menuWillShow(JMenu menu, MenuManager mgr, Context context) {
            if (context.getElement() instanceof DataContainer) {
                menu.add((Action)this.deployDefaultProfileAction_);
            }
        }

        @Override
        public void menuWillHide(JMenu menu, MenuManager mgr, Context context) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public boolean handleEvent(IdeAction action, Context context) {
            if (action != this.deployDefaultProfileAction_) {
                return false;
            }
            this.deployDefaultProfiles(context);
            return true;
        }

        public boolean update(IdeAction action, Context context) {
            if (action == this.deployDefaultProfileAction_) {
                action.setEnabled(!this.defaultDeploymentRunning_);
                return true;
            }
            return false;
        }

        private void deployDefaultProfiles(final Context context) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DefaultProfilesMenuBuilder.this.defaultDeploymentRunning_ = true;
                    Deployment.getLogger().info("Deploying Default Profiles for " + context.getElement().getShortLabel());
                    try {
                        ProfileRecognizer recognizer = ProfileRecognizer.getProfileRecognizer();
                        ProfileBuilder builder = recognizer.createBuilder(context);
                        Profile[] profiles = builder.buildAllProfiles();
                        if (profiles.length == 0) {
                            Deployment.getLogger().warning("No fitting Profiles");
                            return;
                        }
                        for (Profile p : profiles) {
                            Context newCtx = new Context(context);
                            newCtx.setElement((Element)p);
                            DeployUtil.setProfile(newCtx, p);
                            Context context2 = newCtx;
                            synchronized (context2) {
                                Deployment.deploy(newCtx);
                                newCtx.wait();
                            }
                        }
                    }
                    catch (Exception e) {
                        Deployment.getLogger().severe(e.getMessage());
                        e.printStackTrace();
                    }
                    finally {
                        DefaultProfilesMenuBuilder.this.defaultDeploymentRunning_ = false;
                    }
                }
            };
            new Thread(runnable, "Default-Profile-Deployer").start();
        }
    }

    private static class NewProfileMenuBuilder
    implements DeployMenuManager.MenuListener {
        private NewProfileMenuBuilder() {
        }

        @Override
        public void menuWillShow(JMenu menu, MenuManager menuMgr, Context context) {
            DataContainer dc;
            DeploymentProfiles profiles;
            if (context.getElement() instanceof DataContainer && (profiles = DeploymentProfiles.getInstance(dc = (DataContainer)context.getElement())).getProfileNames().size() == 0) {
                menu.add((Action)((Object)new NewProfileAction(context)));
            }
        }

        @Override
        public void menuWillHide(JMenu menu, MenuManager menuMgr, Context context) {
        }

        @Override
        public boolean handleDefaultAction(Context context) {
            return false;
        }
    }
}

