/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import javax.naming.Context;
import javax.naming.NamingException;
import oracle.ide.Addin;
import oracle.ide.Ide;
import oracle.ide.IdeAdapter;
import oracle.ide.IdeEvent;
import oracle.ide.IdeListener;
import oracle.ide.config.ClientSetting;
import oracle.javatools.jndi.Names;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.dt.DeployShellConfigurator;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.DeploymentOptions;
import oracle.jdeveloper.deploy.jar.JarPackaging;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdevimpl.deploy.DeployMenuManager;
import oracle.jdevimpl.deploy.ProfileLibrary;

public class DeployImpl
implements Addin {
    public void initialize() {
        DeployImpl.initDeploymentDT();
        DeployImpl.createDeploySubContext();
        DeployImpl.createDeploymentOptions();
        DeployImpl.registerProfileLibrary();
        DeployImpl.registerDeployMenuManagerImplementation();
        DeployImpl.registerDefaultDeployShellConfigurator();
    }

    private static void registerDefaultDeployShellConfigurator() {
        DefaultDeployShellFactory.getInstance().registerConfigurator(new DeployShellConfigurator());
    }

    private static void registerDeployMenuManagerImplementation() {
        try {
            final DeployMenuManager mgr = new DeployMenuManager();
            Names.newInitialContext().bind(oracle.jdeveloper.deploy.dt.DeployMenuManager.class.getName(), (Object)mgr);
            Ide.addIdeListener((IdeListener)new IdeAdapter(){

                public void mainWindowOpened(IdeEvent e) {
                    Ide.removeIdeListener((IdeListener)this);
                    mgr.install();
                }
            });
        }
        catch (NamingException e) {
            e.printStackTrace();
        }
    }

    private static void registerProfileLibrary() {
        JLibraryManager.registerDerivedLibrary(JarPackaging.class, ProfileLibrary.class);
    }

    private static void initDeploymentDT() {
        Deployment.init();
    }

    private static void createDeploySubContext() {
        Names.createSubcontext((Context)Names.newInitialContext(), (String)"deploy");
    }

    private static void createDeploymentOptions() {
        ClientSetting settings = ClientSetting.findOrCreate((String)"oracle.jdeveloper");
        if (!settings.hasData("deployment-options")) {
            settings.putData("deployment-options", (Copyable)new DeploymentOptions());
        }
    }
}

