/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import oracle.ide.explorer.ExplorerManager;
import oracle.ide.migration.NodeMigrator;
import oracle.ide.migration.NodeMigratorHelper;
import oracle.ide.model.DependableRecognizer;
import oracle.ide.model.ProjectMigrator;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.panels.Navigable;
import oracle.jdeveloper.deploy.DeployAddin;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.ProfileDeployerFactory;
import oracle.jdeveloper.deploy.dt.Deployment;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.dt.ProjectDeploymentPanel;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdeveloper.deploy.jar.JarDeployerFactory;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.meta.PlatformRegistry;
import oracle.jdeveloper.deploy.meta.PlatformType;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.ArchiveProfileDt;
import oracle.jdevimpl.deploy.DeploymentProfilesMigrator;
import oracle.jdevimpl.deploy.common.DefaultDeploymentModuleFactory;
import oracle.jdevimpl.deploy.common.ProfileDependableFactory;
import oracle.jdevimpl.deploy.explorer.DeploymentExplorer;
import oracle.jdevimpl.deploy.fwk.DeploymentManagerImpl;
import oracle.jdevimpl.deploy.res.CommonArb;
import oracle.jdevimpl.deploy.stripe.DirectoryModuleIO;
import oracle.jdevimpl.deploy.stripe.JarModuleIO;
import oracle.jdevimpl.deploy.stripe.PackingListIO;

public class DeferredStartup
implements DeployAddin {
    private static final Platform JSE1_4 = new Platform(PlatformType.JSE, "1.4", CommonArb.format(133, "1.4"), null);
    private static final Platform JSE1_5 = new Platform(PlatformType.JSE, "1.5", CommonArb.format(133, "1.5"), null);
    private static final Platform JSE1_6 = new Platform(PlatformType.JSE, "1.6", CommonArb.format(133, "1.6"), null);

    @Override
    public void startup() {
        DeferredStartup.registerPlatforms();
        DeferredStartup.registerExplorerSupport();
        DeferredStartup.registerProfileTypes();
        DeferredStartup.registerDependableFactories();
        DeferredStartup.registerDeployerFactories();
        DeferredStartup.registerDeployerListeners();
        DeferredStartup.registerDeploymentModuleIOFactories();
        DeferredStartup.registerDeploymentModuleFactories();
        DeferredStartup.registerProjectSettingsPanels();
        DeferredStartup.registerProjectMigrator();
    }

    private static void registerExplorerSupport() {
        ExplorerManager explorerMgr = ExplorerManager.getExplorerManager();
        if (explorerMgr != null) {
            explorerMgr.register(ArchiveProfile.class, DeploymentExplorer.class, null);
        }
    }

    private static void registerProfileTypes() {
        Deployment.registerProfileDesignTime(ArchiveProfile.class, new ArchiveProfileDt());
    }

    private static void registerPlatforms() {
        PlatformRegistry.registerPlatform(JSE1_4);
        PlatformRegistry.registerPlatform(JSE1_5);
        PlatformRegistry.registerPlatform(JSE1_6);
        try {
            PlatformRegistry.setDefaultPlatform(JSE1_6);
        }
        catch (MetadataException metadataException) {
            // empty catch block
        }
    }

    private static void registerDeployerFactories() {
        ProfileDeployerFactory base = new ProfileDeployerFactory();
        JarDeployerFactory jar = new JarDeployerFactory();
        try {
            DeploymentManager.registerDeployerFactory(Profile.class, null, base);
            DeploymentManager.registerDeployerFactory(ArchiveProfile.class, Profile.class, jar);
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }

    private static void registerDeployerListeners() {
        DeploymentManagerImpl.DeployConsoleLogger consoleLogger = new DeploymentManagerImpl.DeployConsoleLogger();
        DeploymentManager.addDeployerListener(consoleLogger, consoleLogger, 9999.0);
    }

    private static void registerProjectSettingsPanels() {
        Navigable navigable = new Navigable(DeployArb.getString(103), ProjectDeploymentPanel.class);
        ProjectPropertiesDialog.addPanel((Navigable)navigable);
    }

    private static void registerProjectMigrator() {
        NodeMigrator migrator = NodeMigrator.getNodeMigrator((String)ProjectMigrator.MIGRATOR_NAME);
        if (migrator != null) {
            migrator.addHelper((NodeMigratorHelper)new DeploymentProfilesMigrator());
        }
    }

    private static void registerDeploymentModuleIOFactories() {
        DeploymentModule.addModuleIOFactory(new JarModuleIO.JarModuleIOFactory());
        DeploymentModule.addModuleIOFactory(new DirectoryModuleIO.DirectoryModuleIOFactory());
        DeploymentModule.addModuleIOFactory(new PackingListIO.PackingListIOFactory());
    }

    private static void registerDependableFactories() {
        Deployment.getDependableFactory().registerFactory((DependableRecognizer)new ProfileDependableFactory());
    }

    private static void registerDeploymentModuleFactories() {
        try {
            DeploymentManager.registerDeploymentModuleFactory(ArchiveProfile.class, new DefaultDeploymentModuleFactory());
        }
        catch (MetadataException e) {
            e.printStackTrace();
        }
    }
}

