/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy;

import java.net.URL;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.SelectedArchives;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;
import oracle.jdevimpl.deploy.ClassDependencyAnalyzer;

public final class CommonHandler {
    public static ClassDependencyAnalyzer newCDA(Project project, CdaSettings cdaSettings) {
        return CommonHandler.newCDA(project, cdaSettings, false);
    }

    public static ClassDependencyAnalyzer newCDA(Project project, CdaSettings cdaSettings, boolean includeJspsDir) {
        JLibrary[] libs;
        URLPath classPath = new URLPath();
        URL outputDir = JavaProject.getInstance((Project)project).getOutputDirectory();
        classPath.add(outputDir);
        if (includeJspsDir) {
            classPath.add(URLFactory.newDirURL((URL)outputDir, (String)".jsps"));
            classPath.add(URLFactory.newDirURL((URL)outputDir, (String)".tags"));
            classPath.add(URLFactory.newDirURL((URL)outputDir, (String)".dtags"));
        }
        classPath.add(JProjectPaths.getInstance((PropertyStorage)project).getAdditionalClassPath());
        SelectedArchives sa = cdaSettings.getSelectedArchives();
        int selectionMode = sa.getSelectionMode();
        if (selectionMode == 2) {
            classPath.add(sa.getArchives());
        }
        URLPath libPath = new URLPath();
        JProjectLibraries jLibs = JProjectLibraries.getInstance((PropertyStorage)project);
        JDK jdkDef = jLibs.getJDK();
        if (jdkDef != null) {
            libPath.add(jdkDef.getClassPath());
        }
        if ((libs = jLibs.getLibraries()) != null) {
            for (JLibrary libDef : libs) {
                URLPath libCp;
                if (libDef == null || (libCp = libDef.getClassPath()) == null) continue;
                for (URL url : libCp) {
                    if (classPath.contains(url)) continue;
                    libPath.add(url);
                }
            }
        }
        URLPath sourcePath = PathsConfiguration.getInstance((Project)project).getSourcePath();
        ClassDependencyAnalyzer cda = new ClassDependencyAnalyzer(classPath, libPath, sourcePath);
        cda.setBeforeFilters(cdaSettings.getBeforeFilters());
        cda.setDuringFilters(cdaSettings.getDuringFilters());
        cda.setAfterFilters(cdaSettings.getAfterFilters());
        return cda;
    }

    static void invokeCommand(String cmdString, Context context) {
        Command cmd = CommandProcessor.createCommand((String)cmdString, (Context)context);
        if (cmd != null) {
            try {
                CommandProcessor cmdProcessor = CommandProcessor.getInstance();
                cmdProcessor.invoke(cmd);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private CommonHandler() {
    }
}

