/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.wizard.common;

import java.io.File;
import java.net.URL;
import java.util.Iterator;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaFile;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.legacy.Jot2Utils;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;

public class WizardFile {
    private String className;
    private String packageName;
    private String basePath;
    private static final String TRACE_CATEGORY = "oracle.jdeveloper.wizard.common";

    public WizardFile() {
        this(null, null, null);
    }

    public WizardFile(String className, String packageName, String basePath) {
        this.className = className;
        this.packageName = packageName;
        this.basePath = basePath;
    }

    public boolean isValid() {
        if (this.basePath == null || this.basePath.length() == 0) {
            return false;
        }
        return this.isClassNameValid() && this.isPackageNameValid();
    }

    public boolean isClassNameValid() {
        return this.isClassNameValid(false);
    }

    public boolean isClassNameValid(boolean isQualified) {
        if (this.className != null) {
            return isQualified ? Jot2Utils.isValidClassName(this.className) : Jot2Utils.isValidIdentifier(this.className);
        }
        return false;
    }

    public static boolean isClassNameValid(String className) {
        return WizardFile.isClassNameValid(className, false);
    }

    public static boolean isClassNameValid(String className, boolean isQualified) {
        if (className != null) {
            return isQualified ? Jot2Utils.isValidClassName(className) : Jot2Utils.isValidIdentifier(className);
        }
        return false;
    }

    public boolean isPackageNameValid() {
        if (this.packageName == null || this.packageName.length() == 0) {
            return true;
        }
        return Jot2Utils.isValidClassName(this.packageName);
    }

    public static boolean isPackageNameValid(String packageName) {
        if (packageName == null || packageName.length() == 0) {
            return true;
        }
        return Jot2Utils.isValidClassName(packageName);
    }

    public boolean fileExists() {
        File file = this.getFile();
        if (file != null) {
            return file.exists();
        }
        return false;
    }

    public boolean classExistsInProject(Project project) {
        JavaFile srcFile;
        String fname = this.getFullPath();
        URL url = URLFactory.newFileURL((String)fname);
        JavaManager mgr = JavaManager.getJavaManager((Project)project);
        JavaFile javaFile = srcFile = mgr != null ? mgr.getFile(url) : null;
        if (srcFile != null) {
            Iterator classes = srcFile.getClasses().iterator();
            String myName = this.getQualifiedClassName().toLowerCase();
            while (classes.hasNext()) {
                JavaClass jotCls = (JavaClass)classes.next();
                if (jotCls == null || !jotCls.getName().toLowerCase().equals(myName)) continue;
                return true;
            }
        }
        return false;
    }

    public JavaSourceNode getSourceNode(Project project) {
        String fname = this.getFullPath();
        URL url = URLFactory.newFileURL((String)fname);
        Node node = NodeFactory.find((URL)url);
        if (node == null) {
            node = WizardFile.createNodeInProject(project, url);
        }
        return (JavaSourceNode)node;
    }

    public void setDefaultClassName(Project project, String prefix, String suffix) {
        String fullPath = this.basePath;
        if (this.packageName != null && this.packageName.length() > 0) {
            fullPath = fullPath + File.separator + this.packageName.replace('.', File.separatorChar);
        }
        this.className = prefix;
        this.className = this.className + WizardFile.getUniqueFileNameID(project, fullPath, this.className, suffix);
    }

    public void setDefaultClassName(Project project, String prefix) {
        this.setDefaultClassName(project, prefix, ".java");
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getClassName() {
        return this.className;
    }

    public void setPackageName(String packageName) {
        this.packageName = packageName;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getQualifiedClassName() {
        if (this.packageName != null && this.packageName.length() > 0) {
            return this.packageName + "." + this.className;
        }
        return this.className;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public String getFullPath() {
        if (this.basePath == null || this.className == null) {
            return null;
        }
        String fullPath = this.basePath;
        if (!fullPath.endsWith(File.separator)) {
            fullPath = fullPath + File.separator;
        }
        if (this.packageName != null && this.packageName.length() > 0) {
            fullPath = fullPath + this.packageName.replace('.', File.separatorChar) + File.separator;
        }
        fullPath = fullPath + this.className + ".java";
        return fullPath;
    }

    public File getFile() {
        String filePath = this.getFullPath();
        if (filePath == null) {
            return null;
        }
        return new File(filePath);
    }

    public boolean verifyFilePath() {
        File file = this.getFile();
        if (file == null) {
            return false;
        }
        File parent = new File(file.getParent());
        return parent == null || parent.exists() || parent.mkdirs();
    }

    public String toString() {
        String result = "WizardFile: basePath = " + this.basePath + "; packageName = " + this.packageName + "; className = " + this.className;
        return result;
    }

    public boolean equals(Object anObject) {
        if (anObject != null && anObject instanceof WizardFile) {
            WizardFile otherWizFile = (WizardFile)anObject;
            boolean isClassSame = false;
            boolean isPackageSame = false;
            boolean isPathSame = false;
            isClassSame = this.className == null ? otherWizFile.getClassName() == null : this.className.equals(otherWizFile.getClassName());
            isPackageSame = this.packageName == null ? otherWizFile.getPackageName() == null : this.packageName.equals(otherWizFile.getPackageName());
            isPathSame = this.basePath == null ? otherWizFile.getBasePath() == null : this.basePath.equals(otherWizFile.getBasePath());
            return isClassSame && isPackageSame && isPathSame;
        }
        return false;
    }

    private static final Node createNodeInProject(Project project, URL url) {
        if (url == null) {
            return null;
        }
        try {
            Node node = NodeFactory.findOrCreate((URL)url);
            if (node != null) {
                project.add(node, PathsConfiguration.JAVA_CONTENT_SET_KEY);
            }
            return node;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static final int getUniqueFileNameID(Project project, String path, String prefix, String extension) {
        for (int i = 1; i < 1000; ++i) {
            File file = new File(path, prefix + i + extension);
            if (NodeFactory.find((URL)URLFactory.newFileURL((String)file.getPath())) != null || file.exists()) continue;
            return i;
        }
        return -1;
    }
}

