/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.usage.util;

import oracle.javatools.parser.util.AsyncScheduler;
import oracle.javatools.parser.util.AsyncTask;
import oracle.jdeveloper.usage.util.BackgroundTask;

public abstract class AbstractBackgroundTask
extends AsyncTask
implements BackgroundTask {
    private boolean _cancelled = false;
    private int _progressValue = 0;
    private String _progressText = "";

    @Override
    public final void cancel() {
        AsyncScheduler scheduler = this.getSchedulerImpl();
        if (scheduler != null) {
            scheduler.cancelTask((AsyncTask)this);
        }
    }

    protected abstract AsyncScheduler getSchedulerImpl();

    protected abstract Object runTaskImpl() throws AsyncTask.CancelledException;

    protected void cancelTaskImpl() {
    }

    protected final Object runImpl() throws AsyncTask.CancelledException {
        return this.runTaskImpl();
    }

    protected final void requestCancelImpl() {
        this._cancelled = true;
        this.cancelTaskImpl();
    }

    protected final boolean isCancelledImpl() {
        return this._cancelled;
    }

    protected void setProgressFromSubTask(int subValue, int rangeStart, int rangeEnd) {
        int mainValue;
        try {
            subValue = Math.max(0, subValue);
            subValue = Math.min(100, subValue);
            int range = rangeEnd - rangeStart;
            int incr = (int)((double)(range * subValue) / 100.0);
            mainValue = rangeStart + incr;
        }
        catch (RuntimeException e) {
            mainValue = rangeStart;
        }
        this.setProgress(mainValue);
    }

    protected void setProgressFromSubTask(BackgroundTask task, int rangeStart, int rangeEnd) {
        this.setProgressFromSubTask(task.getProgress(), rangeStart, rangeEnd);
    }

    @Override
    public final int getProgress() {
        return this._progressValue;
    }

    public final void setProgress(int value) {
        this._progressValue = value;
    }

    @Override
    public final String getProgressText() {
        return this._progressText;
    }

    public final void setProgressText(String text) {
        this._progressText = text;
    }
}

