/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.uieditor.uicanvas;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import oracle.jdeveloper.cmt.CmtModelNode;
import oracle.jdeveloper.resource.UIEditorArb;
import oracle.jdeveloper.uieditor.uicanvas.LayoutAssistant;
import oracle.jdeveloper.uieditor.uicanvas.UICanvas;

public final class SelectNib
extends JPanel {
    public static final int UNUSED = -1;
    public static final int NORTH_WEST = 0;
    public static final int NORTH_EAST = 1;
    public static final int SOUTH_WEST = 2;
    public static final int SOUTH_EAST = 3;
    public static final int NORTH = 4;
    public static final int WEST = 5;
    public static final int EAST = 6;
    public static final int SOUTH = 7;
    public static final int CENTER = 8;
    private static final Dimension DEFAULT_SIZE = new Dimension(6, 6);
    public int type;
    public int use;
    public boolean selectable;
    public boolean anchor;
    public CmtModelNode target;
    public Point rectangleLocation;
    public Dimension rectangleDimension;
    public Point parentLocation;
    private LayoutAssistant l;

    public SelectNib() {
        this.initialize();
    }

    public void initialize() {
        this.setVisible(false);
        this.setBackground(Color.black);
        this.setSize(DEFAULT_SIZE);
        this.setPreferredSize(DEFAULT_SIZE);
        this.setEnabled(false);
        this.type = -1;
        this.use = 0;
        this.selectable = true;
        this.anchor = false;
        this.target = null;
        this.rectangleLocation = null;
        this.parentLocation = null;
        this.rectangleDimension = null;
        this.l = null;
    }

    public Rectangle getNibBounds() {
        int x = this.rectangleLocation.x - this.parentLocation.x;
        int y = this.rectangleLocation.y - this.parentLocation.y;
        int width = this.rectangleDimension.width;
        int height = this.rectangleDimension.height;
        if (this.rectangleDimension.width < 0) {
            x += this.rectangleDimension.width;
            width = -this.rectangleDimension.width;
        }
        if (this.rectangleDimension.height < 0) {
            y += this.rectangleDimension.height;
            height = -this.rectangleDimension.height;
        }
        return new Rectangle(x, y, width, height);
    }

    public String resizeAction(Point location, UICanvas canvas) {
        if (this.l != null) {
            return this.l.resizeAction(location, canvas.getSelectionEffects(), this);
        }
        SelectNib.adjustPositionForNib(this.rectangleLocation, this.rectangleDimension, location, this.type);
        canvas.getBoxEffects().show(0, this.rectangleLocation, this.rectangleDimension, 2);
        return UIEditorArb.format(8, new String[]{Integer.toString(this.rectangleDimension.width), Integer.toString(this.rectangleDimension.height)});
    }

    public void setLayoutAssistant(LayoutAssistant l) {
        this.l = l;
    }

    public LayoutAssistant getLayoutAssistant() {
        return this.l;
    }

    public void setRectangleLocation(Point p) {
        this.rectangleLocation = p;
    }

    public Point getRectangleLocation() {
        return this.rectangleLocation;
    }

    public void setRectangleDimension(Dimension d) {
        this.rectangleDimension = d;
    }

    public Dimension getRectangleDimension() {
        return this.rectangleDimension;
    }

    public void setSelectable(boolean isSelectable) {
        this.selectable = isSelectable;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    @Override
    public void setBackground(Color c) {
        if (this.anchor) {
            this.setBorder(BorderFactory.createLineBorder(c, 2));
            super.setBackground(Color.white);
        } else {
            this.setBorder(null);
            super.setBackground(c);
        }
        this.repaint();
    }

    @Override
    public String toString() {
        return "SelectNib[type=" + this.type + ",target=" + this.target + "]";
    }

    public static void adjustPositionForNib(Point location, Dimension size, Point p, int nibType) {
        int xs = location.x;
        int ys = location.y;
        int xe = location.x + size.width;
        int ye = location.y + size.height;
        switch (nibType) {
            case 0: {
                xs = p.x;
                ys = p.y;
                break;
            }
            case 1: {
                xe = p.x;
                ys = p.y;
                break;
            }
            case 2: {
                xs = p.x;
                ye = p.y;
                break;
            }
            case 3: {
                xe = p.x;
                ye = p.y;
                break;
            }
            case 4: {
                ys = p.y;
                break;
            }
            case 5: {
                xs = p.x;
                break;
            }
            case 6: {
                xe = p.x;
                break;
            }
            case 7: {
                ye = p.y;
            }
        }
        location.x = xs;
        location.y = ys;
        size.width = xe - xs;
        size.height = ye - ys;
    }
}

