/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.parser;

import java.util.ArrayList;
import java.util.Collections;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;
import oracle.jdeveloper.sourcecolors.parser.Producer;

public class HTMLProducer
extends Producer {
    private static final String END_FONT = "</font>";
    private static final String START_STRING = "<font color=\"#0030CE\">";
    private static final String END_STRING = "</font>";
    private static final String START_CHAR = "<font color=\"#0030CE\">";
    private static final String END_CHAR = "</font>";
    private static final String START_RESERVED_WORD = "<font color=\"#31659C\"><B>";
    private static final String END_RESERVED_WORD = "</B></font>";
    private static final String START_CONSTANT = "<font color=\"#9C6500\">";
    private static final String END_CONSTANT = "</font>";
    private static final String START_COMMENT = "<font color=\"#848284\">";
    private static final String END_COMMENT = "</font>";
    private static final String START_SLC = "<font color=\"#848284\">";
    private static final String END_SLC = "</font>";
    private static final String START_JAVADOC_COMMENT = "<font color=\"#0030CE\">";
    private static final String END_JAVADOC_COMMENT = "</font>";
    private static final String START_BRACE = null;
    private static final String END_BRACE = null;
    private static final String START_IDENTIFIER = null;
    private static final String END_IDENTIFIER = null;
    private static final String START_OPERATOR = null;
    private static final String END_OPERATOR = null;
    private static final String START_TAGNAME = null;
    private static final String END_TAGNAME = null;
    private String _code;
    private StringBuffer _stringBuffer;
    private int _lastPos;
    private boolean _lineNumbers;
    private ArrayList _inserts;
    private int _insertPos = 0;
    private LinkInfo[] _linkInfos;

    public HTMLProducer(String code) {
        this._stringBuffer = new StringBuffer(code.length() * 2);
        this._code = code;
    }

    @Override
    public void addAttributes(Object attributes, int from, int to) {
        if (attributes == ATTRIBUTES_NORMAL) {
            this.add(from, to);
        } else if (attributes == ATTRIBUTES_STRING) {
            this.add("<font color=\"#0030CE\">", "</font>", from, to);
        } else if (attributes == ATTRIBUTES_RESERVED_WORD) {
            this.add(START_RESERVED_WORD, END_RESERVED_WORD, from, to);
        } else if (attributes == ATTRIBUTES_CONSTANT) {
            this.add(START_CONSTANT, "</font>", from, to);
        } else if (attributes == ATTRIBUTES_SINGLE_LINE_COMMENT) {
            this.add("<font color=\"#848284\">", "</font>", from, to);
        } else if (attributes == ATTRIBUTES_COMMENT) {
            this.add("<font color=\"#848284\">", "</font>", from, to);
        } else if (attributes == ATTRIBUTES_JAVADOC) {
            this.add("<font color=\"#0030CE\">", "</font>", from, to);
        } else if (attributes == ATTRIBUTES_CHAR) {
            this.add("<font color=\"#0030CE\">", "</font>", from, to);
        } else if (attributes == ATTRIBUTES_BRACE) {
            this.add(START_BRACE, END_BRACE, from, to);
        } else if (attributes == ATTRIBUTES_IDENTIFIER) {
            this.add(START_IDENTIFIER, END_IDENTIFIER, from, to);
        } else if (attributes == ATTRIBUTES_OPERATOR) {
            this.add(START_OPERATOR, END_OPERATOR, from, to);
        } else if (attributes == ATTRIBUTES_TAGNAME) {
            this.add(START_TAGNAME, END_TAGNAME, from, to);
        } else {
            this.add(from, to);
        }
    }

    private void add(String startString, String endString, int from, int to) {
        if (this._lastPos < from) {
            this.add(this._lastPos, from);
        }
        this.doInserts(from);
        if (startString != null) {
            this._stringBuffer.append(startString);
        }
        this.add(from, to);
        if (endString != null) {
            this._stringBuffer.append(endString);
        }
        this._lastPos = to;
    }

    private void add(int from, int to) {
        while (from < to) {
            int nextInsert = this.doInserts(from);
            int limit = Math.min(nextInsert, to);
            this._stringBuffer.append(this._code.substring(from, limit));
            from = limit;
        }
    }

    private int doInserts(int from) {
        while (true) {
            Insert insert = (Insert)this._inserts.get(this._insertPos);
            int insertPos = insert._pos;
            if (from < insertPos) {
                return insertPos;
            }
            this._stringBuffer.append(insert._insert);
            ++this._insertPos;
        }
    }

    public String getHTML() {
        return "<PRE>" + this._stringBuffer.toString() + "</PRE>";
    }

    public void init() {
        this._inserts = new ArrayList();
        if (this._lineNumbers || this._linkInfos != null) {
            this._inserts.add(new Insert(0, this.getLineAnchor(1)));
            int lineNo = 2;
            for (int i = 0; i < this._code.length(); ++i) {
                if (this._code.charAt(i) != '\n') continue;
                String anchor = this.getLineAnchor(lineNo);
                this._inserts.add(new Insert(i + 1, anchor));
                ++lineNo;
            }
        }
        if (this._linkInfos != null) {
            for (int i = 0; i < this._linkInfos.length; ++i) {
                LinkInfo linkInfo = this._linkInfos[i];
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append("<A HREF=\"");
                stringBuffer.append(linkInfo.getToLink());
                stringBuffer.append('#');
                stringBuffer.append(linkInfo.getToLine());
                stringBuffer.append('\"');
                String tooltip = linkInfo.getTooltip();
                if (tooltip != null) {
                    stringBuffer.append(" TITLE=\"");
                    stringBuffer.append(tooltip.replace('\"', '\''));
                    stringBuffer.append('\"');
                }
                stringBuffer.append('>');
                this._inserts.add(new Insert(linkInfo.getFromOffsetStart(), stringBuffer.toString()));
                this._inserts.add(new Insert(linkInfo.getFromOffsetEnd(), "</A>"));
            }
        }
        this._inserts.add(new Insert(Integer.MAX_VALUE, ""));
        Collections.sort(this._inserts);
    }

    private String getLineAnchor(int lineNo) {
        String lineVal = Integer.toString(lineNo);
        StringBuffer sb = new StringBuffer();
        sb.append("<A NAME=\"");
        sb.append(lineVal);
        sb.append("\">");
        if (this._lineNumbers) {
            sb.append(lineNo);
            String pad = "       ".substring(lineVal.length());
            sb.append(pad);
        }
        sb.append("</A>");
        return sb.toString();
    }

    public void setIncludeLineNumbers(boolean lineNumbers) {
        this._lineNumbers = lineNumbers;
    }

    public void setLinkInfos(LinkInfo[] linkInfos) {
        this._linkInfos = linkInfos;
    }

    private static class Insert
    implements Comparable {
        int _pos;
        String _insert;

        public Insert(int pos, String insert) {
            this._insert = insert;
            this._pos = pos;
        }

        public int compareTo(Object o) {
            Insert thatInsert = (Insert)o;
            return this._pos - thatInsert._pos;
        }
    }
}

