/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors.parser;

import java.util.HashSet;
import oracle.jdeveloper.sourcecolors.parser.GenericParser;

public class CPPParser
extends GenericParser {
    private static final int CHAR_OPERATOR = 1;
    private static final int CHAR_BRACE = 2;
    private static final HashSet RESERVED_WORDS = new HashSet();
    private static final HashSet CONSTANTS = new HashSet();
    private static final char[] OPERATORS = new char[127];

    @Override
    protected boolean isLitteral(String word) {
        return CONSTANTS.contains(word);
    }

    @Override
    protected boolean isReservedWord(String word) {
        return RESERVED_WORDS.contains(word);
    }

    @Override
    protected boolean isOperator(char c) {
        return c < OPERATORS.length && (OPERATORS[c] & '\u0001') == 1;
    }

    @Override
    protected boolean isBrace(char c) {
        return c < OPERATORS.length && (OPERATORS[c] & 2) == 2;
    }

    @Override
    protected boolean isStringDelimiter(char c) {
        return c == '\"';
    }

    @Override
    protected boolean isCharDelimiter(char c) {
        return c == '\'';
    }

    @Override
    protected boolean isStartComment(char c) {
        return c == '/';
    }

    @Override
    protected boolean isEscapeChar(char c) {
        return c == '\\';
    }

    @Override
    protected boolean isIdentifierStart(char c) {
        return Character.isJavaIdentifierStart(c);
    }

    @Override
    protected boolean isIdentifierPart(char c) {
        return Character.isJavaIdentifierPart(c);
    }

    @Override
    protected boolean isComment2(char c) {
        return c == '*';
    }

    @Override
    protected boolean isSpecialComment3(char c) {
        return c == '*';
    }

    @Override
    protected boolean isSingleLineComment2(char c) {
        return c == '/';
    }

    @Override
    protected boolean isEndComment1(char c) {
        return c == '*';
    }

    @Override
    protected boolean isEndComment2(char c) {
        return c == '/';
    }

    @Override
    protected boolean isCommentRecursive() {
        return false;
    }

    static {
        RESERVED_WORDS.add("asm");
        RESERVED_WORDS.add("auto");
        RESERVED_WORDS.add("break");
        RESERVED_WORDS.add("case");
        RESERVED_WORDS.add("char");
        RESERVED_WORDS.add("const");
        RESERVED_WORDS.add("continue");
        RESERVED_WORDS.add("default");
        RESERVED_WORDS.add("do");
        RESERVED_WORDS.add("double");
        RESERVED_WORDS.add("else");
        RESERVED_WORDS.add("enum");
        RESERVED_WORDS.add("extern");
        RESERVED_WORDS.add("float");
        RESERVED_WORDS.add("for");
        RESERVED_WORDS.add("goto");
        RESERVED_WORDS.add("if");
        RESERVED_WORDS.add("int");
        RESERVED_WORDS.add("long");
        RESERVED_WORDS.add("register");
        RESERVED_WORDS.add("return");
        RESERVED_WORDS.add("short");
        RESERVED_WORDS.add("signed");
        RESERVED_WORDS.add("sizeof");
        RESERVED_WORDS.add("static");
        RESERVED_WORDS.add("struct");
        RESERVED_WORDS.add("switch");
        RESERVED_WORDS.add("typedef");
        RESERVED_WORDS.add("union");
        RESERVED_WORDS.add("unsigned");
        RESERVED_WORDS.add("void");
        RESERVED_WORDS.add("volatile");
        RESERVED_WORDS.add("while");
        RESERVED_WORDS.add("bool");
        RESERVED_WORDS.add("catch");
        RESERVED_WORDS.add("class");
        RESERVED_WORDS.add("delete");
        RESERVED_WORDS.add("friend");
        RESERVED_WORDS.add("inline");
        RESERVED_WORDS.add("new");
        RESERVED_WORDS.add("namespace");
        RESERVED_WORDS.add("operator");
        RESERVED_WORDS.add("private");
        RESERVED_WORDS.add("protected");
        RESERVED_WORDS.add("public");
        RESERVED_WORDS.add("tempate");
        RESERVED_WORDS.add("this");
        RESERVED_WORDS.add("throw");
        RESERVED_WORDS.add("try");
        RESERVED_WORDS.add("template");
        RESERVED_WORDS.add("virtual");
        CONSTANTS.add("false");
        CONSTANTS.add("null");
        CONSTANTS.add("true");
        CPPParser.OPERATORS[59] = '\u0001';
        CPPParser.OPERATORS[94] = '\u0001';
        CPPParser.OPERATORS[44] = '\u0001';
        CPPParser.OPERATORS[46] = '\u0001';
        CPPParser.OPERATORS[61] = '\u0001';
        CPPParser.OPERATORS[60] = '\u0001';
        CPPParser.OPERATORS[62] = '\u0001';
        CPPParser.OPERATORS[33] = '\u0001';
        CPPParser.OPERATORS[126] = '\u0001';
        CPPParser.OPERATORS[63] = '\u0001';
        CPPParser.OPERATORS[58] = '\u0001';
        CPPParser.OPERATORS[43] = '\u0001';
        CPPParser.OPERATORS[45] = '\u0001';
        CPPParser.OPERATORS[42] = '\u0001';
        CPPParser.OPERATORS[38] = '\u0001';
        CPPParser.OPERATORS[124] = '\u0001';
        CPPParser.OPERATORS[37] = '\u0001';
        CPPParser.OPERATORS[123] = 2;
        CPPParser.OPERATORS[125] = 2;
        CPPParser.OPERATORS[91] = 2;
        CPPParser.OPERATORS[93] = 2;
        CPPParser.OPERATORS[123] = 2;
        CPPParser.OPERATORS[125] = 2;
    }
}

