/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors;

import java.awt.font.TextAttribute;
import java.net.URL;
import java.text.AttributedString;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.jdeveloper.sourcecolors.parser.CPPParser;
import oracle.jdeveloper.sourcecolors.parser.HTMLProducer;
import oracle.jdeveloper.sourcecolors.parser.JavaParser;
import oracle.jdeveloper.sourcecolors.parser.LinkInfo;
import oracle.jdeveloper.sourcecolors.parser.NullParser;
import oracle.jdeveloper.sourcecolors.parser.Parser;
import oracle.jdeveloper.sourcecolors.parser.TextAttributeProducer;

public class SourceColorizer {
    public static final String LANGUAGE_JAVA = "java";
    public static final String LANGUAGE_CPP = "cpp";
    public static final AttributedString EMPTY_ATTRIBUTE_STRING = new AttributedString("X");

    public static String getLanguage(URL url) {
        String fileName = url.getFile().toLowerCase();
        if (fileName.endsWith(".java")) {
            return LANGUAGE_JAVA;
        }
        if (fileName.endsWith(".cpp")) {
            return LANGUAGE_CPP;
        }
        return null;
    }

    public static AttributedString[] toAttributedString(String language, String code, int[] startOffsets, int[] endOffsets) {
        Parser parser = SourceColorizer.getParser(language);
        int segmentCount = startOffsets.length;
        int pos = 0;
        AttributedString[] attributedStrings = new AttributedString[segmentCount];
        for (int i = 0; i < segmentCount; ++i) {
            String codeSegment;
            int startOffset = startOffsets[i];
            int endOffset = endOffsets[i];
            try {
                codeSegment = code.substring(pos, startOffset);
                parser.toAttributedString(codeSegment, startOffset - pos, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error in SourceColorizer.toAttributedString");
            }
            if (startOffset < endOffset) {
                codeSegment = code.substring(startOffset, endOffset);
                TextAttributeProducer textAttributeProducer = new TextAttributeProducer(codeSegment);
                parser.toAttributedString(codeSegment, endOffset - startOffset, textAttributeProducer);
                attributedStrings[i] = textAttributeProducer.getAttributedString();
                FontSizeOptions fontOptions = FontSizeOptions.getInstance((PropertyStorage)Preferences.getPreferences());
                String fontFamily = fontOptions.getFontFamily();
                int fontSize = fontOptions.getFontSize();
                attributedStrings[i].addAttribute(TextAttribute.FAMILY, fontFamily);
                attributedStrings[i].addAttribute(TextAttribute.SIZE, new Float(fontSize));
            } else {
                attributedStrings[i] = EMPTY_ATTRIBUTE_STRING;
            }
            pos = endOffset;
        }
        return attributedStrings;
    }

    public static AttributedString toAttributedString(String language, String code, int startOffsets, int endOffsets) {
        AttributedString[] attributedStrings = SourceColorizer.toAttributedString(language, code, new int[]{startOffsets}, new int[]{endOffsets});
        return attributedStrings[0];
    }

    private static Parser getParser(String language) {
        Parser parser = NullParser.NULL_PARSER;
        if (language != null) {
            if (language.equals(LANGUAGE_JAVA)) {
                parser = new JavaParser();
            } else if (language.equals(LANGUAGE_CPP)) {
                parser = new CPPParser();
            }
        }
        return parser;
    }

    public static AttributedString toAttributedString(String language, String text) {
        Parser parser = SourceColorizer.getParser(language);
        TextAttributeProducer textAttributeProducer = new TextAttributeProducer(text);
        parser.toAttributedString(text, text.length(), textAttributeProducer);
        return textAttributeProducer.getAttributedString();
    }

    public static String toHTML(String language, boolean lineNumbers, String text, LinkInfo[] linkInfos) {
        Parser parser = SourceColorizer.getParser(language);
        HTMLProducer htmlProducer = new HTMLProducer(text);
        if (linkInfos != null) {
            htmlProducer.setLinkInfos(linkInfos);
        }
        htmlProducer.setIncludeLineNumbers(lineNumbers);
        htmlProducer.init();
        parser.toAttributedString(text, text.length(), htmlProducer);
        return htmlProducer.getHTML();
    }
}

