/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.sourcecolors;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.font.FontRenderContext;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.accessibility.AccessibleContext;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import oracle.bali.ewt.graphics.GraphicUtils;
import oracle.ide.ceditor.options.FontSizeOptions;
import oracle.ide.config.Preferences;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Pair;
import oracle.jdeveloper.sourcecolors.SourceColorizer;

public class CodeTreeCellRenderer
extends DefaultTreeCellRenderer {
    private AttributedString _attributedString;
    private boolean _sel;
    private boolean _hasFocus;
    private final Font _font;
    private final Color _inactiveBackgroundSelectionColor;

    public CodeTreeCellRenderer() {
        FontSizeOptions fontOptions = FontSizeOptions.getInstance((PropertyStorage)Preferences.getPreferences());
        HashMap<TextAttribute, Object> map = new HashMap<TextAttribute, Object>();
        map.put(TextAttribute.FAMILY, fontOptions.getFontFamily());
        map.put(TextAttribute.SIZE, new Float(fontOptions.getFontSize()));
        this._font = new Font(map);
        Color c = UIManager.getColor("oracle.ide.explorer.TreeExplorer.inactiveSelectionBackground");
        this._inactiveBackgroundSelectionColor = c == null ? this.backgroundSelectionColor : c;
    }

    public static AttributedString[] getCodeTreeNodes(String code, int[] startOffsets, int[] endOffsets, String language) {
        return SourceColorizer.toAttributedString(language, code, startOffsets, endOffsets);
    }

    @Override
    public synchronized Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        this._attributedString = null;
        if (value instanceof DefaultMutableTreeNode) {
            Pair pair;
            Object first;
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)value;
            Object userObject = defaultMutableTreeNode.getUserObject();
            if (userObject instanceof AttributedString) {
                this._attributedString = (AttributedString)userObject;
            } else if (userObject instanceof Pair && (first = (pair = (Pair)userObject).getFirst()) instanceof AttributedString) {
                this._attributedString = (AttributedString)first;
            }
        } else if (value instanceof AttributedString) {
            this._attributedString = (AttributedString)value;
        }
        if (this._attributedString != null) {
            AccessibleContext ac;
            this._sel = sel;
            this._hasFocus = hasFocus;
            if (EventQueue.isDispatchThread()) {
                AttributedCharacterIterator iterator = this.getIterator(this._attributedString);
                FontRenderContext fontRenderContext = new FontRenderContext(null, false, false);
                TextLayout textLayout = new TextLayout(iterator, fontRenderContext);
                Rectangle2D bounds = textLayout.getBounds();
                int textWidth = (int)(bounds.getX() + bounds.getWidth());
                int textHeight = (int)(bounds.getHeight() - bounds.getY());
                this.setPreferredSize(new Dimension(textWidth, textHeight));
            }
            if ((ac = this.getAccessibleContext()) != null) {
                AttributedCharacterIterator aci = this.getIterator(this._attributedString);
                StringBuffer strBuffer = new StringBuffer();
                char c = aci.first();
                while (c != '\uffff') {
                    strBuffer.append(c);
                    c = aci.next();
                }
                ac.setAccessibleName(strBuffer.toString());
            }
            return this;
        }
        if (EventQueue.isDispatchThread()) {
            this.setPreferredSize(null);
        }
        return super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
    }

    @Override
    public synchronized void paint(Graphics g) {
        if (this._attributedString == null) {
            super.paint(g);
        } else {
            Color bsColor;
            Color fillBackground;
            Color background = null;
            Color foreground = null;
            if (this._sel) {
                if (this._hasFocus) {
                    foreground = this.getTextSelectionColor();
                    background = this.getBackgroundSelectionColor();
                } else {
                    background = this._inactiveBackgroundSelectionColor;
                }
                fillBackground = background;
            } else {
                fillBackground = this.getBackgroundNonSelectionColor();
            }
            g.setColor(fillBackground);
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            if (this._attributedString != SourceColorizer.EMPTY_ATTRIBUTE_STRING) {
                AttributedString attributedString;
                if (background != null || foreground != null) {
                    attributedString = new AttributedString(this._attributedString.getIterator());
                    if (background != null) {
                        attributedString.addAttribute(TextAttribute.BACKGROUND, background);
                    }
                    if (foreground != null) {
                        attributedString.addAttribute(TextAttribute.FOREGROUND, foreground);
                    }
                } else {
                    attributedString = this._attributedString;
                }
                g.setColor(Color.BLACK);
                g.setFont(this._font);
                FontMetrics fontMetrics = g.getFontMetrics();
                AttributedCharacterIterator iterator = this.getIterator(attributedString);
                int y = (int)fontMetrics.getLineMetrics(iterator, 0, iterator.getEndIndex(), g).getHeight();
                int pad = (this.getHeight() - y) / 2;
                GraphicUtils.drawString((Graphics)g, (AttributedCharacterIterator)iterator, (int)0, (int)(y + pad - fontMetrics.getDescent()));
            }
            if (this._hasFocus && (bsColor = this.getBorderSelectionColor()) != null) {
                g.setColor(bsColor);
                g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            }
        }
    }

    private AttributedCharacterIterator getIterator(AttributedString string) {
        return new TabConvertingCharacterIterator(string.getIterator());
    }

    private static final class TabConvertingCharacterIterator
    implements AttributedCharacterIterator {
        private AttributedCharacterIterator wrapped;

        public TabConvertingCharacterIterator(AttributedCharacterIterator wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public int getRunStart() {
            return this.wrapped.getRunStart();
        }

        @Override
        public int getRunStart(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getRunStart(attribute);
        }

        @Override
        public int getRunStart(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.wrapped.getRunStart(attributes);
        }

        @Override
        public int getRunLimit() {
            return this.wrapped.getRunLimit();
        }

        @Override
        public int getRunLimit(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getRunLimit(attribute);
        }

        @Override
        public int getRunLimit(Set<? extends AttributedCharacterIterator.Attribute> attributes) {
            return this.wrapped.getRunLimit(attributes);
        }

        @Override
        public Map<AttributedCharacterIterator.Attribute, Object> getAttributes() {
            return this.wrapped.getAttributes();
        }

        @Override
        public Object getAttribute(AttributedCharacterIterator.Attribute attribute) {
            return this.wrapped.getAttribute(attribute);
        }

        @Override
        public Set<AttributedCharacterIterator.Attribute> getAllAttributeKeys() {
            return this.wrapped.getAllAttributeKeys();
        }

        @Override
        public char first() {
            return this.convertTab(this.wrapped.first());
        }

        @Override
        public char last() {
            return this.convertTab(this.wrapped.last());
        }

        @Override
        public char current() {
            return this.convertTab(this.wrapped.current());
        }

        @Override
        public char next() {
            return this.convertTab(this.wrapped.next());
        }

        @Override
        public char previous() {
            return this.convertTab(this.wrapped.previous());
        }

        @Override
        public char setIndex(int position) {
            return this.convertTab(this.wrapped.setIndex(position));
        }

        @Override
        public int getBeginIndex() {
            return this.wrapped.getBeginIndex();
        }

        @Override
        public int getEndIndex() {
            return this.wrapped.getEndIndex();
        }

        @Override
        public int getIndex() {
            return this.wrapped.getIndex();
        }

        public boolean equals(Object obj) {
            return this.wrapped.equals(obj);
        }

        @Override
        public Object clone() {
            return new TabConvertingCharacterIterator((AttributedCharacterIterator)this.wrapped.clone());
        }

        private char convertTab(char c) {
            return c == '\t' ? (char)' ' : (char)c;
        }
    }
}

