/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.ListModel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import oracle.bali.ewt.shuttle.ItemPicker;
import oracle.bali.ewt.shuttle.ListPicker;
import oracle.bali.ewt.shuttle.Shuttle;
import oracle.bali.ewt.shuttle.ShuttleEvent;
import oracle.bali.ewt.shuttle.ShuttleListener;
import oracle.bali.share.datatransfer.ObjectTransferable;
import oracle.bali.share.datatransfer.TransferUtils;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.controls.JWrappedLabel;
import oracle.ide.model.Project;
import oracle.ide.model.TechId;
import oracle.ide.model.TechnologyRegistry;
import oracle.ide.model.TechnologyScope;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.ui.Colors;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.model.JDevTechnologyInfo;
import oracle.jdeveloper.model.JDevTechnologyRegistry;
import oracle.jdeveloper.resource.TechArb;

public final class TechnologiesPanel
extends ProjectSettingsTraversablePanel {
    public static final String TECHNOLOGY_SCOPE_DATA_KEY = "technologyScope";
    private static final String HELP_ID = "f1_idedprojsettechnologyscopedpp_html";
    private final DefaultListModel _fromModel = new DefaultListModel();
    private final DefaultListModel _toModel = new DefaultListModel();
    private final DefaultListCellRenderer _renderer = new TechIdListRenderer();
    private final JTabbedPane _tabs = new JTabbedPane();
    private JPanel _technologiesPanel = new JPanel();
    private FilesPanel _generatedComponentsPanel = new FilesPanel();
    private LibrariesPanel _librariesPanel = new LibrariesPanel();
    private final GridBagLayout _layout = new GridBagLayout();
    private final JLabel _fromLabel = new JLabel();
    private final JList _fromList = new JList();
    private final JLabel _toLabel = new JLabel();
    private final JList _toList = new JList();
    private final Shuttle _technologiesShuttle = new Shuttle();
    private final JLabel _descriptionLabel = new JLabel();
    private final DescriptionScrollPane _descriptionScrollPane = new DescriptionScrollPane();
    private final ListPicker _fromPicker = new CustomFromListPicker(this._fromList);
    private final ListPicker _toPicker = new CustomToListPicker(this._toList);
    private TechnologyScope _scope;
    private static final String[] PROPERTY_KEYS = new String[]{"technologyScope"};
    public static final String SELECTED_TECH_SCOPES = "SelectedTechnologyScopes";
    private transient PropertyChangeSupport _propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private transient TechId[] _fixedTechnologies = new TechId[0];

    public TechnologiesPanel() {
        this.setHelpID(HELP_ID);
        EventAdapter eventAdapter = new EventAdapter();
        this._fromList.addFocusListener(eventAdapter);
        this._fromList.addListSelectionListener(eventAdapter);
        this._toList.addFocusListener(eventAdapter);
        this._toList.addListSelectionListener(eventAdapter);
        this._technologiesShuttle.addShuttleListener((ShuttleListener)eventAdapter);
        this._fromList.setModel(this._fromModel);
        this._fromList.setSelectionMode(2);
        this._fromPicker.setItemsSorted(true);
        this._toList.setModel(this._toModel);
        this._toList.setCellRenderer(this._renderer);
        this._toList.setSelectionMode(2);
        this._toPicker.setItemsSorted(true);
        ResourceUtils.resLabel((JLabel)this._fromLabel, (Component)this._fromList, (String)TechArb.getString(10));
        ResourceUtils.resLabel((JLabel)this._toLabel, (Component)this._toList, (String)TechArb.getString(11));
        ResourceUtils.resLabel((JLabel)this._descriptionLabel, (Component)this._descriptionScrollPane.getLabelComponent(), (String)TechArb.getString(12));
        Border headerLabelBorder = BorderFactory.createEmptyBorder(0, 0, 2, 0);
        this._fromLabel.setBorder(headerLabelBorder);
        this._toLabel.setBorder(headerLabelBorder);
        this._technologiesShuttle.setButtonsShown(5);
        this._technologiesShuttle.add((Component)this._fromLabel, (Object)"FromHeader");
        this._technologiesShuttle.setFromPicker((ItemPicker)this._fromPicker);
        this._technologiesShuttle.add((Component)this._toLabel, (Object)"ToHeader");
        this._technologiesShuttle.setToPicker((ItemPicker)this._toPicker);
        this._technologiesPanel.setLayout(this._layout);
        this._technologiesPanel.add((Component)this._technologiesShuttle, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.8, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        this._technologiesPanel.add((Component)this._descriptionLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 2, 0), 0, 0));
        this._technologiesPanel.add((Component)this._descriptionScrollPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.2, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        int margin = 10;
        this._technologiesPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        Border border = BorderFactory.createEmptyBorder(10, 10, 10, 10);
        this._generatedComponentsPanel.setBorder(border);
        this._librariesPanel.setBorder(border);
        String label0 = TechArb.getString(1);
        int mnemonic0 = StringUtils.getMnemonicKeyCode((String)label0);
        String slabel0 = StringUtils.stripMnemonic((String)label0);
        this._tabs.add((Component)this._technologiesPanel, slabel0);
        this._tabs.setMnemonicAt(0, mnemonic0);
        String label1 = TechArb.getString(2);
        int mnemonic1 = StringUtils.getMnemonicKeyCode((String)label1);
        String slabel1 = StringUtils.stripMnemonic((String)label1);
        this._tabs.add((Component)this._generatedComponentsPanel, slabel1);
        this._tabs.setMnemonicAt(1, mnemonic1);
        String label2 = TechArb.getString(7);
        int mnemonic2 = StringUtils.getMnemonicKeyCode((String)label2);
        String slabel2 = StringUtils.stripMnemonic((String)label2);
        this._tabs.add((Component)this._librariesPanel, slabel2);
        this._tabs.setMnemonicAt(2, mnemonic2);
        this.setLayout(new BorderLayout());
        this.add(this._tabs, "Center");
    }

    public void setUnremoveableTechnologies(TechId ... techIds) {
        this._fixedTechnologies = techIds;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        TechnologyScope scope = this.getTechnologyScopeFromContext(tc);
        this._scope = new TechnologyScope(scope);
        this.populateModels(this._scope);
    }

    public void onExit(TraversableContext tc) {
        TechId[] projectTechnologies = this._scope.toArray();
        boolean visible = false;
        for (int i = 0; i < projectTechnologies.length; ++i) {
            TechId techId = projectTechnologies[i];
            if (!techId.isVisible()) continue;
            visible = true;
            break;
        }
        if (!visible) {
            this._scope.clear();
        }
        this.putTechnologyScopeToContext(tc, this._scope);
    }

    public String getDataKey() {
        return TechnologyScopeConfiguration.DATA_KEY;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public TechId[] getSelectedTechnologies() {
        return this._scope != null ? this._scope.toArray() : new TechId[]{};
    }

    private TechnologyScope getTechnologyScopeFromContext(TraversableContext tc) {
        PropertyStorage propertyData;
        TechnologyScope scope = (TechnologyScope)tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY);
        if (scope != null) {
            return scope;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            return techScopeConfiguration.getTechnologyScope();
        }
        return null;
    }

    private void putTechnologyScopeToContext(TraversableContext tc, TechnologyScope scope) {
        PropertyStorage propertyData;
        if (tc.getDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY) != null) {
            tc.putDesignTimeObject(TECHNOLOGY_SCOPE_DATA_KEY, (Object)scope);
            return;
        }
        Object object = propertyData = tc.find("PropertyData") != null ? TechnologiesPanel.getPropertyData((Namespace)tc) : (Project)tc.find("Project");
        if (propertyData != null) {
            TechnologyScopeConfiguration techScopeConfiguration = TechnologyScopeConfiguration.getInstance((PropertyStorage)propertyData);
            techScopeConfiguration.setTechnologyScope(scope);
        }
    }

    private boolean canRemoveTechId(TechId techId) {
        for (TechId id : this._fixedTechnologies) {
            if (!id.equals(techId)) continue;
            return false;
        }
        return true;
    }

    private void populateModels(TechnologyScope scope) {
        int i;
        TechnologyRegistry techReg = TechnologyRegistry.getInstance();
        Object[] technologies = techReg.getVisibleTechIds();
        Arrays.sort(technologies);
        this._fromModel.clear();
        this._fromModel.ensureCapacity(technologies.length);
        for (int i2 = 0; i2 < technologies.length; ++i2) {
            Object techId = technologies[i2];
            this._fromModel.addElement(techId);
        }
        Object[] projectTechnologies = scope.toArray();
        Arrays.sort(projectTechnologies);
        for (i = this._toModel.size() - 1; i >= 0; --i) {
            TechId tech = (TechId)this._toModel.getElementAt(i);
            if (!this.canRemoveTechId(tech)) continue;
            this._toModel.remove(i);
        }
        this._toModel.ensureCapacity(projectTechnologies.length);
        for (i = 0; i < projectTechnologies.length; ++i) {
            Object techId = projectTechnologies[i];
            if (!techId.isVisible() || !this._fromModel.contains(techId)) continue;
            this._fromModel.removeElement(techId);
            if (this._toModel.contains(techId)) continue;
            this._toModel.addElement(techId);
        }
        this._fromList.ensureIndexIsVisible(0);
        this._fromList.setSelectedIndex(0);
        this._toList.ensureIndexIsVisible(0);
        this._toList.setSelectedIndex(0);
        this.refreshScope();
    }

    private void refreshScope() {
        TechId[] techIds = this._scope.toArray();
        this._generatedComponentsPanel.setTechnologies(techIds);
        this._librariesPanel.setTechnologies(techIds);
    }

    public void addTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this._propertyChangeSupport.addPropertyChangeListener(SELECTED_TECH_SCOPES, listener);
    }

    public void removeTechnologyPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            throw new NullPointerException("The listener cannot be null.");
        }
        this._propertyChangeSupport.removePropertyChangeListener(SELECTED_TECH_SCOPES, listener);
    }

    private class TechIdListRenderer
    extends DefaultListCellRenderer {
        final Color selectedForeground;
        final SystemColor unselectedForeground;

        TechIdListRenderer() {
            UIDefaults uid = UIManager.getLookAndFeel().getDefaults();
            this.selectedForeground = uid.getColor("List.selectionForeground");
            this.unselectedForeground = SystemColor.textInactiveText;
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel l = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            if (!TechnologiesPanel.this.canRemoveTechId((TechId)value)) {
                l.setForeground(isSelected ? this.selectedForeground : this.unselectedForeground);
            }
            return l;
        }
    }

    private class CustomToListPicker
    extends ListPicker {
        public CustomToListPicker(JList list) {
            super(list);
        }

        private boolean hasUnmoveableItems() {
            return TechnologiesPanel.this._fixedTechnologies.length > 0 && !this.getList().isSelectionEmpty();
        }

        public boolean isItemSelected() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            if (!this.hasUnmoveableItems()) {
                return super.isItemSelected();
            }
            ListModel listModel = this.getList().getModel();
            int[] indices = this.getList().getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                TechId tech = (TechId)listModel.getElementAt(indices[i]);
                if (!TechnologiesPanel.this.canRemoveTechId(tech)) continue;
                return true;
            }
            return false;
        }

        public boolean isSelectableItemPresent() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            if (!this.hasUnmoveableItems()) {
                return super.isSelectableItemPresent();
            }
            ListModel listModel = this.getList().getModel();
            int[] indices = this.getList().getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                TechId tech = (TechId)listModel.getElementAt(indices[i]);
                if (!TechnologiesPanel.this.canRemoveTechId(tech)) continue;
                return true;
            }
            return false;
        }

        public Transferable[] getSelectedItems() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return new Transferable[0];
            }
            if (!this.hasUnmoveableItems()) {
                return super.getSelectedItems();
            }
            ListModel listModel = this.getList().getModel();
            ArrayList<Transferable> list = new ArrayList<Transferable>();
            int[] indices = this.getList().getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                Object element = listModel.getElementAt(indices[i]);
                if (!TechnologiesPanel.this.canRemoveTechId((TechId)element)) continue;
                list.add(this.createTransferable(element));
            }
            return list.toArray(new Transferable[list.size()]);
        }

        public Transferable[] getAllSelectableItems() {
            if (!this.hasUnmoveableItems()) {
                return super.getAllSelectableItems();
            }
            ArrayList<Transferable> transferables = new ArrayList<Transferable>();
            ListModel listModel = this.getList().getModel();
            for (int i = 0; i < listModel.getSize(); ++i) {
                Object element = listModel.getElementAt(i);
                if (!TechnologiesPanel.this.canRemoveTechId((TechId)element)) continue;
                transferables.add(this.createTransferable(element));
            }
            return transferables.toArray(new Transferable[transferables.size()]);
        }
    }

    private class CustomFromListPicker
    extends ListPicker {
        public CustomFromListPicker(JList list) {
            super(list);
        }

        public boolean isSelectableItemPresent() {
            if (!TechnologiesPanel.this.isEnabled()) {
                return false;
            }
            return super.isSelectableItemPresent();
        }
    }

    class LibrariesPanel
    extends TechScopeAssociationsPanel {
        final String[] columns = new String[]{"", TechArb.getString(9)};

        @Override
        protected Vector getDataVector() {
            Vector data = new Vector();
            for (TechId technology : this._technologies) {
                JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                if (jdevTechInfo == null) continue;
                for (JDevTechnologyInfo.LibraryInfo libInfo : jdevTechInfo.getLibraries()) {
                    if (libInfo.getName() == null) continue;
                    Vector<String> v = new Vector<String>();
                    v.add(libInfo.getDescription());
                    v.add(libInfo.getName());
                    data.add(v);
                }
            }
            return data;
        }

        @Override
        protected Vector getColumnsVector() {
            return new Vector<String>(Arrays.asList(this.columns));
        }

        @Override
        protected String getTitle() {
            return TechArb.getString(8);
        }
    }

    class FilesPanel
    extends TechScopeAssociationsPanel {
        final String[] columns = new String[]{"", TechArb.getString(4), TechArb.getString(5), TechArb.getString(6)};

        @Override
        protected Vector getDataVector() {
            Vector data = new Vector();
            for (TechId technology : this._technologies) {
                JDevTechnologyInfo.GeneratedFileInfo[] files;
                JDevTechnologyRegistry jdevTechnologyRegistry = JDevTechnologyRegistry.getInstance();
                JDevTechnologyInfo jdevTechInfo = jdevTechnologyRegistry.getJDevTechnologyInfo(technology);
                if (jdevTechInfo == null || (files = jdevTechInfo.getGeneratedFiles()) == null || files.length <= 0) continue;
                for (JDevTechnologyInfo.GeneratedFileInfo file : files) {
                    Vector<String> v = new Vector<String>();
                    v.add(ModelUtil.hasLength((String)file.getDescription()) ? file.getDescription() : file.toString());
                    v.add(file.getName());
                    v.add(file.getPath());
                    v.add(file.getFileType());
                    data.add(v);
                }
            }
            return data;
        }

        @Override
        protected Vector getColumnsVector() {
            return new Vector<String>(Arrays.asList(this.columns));
        }

        @Override
        protected String getTitle() {
            return TechArb.getString(3);
        }
    }

    private static abstract class TechScopeAssociationsPanel
    extends JPanel
    implements ListSelectionListener {
        protected TechId[] _technologies;
        private final BorderLayout _layout = new BorderLayout(0, 8);
        private final JSplitPane _splitPane = new JSplitPane();
        private final JWrappedLabel _tableLabel = new JWrappedLabel();
        protected final DefaultTableModel _model = new NonEditableTableModel();
        private final JTable _table = new JTable(this._model);
        private final DescriptionScrollPane _descriptionScrollPane = new DescriptionScrollPane();

        TechScopeAssociationsPanel() {
            this._tableLabel.setText(this.getTitle());
            this._tableLabel.setForeground(Colors.HINT_TEXT);
            this._table.setDragEnabled(false);
            this._table.setSelectionMode(0);
            this._table.setColumnSelectionAllowed(false);
            this._table.setRowSelectionAllowed(true);
            this._table.getSelectionModel().addListSelectionListener(this);
            JScrollPane listScroller = new JScrollPane(this._table);
            listScroller.setBorder(BorderFactory.createEmptyBorder());
            listScroller.setHorizontalScrollBarPolicy(31);
            listScroller.setVerticalScrollBarPolicy(20);
            this._descriptionScrollPane.setBorder(null);
            this._descriptionScrollPane.setHorizontalScrollBarPolicy(31);
            this._descriptionScrollPane.setVerticalScrollBarPolicy(20);
            this._splitPane.setResizeWeight(0.7);
            this._splitPane.setOrientation(0);
            this._splitPane.setTopComponent(listScroller);
            this._splitPane.setBottomComponent((Component)this._descriptionScrollPane);
            this.setLayout(this._layout);
            this.add((Component)this._tableLabel, "North");
            this.add((Component)this._splitPane, "Center");
        }

        protected void setTechnologies(TechId[] techIds) {
            if (!Arrays.equals(this._technologies, techIds)) {
                this._technologies = techIds;
                this.refreshList();
            }
        }

        private void refreshList() {
            this._model.getDataVector().clear();
            if (this._technologies != null) {
                int r = this._table.getSelectedRow();
                int c = this._table.getSelectedColumn();
                this._model.setDataVector(this.getDataVector(), this.getColumnsVector());
                if (r >= 0 && c >= 0 && r < this._model.getRowCount() && c < this._model.getColumnCount()) {
                    this._table.changeSelection(r, c, true, true);
                }
            }
            this._model.fireTableDataChanged();
            this._table.removeColumn(this._table.getColumnModel().getColumn(0));
        }

        protected abstract Vector getDataVector();

        protected abstract Vector getColumnsVector();

        protected abstract String getTitle();

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (this._table.getSelectedRow() == -1) {
                    this._descriptionScrollPane.setText(null);
                } else {
                    String desc = (String)this._model.getValueAt(this._table.getSelectedRow(), 0);
                    this._descriptionScrollPane.setText(desc == null ? "" : desc);
                }
            }
        }

        private class NonEditableTableModel
        extends DefaultTableModel {
            private NonEditableTableModel() {
            }

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        }
    }

    private final class EventAdapter
    implements FocusListener,
    ListSelectionListener,
    ShuttleListener {
        private EventAdapter() {
        }

        @Override
        public void focusGained(FocusEvent event) {
            this.updateDescription((JList)event.getSource());
        }

        @Override
        public void focusLost(FocusEvent event) {
        }

        @Override
        public void valueChanged(ListSelectionEvent event) {
            this.updateDescription((JList)event.getSource());
        }

        public void shuttleItemsMoved(ShuttleEvent event) {
            TechId[] orginalTechnologies = TechnologiesPanel.this._scope.toArray();
            Transferable[] items = event.getItems();
            for (int i = 0; i < items.length; ++i) {
                TechId techId = this.extractTechId(items[i]);
                if (techId == null) continue;
                TechnologiesPanel.this._scope.add(techId);
            }
            int anchor = TechnologiesPanel.this._fromList.getAnchorSelectionIndex();
            TechnologiesPanel.this.populateModels(TechnologiesPanel.this._scope);
            TechnologiesPanel.this._propertyChangeSupport.firePropertyChange(TechnologiesPanel.SELECTED_TECH_SCOPES, orginalTechnologies, TechnologiesPanel.this._scope.toArray());
            this.restoreRelativeSelection(TechnologiesPanel.this._fromList, anchor);
        }

        public void shuttleItemsRemoved(ShuttleEvent event) {
            TechId[] orginalTechnologies = TechnologiesPanel.this._scope.toArray();
            Transferable[] items = event.getItems();
            for (int i = 0; i < items.length; ++i) {
                TechId techId = this.extractTechId(items[i]);
                if (techId == null || !TechnologiesPanel.this.canRemoveTechId(techId)) continue;
                TechnologiesPanel.this._scope.remove(techId);
            }
            int anchor = TechnologiesPanel.this._toList.getAnchorSelectionIndex();
            TechnologiesPanel.this.populateModels(TechnologiesPanel.this._scope);
            TechnologiesPanel.this._propertyChangeSupport.firePropertyChange(TechnologiesPanel.SELECTED_TECH_SCOPES, orginalTechnologies, TechnologiesPanel.this._scope.toArray());
            this.restoreRelativeSelection(TechnologiesPanel.this._toList, anchor);
        }

        private void restoreRelativeSelection(JList list, int lastIndex) {
            int maxIndex = list.getModel().getSize() - 1;
            int index = Math.min(lastIndex, maxIndex);
            list.setSelectedIndex(index);
        }

        public void shuttleItemsReordered(ShuttleEvent event) {
        }

        private void updateDescription(JList list) {
            TechId techId = (TechId)list.getSelectedValue();
            if (techId != null) {
                TechnologiesPanel.this._descriptionScrollPane.setText(techId.getDescription());
            } else {
                TechnologiesPanel.this._descriptionScrollPane.setText(null);
            }
        }

        private TechId extractTechId(Transferable t) {
            if (t instanceof ObjectTransferable) {
                ObjectTransferable item = (ObjectTransferable)t;
                DataFlavor flavor = TransferUtils.getDataFlavor(TechId.class);
                try {
                    return (TechId)item.getTransferData(flavor);
                }
                catch (Exception ex) {
                    // empty catch block
                }
            }
            return null;
        }
    }
}

