/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.Window;
import java.net.URL;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import oracle.bali.share.nls.StringUtils;
import oracle.ide.Addin;
import oracle.ide.AddinManager;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.cmd.AddContentCommand;
import oracle.ide.cmd.FileOpenHistory;
import oracle.ide.cmd.OpenCommandData;
import oracle.ide.controller.Command;
import oracle.ide.controller.CommandProcessor;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.controller.Controller;
import oracle.ide.controller.IdeAction;
import oracle.ide.controller.IdeActions;
import oracle.ide.controller.LabelUpdater;
import oracle.ide.controller.MenuConstants;
import oracle.ide.controller.MenuManager;
import oracle.ide.controls.ToggleAction;
import oracle.ide.keyboard.KeyStrokeContextRegistry;
import oracle.ide.layout.URL2String;
import oracle.ide.model.Element;
import oracle.ide.model.ElementAttributes;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.ide.model.Workspaces;
import oracle.ide.model.panels.ProjectPropertiesDialog;
import oracle.ide.navigator.NavigatorManager;
import oracle.ide.navigator.ProjectNavigatorWindow;
import oracle.ide.net.DefaultURLFilter;
import oracle.ide.net.URLFileSystem;
import oracle.ide.resource.IdeArb;
import oracle.ide.util.ArrayResourceBundle;
import oracle.ide.view.ActiveViewEvent;
import oracle.ide.view.ActiveViewListener;
import oracle.ide.view.View;
import oracle.ideimpl.IdeMenus;
import oracle.javatools.dialogs.ExceptionDialog;
import oracle.jdeveloper.cmd.NewInterfaceCommand;
import oracle.jdeveloper.controller.MenuAwareLabelUpdater;
import oracle.jdeveloper.library.Library;
import oracle.jdeveloper.model.JDevTechnologies;
import oracle.jdeveloper.model.JProjectTechnologyNotifier;
import oracle.jdeveloper.resource.CommandArb;
import oracle.jdeveloper.resource.ModelArb;

class JProjectStructureController
implements Addin,
Controller {
    public static final int ADD_TO_PROJECT_CMD_ID = AddContentCommand.ADD_TO_PROJECT_CMD_ID;
    private static JMenuItem editConfigurationsDlgItem;
    private static JMenuItem addToProjectContextItem;
    private static boolean menusBuilt;
    private JMenuItem deleteMenuItem;
    private JMenuItem eraseMenuItem;
    private JMenu _recentApplicationsMenu;
    private final Map _recentApplicationsCache = new HashMap();
    private IdeAction projectSettingsAction;
    private IdeAction defaultProjectSettingsAction;
    private static final String OPEN_APPLICATION_CMD = "oracle.jdeveloper.model.JProjectStructureController.OPEN_APPLICATION_CMD";
    private static int OPEN_APPLICATION_CMD_ID;

    public JProjectStructureController() {
        OPEN_APPLICATION_CMD_ID = Ide.findOrCreateCmdID((String)OPEN_APPLICATION_CMD);
    }

    public boolean handleEvent(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            Project project = context.getProject();
            if (project != null) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
            }
            return true;
        }
        if (cmdId == 56) {
            if (context.getNode() instanceof Project) {
                ProjectPropertiesDialog.showDialog((Context)context, (Project)((Project)context.getNode()));
                return true;
            }
        } else {
            if (cmdId == 37) {
                Project project = Ide.getDefaultProject();
                if (project != null) {
                    ProjectPropertiesDialog.showDialog((Context)context, (Project)project);
                }
                return true;
            }
            if (cmdId == NewInterfaceCommand.CMD_ID) {
                CommandProcessor cmdProc = CommandProcessor.getInstance();
                Command cmd = CommandProcessor.createCommand((String)action.getCommand(), (Context)context);
                try {
                    cmdProc.invoke(cmd);
                }
                catch (Exception ex) {
                    oracle.ide.dialogs.ExceptionDialog.showExceptionDialog((Context)context, (Throwable)ex);
                }
                return true;
            }
            if (cmdId == OPEN_APPLICATION_CMD_ID) {
                Workspaces workspaces = Ide.getWorkspaces();
                if (workspaces != null) {
                    this.performOpenWorkspaceAction(context);
                    return true;
                }
            } else if (cmdId == ADD_TO_PROJECT_CMD_ID) {
                Element element = context.getElement();
                if (element == null) {
                    return false;
                }
                if (element.getData() instanceof Workspaces) {
                    this.performOpenWorkspaceAction(context);
                    return true;
                }
                if (element instanceof Workspace) {
                    OpenCommandData data = new OpenCommandData(true);
                    data.dialogTitle = ModelArb.getString((int)143);
                    DefaultURLFilter urlFilter = new DefaultURLFilter(ModelArb.getString((int)144));
                    urlFilter.addExtension(".jpr");
                    data.urlFilter = urlFilter;
                    this.performOpenAction(context, data);
                    return true;
                }
                return false;
            }
        }
        return false;
    }

    private void performOpenWorkspaceAction(Context context) {
        OpenCommandData data = new OpenCommandData(true);
        data.dialogTitle = ModelArb.getString((int)146);
        DefaultURLFilter urlFilter = new DefaultURLFilter(ModelArb.getString((int)142));
        urlFilter.addExtension(".jws");
        data.urlFilter = urlFilter;
        this.performOpenAction(context, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performOpenAction(Context context, OpenCommandData data) {
        IdeAction openAction = IdeAction.find((int)9);
        openAction.putValue("UserData", (Object)data);
        try {
            openAction.performAction(context);
        }
        catch (Exception ex) {
            ExceptionDialog.showExceptionDialog((Window)Ide.getMainWindow(), (Exception)ex);
        }
        finally {
            openAction.putValue("UserData", null);
        }
    }

    public boolean update(IdeAction action, Context context) {
        int cmdId = action.getCommandId();
        if (cmdId == 35) {
            boolean enabled = context.getProject() != null;
            Element[] selection = context.getSelection();
            if (selection != null && selection.length > 1 && selection[0] instanceof Project) {
                enabled = false;
            }
            action.setEnabled(enabled);
            return true;
        }
        if (cmdId == 56) {
            Element[] selection = context.getSelection();
            if (context.getProject() != null && context.getNode() instanceof Project && selection != null && selection.length == 1 && selection[0] instanceof Project) {
                action.setEnabled(true);
                return true;
            }
        } else {
            if (cmdId == OPEN_APPLICATION_CMD_ID) {
                boolean enabled = Ide.getWorkspaces() != null;
                action.setEnabled(enabled);
                return true;
            }
            if (cmdId == ADD_TO_PROJECT_CMD_ID) {
                Element[] selection = context.getSelection();
                String label = null;
                boolean enableAction = false;
                if (selection == null || selection.length == 0 || selection.length > 1 || selection[0] == null) {
                    label = ModelArb.getString((int)42);
                    enableAction = false;
                } else {
                    Element element = selection[0];
                    if (element.getData() instanceof Workspaces || element instanceof Workspace) {
                        label = ModelArb.format((int)43, (Object)element.getShortLabel());
                        enableAction = true;
                    } else if (element instanceof Project || context.getProject() != null) {
                        label = ModelArb.getString((int)42);
                        enableAction = true;
                    }
                }
                action.setEnabled(enableAction);
                action.putValue("Name", (Object)StringUtils.stripMnemonic((String)label));
                return true;
            }
            if (cmdId == 21) {
                View view;
                String target = null;
                View view2 = view = context != null ? context.getView() : null;
                if (view instanceof ProjectNavigatorWindow) {
                    Element[] selection = context.getSelection();
                    if (selection != null && selection.length > 0) {
                        if (selection[0] instanceof Project) {
                            target = context.getWorkspace().getShortLabel();
                            action.setEnabled(true);
                        } else if (selection[0] instanceof Workspace) {
                            target = Ide.getWorkspaces().getShortLabel();
                            action.setEnabled(true);
                        } else if (selection[0] == Ide.getWorkspaces() || selection[0].getData() == Ide.getWorkspaces()) {
                            action.setEnabled(false);
                        } else {
                            Project project = context.getProject();
                            if (project != null) {
                                target = project.getShortLabel();
                                action.setEnabled(false);
                            }
                        }
                    } else {
                        action.setEnabled(false);
                    }
                    String label = null;
                    label = target == null ? IdeArb.getString((int)223) : IdeArb.format((int)224, target);
                    action.putValue("Name", (Object)label);
                    return true;
                }
            } else if (cmdId == NewInterfaceCommand.CMD_ID) {
                boolean enabled = context != null && context.getProject() != null;
                action.setEnabled(enabled);
                return true;
            }
        }
        return false;
    }

    private IdeAction getProjectSettingsAction() {
        if (this.projectSettingsAction == null) {
            this.projectSettingsAction = IdeAction.find((int)35);
        }
        return this.projectSettingsAction;
    }

    private synchronized void buildMenus(MenuManager mgr) {
        if (!menusBuilt) {
            IdeAction action = this.getAction(8, IdeArb.getString((int)49), IdeArb.getInteger((int)50), IdeArb.getInstance(), 51, null);
            action.setEnabled(true);
            action = this.getAction(NewInterfaceCommand.CMD_ID, CommandArb.getString(5), CommandArb.getInteger(6), CommandArb.getInstance(), 7, this);
            action.setCommand(NewInterfaceCommand.CMD_NAME);
            action.setEnabled(true);
            editConfigurationsDlgItem = mgr.createMenuItem((ToggleAction)this.getProjectSettingsAction(), MenuConstants.WEIGHT_TOOLS_PROJECT_PROPERTIES);
            action = IdeAction.find((int)ADD_TO_PROJECT_CMD_ID);
            addToProjectContextItem = mgr.createMenuItem((ToggleAction)action, MenuConstants.WEIGHT_FILE_ADD_TO_PROJECT);
            this.deleteMenuItem = mgr.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromIDEAction(), MenuConstants.WEIGHT_FILE_ERASE);
            this.deleteMenuItem.setIcon(null);
            this.eraseMenuItem = mgr.createMenuItem((ToggleAction)IdeActions.getFileRemoveFromDiskAction(), MenuConstants.WEIGHT_FILE_ERASE);
            this.eraseMenuItem.setIcon(IdeArb.getIcon((int)103));
            menusBuilt = true;
        }
    }

    private static boolean isApplicationNavigator(View view) {
        return view instanceof ProjectNavigatorWindow;
    }

    public void initialize() {
        this.projectSettingsAction = IdeActions.getToolsProjectPropertiesAction();
        this.projectSettingsAction.addController((Controller)this);
        IdeActions.getEditPropertiesAction().addController((Controller)this);
        this.defaultProjectSettingsAction = IdeActions.getToolsDefaultProjectPropertiesAction();
        this.defaultProjectSettingsAction.addController((Controller)this);
        this.defaultProjectSettingsAction.setEnabled(true);
        IdeAction openApplicationAction = IdeAction.find((int)OPEN_APPLICATION_CMD_ID);
        openApplicationAction.addController((Controller)this);
        openApplicationAction.setLabelUpdater((LabelUpdater)new ActionLabelUpdater());
        IdeAction removeFileAction = IdeActions.getFileRemoveFromIDEAction();
        removeFileAction.addController((Controller)this);
        String label = ModelArb.format((int)43, (Object)"");
        IdeAction addToProjectAction = IdeAction.get((int)ADD_TO_PROJECT_CMD_ID, (String)AddinManager.getAddinManager().getCommand(ADD_TO_PROJECT_CMD_ID, null), (String)label);
        addToProjectAction.setEnabled(false);
        addToProjectAction.putValue("MnemonicKey", (Object)new Integer(StringUtils.getMnemonicKeyCode((String)label)));
        addToProjectAction.addController((Controller)this);
        this.setupOpenRecentMenu();
        KeyStrokeContextRegistry kscr = Ide.getKeyStrokeContextRegistry();
        kscr.addAcceleratorDefinitionFile(this.getClass().getClassLoader(), "oracle/jdeveloper/model/projectaccelerators.xml");
        NavigatorManager navMgr = NavigatorManager.getWorkspaceNavigatorManager();
        JProjectMenuListener jpmListener = new JProjectMenuListener();
        navMgr.addContextMenuListener((ContextMenuListener)jpmListener, Workspaces.class);
        navMgr.addContextMenuListener((ContextMenuListener)jpmListener, Project.class);
        navMgr.addContextMenuListener((ContextMenuListener)new ElementMenuListener(), Element.class);
        JDevTechnologies.register();
        JProjectTechnologyNotifier.initialize();
    }

    private void setupOpenRecentMenu() {
        String openRecentKey = "APPLICATION_REOPEN_MENU";
        this._recentApplicationsMenu = MenuManager.getJMenu((String)"APPLICATION_REOPEN_MENU");
        if (this._recentApplicationsMenu == null) {
            this._recentApplicationsMenu = new JMenu();
            MenuManager.putJMenu((String)"APPLICATION_REOPEN_MENU", (JMenu)this._recentApplicationsMenu);
        }
        this._recentApplicationsMenu.add(this.getEmptyItem());
        this._recentApplicationsMenu.getPopupMenu().addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                JProjectStructureController.this.callPoppingUp();
            }

            @Override
            public final void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            }

            @Override
            public final void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
    }

    private void callPoppingUp() {
        FileOpenHistory fileOpenHistory = FileOpenHistory.getInstance();
        String[] workspaces = fileOpenHistory.getWorkspaceHistory();
        this._recentApplicationsMenu.removeAll();
        if (workspaces.length == 0) {
            this._recentApplicationsMenu.add(this.getEmptyItem());
            return;
        }
        for (String ws : workspaces) {
            JMenuItem menuItem = this.getMenuItem(fileOpenHistory, ws);
            if (menuItem == null) continue;
            this._recentApplicationsMenu.add(menuItem);
        }
    }

    private JMenuItem getEmptyItem() {
        JMenuItem emptyItem = new JMenuItem(IdeArb.getString((int)234));
        emptyItem.setEnabled(false);
        return emptyItem;
    }

    private JMenuItem getMenuItem(FileOpenHistory fileOpenHistory, String urlString) {
        JMenuItem menuItem = (JMenuItem)this._recentApplicationsCache.get(urlString);
        if (menuItem != null) {
            try {
                URL url = URL2String.toURL((String)urlString);
                if (!URLFileSystem.exists((URL)url)) {
                    this._recentApplicationsCache.remove(urlString);
                    return null;
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            return menuItem;
        }
        try {
            URL url = URL2String.toURL((String)urlString);
            if (url == null || !URLFileSystem.exists((URL)url)) {
                return null;
            }
            IdeAction action = FileOpenHistory.getNewReopenAction((URL)url);
            menuItem = Ide.getMenubar().createMenuItem((ToggleAction)action);
            this._recentApplicationsCache.put(urlString, menuItem);
            return menuItem;
        }
        catch (Exception e) {
            return null;
        }
    }

    private IdeAction getAction(int cmdId, String label, Integer mnemonic, ArrayResourceBundle bundle, int key, Controller controller) {
        IdeAction action = IdeAction.get((int)cmdId, (String)AddinManager.getAddinManager().getCommand(cmdId, null), (String)label, (ArrayResourceBundle)bundle, (int)key);
        action.setEnabled(false);
        action.putValue("MnemonicKey", (Object)mnemonic);
        if (controller != null) {
            action.addController(controller);
        }
        return action;
    }

    private void checkDeleteActionLabel(Context context) {
        IdeAction action = IdeActions.getFileRemoveFromDiskAction();
        action.updateAction(context);
    }

    private static class ActionLabelUpdater
    extends MenuAwareLabelUpdater {
        ActionLabelUpdater() {
            super("");
        }

        @Override
        protected String disabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            return this.enabledMenuSpecificLabel(action, originalLabel);
        }

        @Override
        protected String enabledMenuSpecificLabel(IdeAction action, String originalLabel) {
            if (action.getCommandId() == OPEN_APPLICATION_CMD_ID) {
                return ModelArb.getString((int)147);
            }
            return originalLabel;
        }

        @Override
        protected boolean matchMenu(EventObject event) {
            Object source;
            if (event != null && (source = event.getSource()) instanceof JMenu) {
                JMenu jMenu;
                JMenu appMenu = IdeMenus.findJMenu((String)"APPLICATION_MENU");
                return appMenu == (jMenu = (JMenu)source);
            }
            return false;
        }
    }

    private class JProjectMenuListener
    implements ContextMenuListener {
        private JProjectMenuListener() {
        }

        public void menuWillShow(ContextMenu popup) {
            Context context;
            if (popup != null && (context = popup.getContext()) != null) {
                if (!menusBuilt) {
                    JProjectStructureController.this.buildMenus((MenuManager)popup);
                }
                JProjectStructureController.this.checkDeleteActionLabel(context);
                if (context.getProject() != null) {
                    popup.add((Component)addToProjectContextItem, 1.0f);
                    popup.add((Component)editConfigurationsDlgItem, MenuConstants.SECTION_EDIT_PROPERTIES_CTXT_MENU);
                } else {
                    popup.add((Component)addToProjectContextItem, 1.0f);
                }
                if ((context.getProject() != null || context.getWorkspace() != null) && this.selectionIsNotAProject(context)) {
                    popup.add((Component)JProjectStructureController.this.deleteMenuItem, 1.0f);
                }
            }
        }

        private boolean selectionIsNotAProject(Context context) {
            return context.getSelection() != null && !(context.getSelection()[0] instanceof Project);
        }

        public void menuWillHide(ContextMenu popup) {
        }

        public boolean handleDefaultAction(Context context) {
            return JProjectStructureController.this.handleEvent(JProjectStructureController.this.getProjectSettingsAction(), context);
        }
    }

    private class ElementMenuListener
    implements ActiveViewListener,
    ContextMenuListener {
        private ElementMenuListener() {
        }

        public void menuWillShow(ContextMenu popup) {
            Element element;
            View view;
            Context context;
            if (popup != null && (context = popup.getContext()) != null && (view = context.getView()) != null && JProjectStructureController.isApplicationNavigator(view) && (element = context.getElement()) != null && !(element instanceof Library)) {
                if (!menusBuilt) {
                    JProjectStructureController.this.buildMenus((MenuManager)popup);
                }
                if (element instanceof Workspace) {
                    popup.add((Component)addToProjectContextItem, 1.0f);
                }
                if (!(element instanceof Project) && (element.getAttributes().isSet(ElementAttributes.ERASEABLE) || element.getAttributes().isSet(ElementAttributes.DELETEABLE))) {
                    popup.add((Component)JProjectStructureController.this.deleteMenuItem, 1.0f);
                }
                if (!(element instanceof Workspace)) {
                    JProjectStructureController.this.checkDeleteActionLabel(context);
                    popup.add((Component)JProjectStructureController.this.eraseMenuItem, 1.0f);
                }
                Ide.getMainWindow().addActiveViewListener((ActiveViewListener)this);
            }
        }

        public void menuWillHide(ContextMenu popup) {
            Ide.getMainWindow().removeActiveViewListener((ActiveViewListener)this);
        }

        public boolean handleDefaultAction(Context context) {
            return false;
        }

        public void activeViewChanged(ActiveViewEvent e) {
            IdeAction action = (IdeAction)JProjectStructureController.this.deleteMenuItem.getAction();
            action.updateAction();
        }
    }
}

