/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.model;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.Ide;
import oracle.ide.controls.GridBagConstants;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Project;
import oracle.ide.model.panels.ProjectSettingsTraversablePanel;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.net.URLTextField;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.IdeUtil;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.Namespace;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.StringUtil;
import oracle.jdeveloper.model.ContentSetPanel;
import oracle.jdeveloper.model.JavaContentValidator;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JProjectArb;
import oracle.jdeveloper.resource.ModelArb;

public class JProjectPanel
extends ProjectSettingsTraversablePanel
implements GridBagConstants {
    private final ContentSetPanel projectContentPanel = new ContentSetPanel();
    private JLabel packageLabel = new JLabel();
    private JTextField packageTextField = new JTextField();
    private JLabel outputDirLabel = new JLabel();
    private URLTextField outputDirTextField = new URLTextField(null, true, false);
    private JButton outputDirButton = new JButton();
    private JavaContentValidator contentSetValidator;
    private JLabel defaultSourceDirLabel = new JLabel();
    private URLTextField defaultSourceDirTextField = new URLTextField();
    private static final String[] PROPERTY_KEYS = new String[]{PathsConfiguration.JAVA_CONTENT_SET_KEY, JavaProject.OUTPUT_DIRECTORY, "defaultPackage"};

    public JProjectPanel() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getDataKey() {
        return null;
    }

    public String[] getPropertyKeys() {
        return PROPERTY_KEYS;
    }

    public void onProjectPanelEntry(TraversableContext tc) {
        boolean isDefaultProject = JProjectPanel.isDefaultProject((Namespace)tc);
        this.setHelpID(isDefaultProject ? "f1_idedprojectcontentmaindpp_html" : "f1_idedprojectcontentmain_html");
        Project project = (Project)tc.find("Project");
        PropertyStorage propertyData = JProjectPanel.getPropertyData((Namespace)tc);
        if (this.contentSetValidator == null) {
            this.contentSetValidator = new JavaContentValidator();
            this.projectContentPanel.setValidator(this.contentSetValidator);
        }
        this.loadFrom(project, propertyData, isDefaultProject);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        if (tc.getDirection() != 2) {
            Project project = (Project)tc.find("Project");
            PropertyStorage propertyData = JProjectPanel.getPropertyData((Namespace)tc);
            boolean isDefaultProject = JProjectPanel.isDefaultProject((Namespace)tc);
            this.commitTo(project, propertyData, isDefaultProject);
        }
    }

    protected ContentSetPanel getContentSetPanel() {
        return this.projectContentPanel;
    }

    protected void setPackageName(String packageName) {
        this.packageTextField.setText(packageName);
    }

    protected String getPackageName() {
        return this.packageTextField.getText();
    }

    private void loadFrom(Project project, PropertyStorage propertyData, boolean isDefaultProject) {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)project, (PropertyStorage)propertyData);
        ContentSet javaContentSet = pathsConfiguration.getJavaContentSet();
        JavaProject javaProject = JavaProject.getInstance((Project)project, (HashStructure)propertyData.getProperties());
        this.packageTextField.setText(javaProject.getDefaultPackage());
        if (isDefaultProject) {
            this.projectContentPanel.setVisible(false);
            this.packageTextField.setVisible(false);
            this.packageLabel.setVisible(false);
            this.defaultSourceDirLabel.setVisible(true);
            this.defaultSourceDirTextField.setVisible(true);
            URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
            this.defaultSourceDirTextField.setBaseURL(defaultProjectDir);
            URL sourceDir = pathsConfiguration.getProjectSourcePath().getFirstEntry();
            if (sourceDir == null) {
                String src = oracle.ide.resource.ModelArb.getString((int)17);
                sourceDir = URLFactory.newDirURL((URL)defaultProjectDir, (String)src);
                pathsConfiguration.getProjectSourcePath().add(sourceDir);
            }
            this.defaultSourceDirTextField.setURL(sourceDir);
            this.outputDirButton.setVisible(false);
            this.outputDirTextField.setBaseURL(defaultProjectDir);
            URL outputDir = javaProject.getOutputDirectory();
            if (outputDir == null) {
                String classes = oracle.ide.resource.ModelArb.getString((int)18);
                outputDir = URLFactory.newDirURL((URL)defaultProjectDir, (String)classes);
            }
            this.outputDirTextField.setURL(outputDir);
        } else {
            this.defaultSourceDirLabel.setVisible(false);
            this.defaultSourceDirTextField.setVisible(false);
            this.projectContentPanel.setVisible(true);
            this.projectContentPanel.loadFrom(project, javaContentSet);
            URL outputDir = javaProject.getOutputDirectory();
            this.outputDirTextField.setBaseURL(null);
            this.outputDirTextField.setURL(outputDir);
        }
        this.validate();
    }

    private void commitTo(Project project, PropertyStorage propertyData, boolean isDefaultProject) throws TraversalException {
        PathsConfiguration pathsConfiguration = PathsConfiguration.getInstance((Project)project, (PropertyStorage)propertyData);
        JavaProject javaProject = JavaProject.getInstance((Project)project, (HashStructure)propertyData.getProperties());
        URL outputDirURL = this.outputDirTextField.getURL();
        String defaultPackage = this.packageTextField.getText().trim();
        if (isDefaultProject) {
            this.validateDefaultProjectProperties();
            URL sourcePathRoot = this.defaultSourceDirTextField.getURL();
            ContentSet javaContentSet = pathsConfiguration.getJavaContentSet();
            javaContentSet.getURLPath().setEntries(new URL[]{sourcePathRoot});
        } else {
            this.validateProjectProperties();
            try {
                this.projectContentPanel.saveContentSet();
            }
            catch (ContentSetPanel.EmptyContentSetException e) {
                throw new TraversalException(ModelArb.getString((int)107), ModelArb.getString((int)134));
            }
        }
        javaProject.setOutputDirectory(URLFileSystem.canonicalize((URL)outputDirURL));
        javaProject.setDefaultPackage(defaultPackage);
    }

    private void validateProjectProperties() throws TraversalException {
        URLPath sourcePath = this.projectContentPanel.getURLPath();
        if (sourcePath.size() <= 0) {
            throw new TraversalException(ModelArb.getString((int)107), ModelArb.getString((int)134));
        }
        URL outputDirURL = this.outputDirTextField.getURL();
        if (outputDirURL == null) {
            if (!ModelUtil.hasLength((String)this.outputDirTextField.getText())) {
                throw new TraversalException(JProjectArb.getString((int)147), JProjectArb.getString((int)144));
            }
            throw new TraversalException(JProjectArb.format((int)129, (Object)JProjectArb.getString((int)145), (Object)this.outputDirTextField.getText().trim()), JProjectArb.getString((int)144));
        }
        if (URLFileSystem.isReadOnly((URL)outputDirURL)) {
            throw new TraversalException(JProjectArb.getString((int)148), JProjectArb.getString((int)144));
        }
        if (!URLFileSystem.isValid((URL)outputDirURL)) {
            String fileName = URLFileSystem.getPlatformPathName((URL)outputDirURL);
            if (fileName.length() > 80) {
                fileName = StringUtil.truncateFileNameForMessage((String)fileName);
            }
            this.outputDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format((int)129, (Object)JProjectArb.getString((int)145), (Object)fileName), JProjectArb.getString((int)144));
        }
        String defaultPackage = this.packageTextField.getText().trim();
        if (ModelUtil.hasLength((String)defaultPackage) && !IdeUtil.isPackageIdentifier((String)defaultPackage)) {
            this.packageTextField.requestFocus();
            throw new TraversalException(JProjectArb.format((int)126, (Object)defaultPackage), JProjectArb.getString((int)125));
        }
    }

    private void validateDefaultProjectProperties() throws TraversalException {
        URL sourcePathRoot = this.defaultSourceDirTextField.getURL();
        URL defaultProjectDir = URLFileSystem.getParent((URL)Ide.getDefaultProject().getURL());
        if (sourcePathRoot == null || URLFileSystem.toRelativeSpec((URL)sourcePathRoot, (URL)defaultProjectDir, (boolean)true) == null || !URLFileSystem.isValid((URL)sourcePathRoot)) {
            this.defaultSourceDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format((int)136, (Object)JProjectArb.getString((int)47), (Object)this.defaultSourceDirTextField.getText()), JProjectArb.getString((int)127));
        }
        URL outputDirURL = this.outputDirTextField.getURL();
        if (outputDirURL == null || URLFileSystem.toRelativeSpec((URL)outputDirURL, (URL)defaultProjectDir, (boolean)true) == null || !URLFileSystem.isValid((URL)outputDirURL)) {
            this.outputDirTextField.requestFocus();
            throw new TraversalException(JProjectArb.format((int)136, (Object)JProjectArb.getString((int)137), (Object)this.outputDirTextField.getText()));
        }
    }

    private void jbInit() throws Exception {
        ResourceUtils.resLabel((JLabel)this.packageLabel, (Component)this.packageTextField, (String)JProjectArb.getString((int)45));
        ResourceUtils.resLabel((JLabel)this.outputDirLabel, (Component)this.outputDirTextField, (String)JProjectArb.getString((int)141));
        ResourceUtils.resLabel((JLabel)this.defaultSourceDirLabel, (Component)this.defaultSourceDirTextField, (String)JProjectArb.getString((int)42));
        ResourceUtils.resButton((AbstractButton)this.outputDirButton, (String)JProjectArb.getString((int)41));
        this.projectContentPanel.setContentSetLabel(ModelArb.getString((int)130));
        this.outputDirTextField.setDialogTitle(JProjectArb.getString((int)142));
        this.outputDirButton.addActionListener((ActionListener)this.outputDirTextField);
        Insets emptyInsets = new Insets(0, 0, 0, 0);
        Insets textField = new Insets(0, 5, 0, 0);
        int Y = -1;
        this.setLayout(new GridBagLayout());
        this.add(this.defaultSourceDirLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, emptyInsets, 0, 0));
        this.add((Component)this.defaultSourceDirTextField, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, textField, 0, 0));
        this.add(this.projectContentPanel, new GridBagConstraints(0, -1, 3, 1, 1.0, 10.0, 17, 1, new Insets(0, 0, 5, 0), 0, 0));
        this.add(this.outputDirLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 0, 0, 0), 0, 0));
        this.add((Component)this.outputDirTextField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(this.outputDirButton, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 8, 0, 0), 0, 0));
        this.add(this.packageLabel, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.add(this.packageTextField, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 5, 0, 0), 0, 0));
        this.add(new JLabel(), new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 17, 1, emptyInsets, 0, 0));
    }
}

