/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.java.legacy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import oracle.ide.util.IdeUtil;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.JavaVariable;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.expression.SourceExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceListExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceLiteralExpression;
import oracle.javatools.parser.java.v2.model.expression.SourceMethodCallExpression;
import oracle.javatools.parser.java.v2.model.statement.SourceExpressionStatement;

public class Jot2Utils {
    public static Collection getMethods(JavaClass cls, String name) {
        Collection methods = cls != null ? cls.getMethods() : null;
        return Jot2Utils.getMethods(methods, name);
    }

    public static Collection getDeclaredMethods(JavaClass cls, String name) {
        Collection methods = cls != null ? cls.getDeclaredMethods() : null;
        return Jot2Utils.getMethods(methods, name);
    }

    private static Collection getMethods(Collection methods, String name) {
        Iterator i = methods != null ? methods.iterator() : null;
        ArrayList<JavaMethod> list = new ArrayList<JavaMethod>();
        String string = name = name != null ? name.trim() : "";
        if (i != null && name.length() > 0) {
            while (i.hasNext()) {
                JavaMethod method = (JavaMethod)i.next();
                String methodName = method != null ? method.getName() : "";
                if (!name.equals(methodName)) continue;
                list.add(method);
            }
        }
        return list;
    }

    public static Collection getParameterTypes(JavaMethod jMethod) {
        Collection params = jMethod != null ? jMethod.getParameters() : null;
        Iterator pIter = params != null ? params.iterator() : null;
        ArrayList<JavaType> list = new ArrayList<JavaType>();
        if (pIter != null) {
            while (pIter.hasNext()) {
                JavaVariable param = (JavaVariable)pIter.next();
                JavaType type = param != null ? param.getResolvedType() : null;
                if (type == null) continue;
                list.add(type);
            }
        }
        return list;
    }

    public static boolean isNull(SourceExpression expr) {
        if (expr != null && expr.getSymbolKind() == 52) {
            SourceLiteralExpression jLiteral = (SourceLiteralExpression)expr;
            return jLiteral.getTokenValue() == 15;
        }
        return false;
    }

    public static String getMinimumReferenceName(SourceFile jFile, String qualifiedName) {
        Iterator iIter;
        int index = qualifiedName != null ? qualifiedName.lastIndexOf(46) : -1;
        String shortName = index >= 0 ? qualifiedName.substring(index) : qualifiedName;
        List imports = jFile.getSourceImports();
        Iterator iterator = iIter = imports != null ? imports.iterator() : null;
        if (iIter != null) {
            while (iIter.hasNext()) {
                SourceImport i = (SourceImport)iIter.next();
                String conflict = i.getName();
                index = conflict.lastIndexOf(46);
                conflict = index >= 0 ? conflict.substring(index) : conflict;
                if (!conflict.equals(shortName)) continue;
                return qualifiedName;
            }
        }
        return shortName;
    }

    public static SourceExpressionStatement getEnclosingStatement(SourceExpression jExpr) {
        SourceElement jElement;
        SourceElement sourceElement = jElement = jExpr != null ? jExpr.getParent() : null;
        while (jElement != null && !(jElement instanceof SourceExpressionStatement)) {
            jElement = jElement.getParent();
        }
        return (SourceExpressionStatement)jElement;
    }

    public static SourceExpression[] getMethodCalls(SourceBlock jCodeBlock, String name) {
        Iterator eIter;
        if (jCodeBlock == null) {
            return new SourceExpression[0];
        }
        ArrayList<SourceExpression> calls = new ArrayList<SourceExpression>();
        List elements = jCodeBlock.getCodeElements();
        Iterator iterator = eIter = elements != null ? elements.iterator() : null;
        if (eIter != null) {
            while (eIter.hasNext()) {
                SourceExpressionStatement jExprStmt;
                SourceExpression jExpression;
                SourceElement jStatement = (SourceElement)eIter.next();
                if (jStatement.getSymbolKind() != 36 || (jExpression = (jExprStmt = (SourceExpressionStatement)jStatement).getExpression()) == null || jExpression.getSymbolKind() != 53) continue;
                String methodName = ((SourceMethodCallExpression)jExpression).getName();
                if (name != null && !name.equals(methodName)) continue;
                calls.add(jExpression);
            }
        }
        return calls.toArray(new SourceExpression[calls.size()]);
    }

    public static SourceExpression addArgument(SourceMethodCallExpression methodCall, SourceExpression sibling, boolean isBefore, String argument) {
        int index;
        SourceFile jFile = methodCall.getOwningSourceFile();
        SourceFactory jFactory = jFile.getFactory();
        SourceExpression jExpr = jFactory.createExpression(argument);
        SourceListExpression jListExpr = methodCall.getArgumentList();
        List list = jListExpr.getOperands();
        int n = index = sibling != null ? list.indexOf(sibling) : -1;
        if (index < 0) {
            int n2 = index = isBefore ? 0 : list.size() - 1;
        }
        if (index == 0 && isBefore) {
            index = 1;
        }
        list.add(isBefore ? --index : ++index, jExpr);
        jFile.getTransaction().savepoint();
        return jExpr;
    }

    public static boolean isValidClassName(String name) {
        boolean result = false;
        if (name.length() > 0 && !name.startsWith(".") && !name.endsWith(".") && name.indexOf("..") == -1) {
            StringTokenizer tok = new StringTokenizer(name, ".");
            result = true;
            while (tok.hasMoreTokens()) {
                if (Jot2Utils.isValidIdentifier(tok.nextToken())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static boolean isValidIdentifier(String name) {
        return IdeUtil.isJavaIdentifier((String)name);
    }

    public static final int[] getDimensions(String declaration) {
        int startPos;
        ArrayList<String> dimensions = new ArrayList<String>();
        int endPos = 0;
        while (endPos >= 0 && (startPos = declaration.indexOf(91, endPos)) >= 0 && (endPos = declaration.indexOf(93, startPos)) >= 0) {
            dimensions.add(declaration.substring(startPos + 1, endPos));
        }
        int[] result = new int[dimensions.size()];
        Iterator i = dimensions.iterator();
        int index = 0;
        while (i.hasNext()) {
            result[index] = 0;
            try {
                String dimension = (String)i.next();
                if (dimension != null && dimension.length() > 0) {
                    result[index] = Integer.parseInt(dimension);
                }
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            ++index;
        }
        return result;
    }
}

