/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.help;

import java.awt.Component;
import java.awt.EventQueue;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.JOptionPane;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.help.BrowseSymbolResolver;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.SwingWorker;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.dialogs.progress.IndeterminateProgressMonitor;
import oracle.jdeveloper.javadoc.JProjectJavadoc;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.resource.JavadocUtilArb;

public final class JavadocUtil
extends BrowseSymbolResolver {
    private static final String HTM_EXTENSION = ".htm";
    private static final String HTML_ADDITION = "l";

    public URL resolveBrowseSymbol(Context context, String browseSymbol) {
        return JavadocUtil.resolveJavadocURL(context, browseSymbol);
    }

    public static URL resolveJavadocURL(Context ctx, String symbolName) {
        return JavadocUtil.resolveJavadocURL(ctx.getProject(), symbolName);
    }

    public static URL resolveJavadocURL(Project jProject, String symbolName) {
        try {
            if (jProject == null) {
                jProject = Ide.getDefaultProject();
            }
            URLPath urlPath = new URLPath();
            JavadocUtil.buildURLSearchPath(urlPath, jProject);
            Project[] depProjects = PathsConfiguration.getDependentProjects((Project)jProject);
            if (depProjects != null) {
                for (Project project : depProjects) {
                    JavadocUtil.buildURLSearchPath(urlPath, project);
                }
            }
            URL[] sortEntries = urlPath.getEntries();
            JavadocUtil.orderPathsHttpLast(sortEntries);
            urlPath.setEntries(sortEntries);
            String s = urlPath.toString();
            return JavadocUtil.resolveJavadocURL(urlPath, symbolName);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void buildURLSearchPath(URLPath combinedPath, Project project) {
        URLPath urlPath = PathsConfiguration.getInstance((Project)project).getDocPath();
        JProjectJavadoc javadoc = JProjectJavadoc.getInstance((PropertyStorage)project, project.getURL());
        URL javadocURL = javadoc.getOutputDirectory();
        if (javadocURL != null && URLFileSystem.exists((URL)javadocURL)) {
            URL[] urls = urlPath.getEntries();
            urlPath.setEntries(null);
            urlPath.add(javadocURL);
            urlPath.add(urls);
        }
        combinedPath.add(urlPath);
    }

    public static void orderPathsHttpLast(URL[] urls) {
        Arrays.sort(urls, new PathComparator());
    }

    public static URL resolveJavadocURL(URLPath urlPath, final String symbolName) {
        final URL[] entries = urlPath.getEntries();
        final int numEntries = entries.length;
        final Object[] searchOutput = new Object[1];
        final IndeterminateProgressMonitor progressMonitor = new IndeterminateProgressMonitor((Component)Ide.getMainWindow(), JavadocUtilArb.getString(0));
        progressMonitor.setMillisToPopup(100);
        progressMonitor.setCancellable(true);
        progressMonitor.setCloseOnFinish(true);
        progressMonitor.start();
        SwingWorker swingWorker = new SwingWorker(){

            public Object construct() {
                for (int i = 0; i < numEntries; ++i) {
                    for (URL thisCandidate : JavadocUtil.getFullCandidateURLs(entries[i], symbolName)) {
                        if (progressMonitor.getPanel() != null) {
                            progressMonitor.getPanel().setNote(URLFileSystem.getPlatformPathName((URL)thisCandidate));
                        }
                        try {
                            if (!URLFileSystem.exists((URL)thisCandidate)) continue;
                            searchOutput[0] = thisCandidate;
                            return null;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                }
                searchOutput[0] = false;
                return null;
            }

            public void finished() {
            }
        };
        swingWorker.start();
        while (!progressMonitor.isCancelled() && searchOutput[0] == null) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                progressMonitor.close();
            }
        }
        progressMonitor.close();
        if (progressMonitor.isCancelled()) {
            swingWorker.interrupt();
            return null;
        }
        if (searchOutput[0] instanceof Boolean) {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), JavadocUtilArb.format(1, symbolName));
                }
            };
            if (EventQueue.isDispatchThread()) {
                runnable.run();
            } else {
                EventQueue.invokeLater(runnable);
            }
            return null;
        }
        return (URL)searchOutput[0];
    }

    private static URL[] getFullCandidateURLs(URL rootURL, String symbolName) {
        URL[] candidates = new URL[2];
        URL candidate1 = null;
        URL candidate2 = null;
        String symbolAsPath = symbolName.replace('.', '/');
        if (JarUtil.isJarURL((URL)rootURL)) {
            URL root = JarUtil.getJarFileURL((URL)rootURL);
            StringBuffer buf = new StringBuffer(100);
            String s = JarUtil.getJarEntry((URL)rootURL);
            buf.append(s);
            if (!s.endsWith("/") && s.length() > 0) {
                buf.append("/");
            }
            buf.append(symbolAsPath);
            buf.append(HTM_EXTENSION);
            candidate1 = URLFactory.newJarURL((URL)root, (String)buf.toString());
            buf.append(HTML_ADDITION);
            candidate2 = URLFactory.newJarURL((URL)root, (String)buf.toString());
        } else {
            String htmFile = symbolAsPath + HTM_EXTENSION;
            String htmlFile = htmFile + HTML_ADDITION;
            candidate1 = URLFactory.newURL((URL)rootURL, (String)htmFile);
            candidate2 = URLFactory.newURL((URL)rootURL, (String)htmlFile);
        }
        candidates[0] = candidate2;
        candidates[1] = candidate1;
        return candidates;
    }

    public static void main(String[] args) {
        try {
            JavadocUtil.test1();
            JavadocUtil.test2();
            JavadocUtil.test3();
            JavadocUtil.test4();
        }
        catch (MalformedURLException mfuEx) {
            mfuEx.printStackTrace();
        }
    }

    private static void test1() throws MalformedURLException {
        URL rootURL = new URL("jar:file:/C:/foo.jar!/doc/");
        URL[] us = JavadocUtil.getFullCandidateURLs(rootURL, "java.net.URL");
        System.out.println(us[0].toString());
        System.out.println(us[1].toString());
    }

    private static void test2() throws MalformedURLException {
        URL rootURL2 = new URL("jar:file:/C:/foo.jar!/");
        URL[] us2 = JavadocUtil.getFullCandidateURLs(rootURL2, "java.net.URL");
        System.out.println(us2[0].toString());
        System.out.println(us2[1].toString());
    }

    private static void test3() throws MalformedURLException {
        URL rootURL = new URL("file:/C:/foo");
        URL[] us = JavadocUtil.getFullCandidateURLs(rootURL, "java.net.URL");
        System.out.println(us[0].toString());
        System.out.println(us[1].toString());
    }

    private static void test4() throws MalformedURLException {
        URL rootURL = new URL("file:/C:/foo/");
        URL[] us = JavadocUtil.getFullCandidateURLs(rootURL, "java.net.URL");
        System.out.println(us[0].toString());
        System.out.println(us[1].toString());
    }

    private static class PathComparator
    implements Comparator {
        private PathComparator() {
        }

        public int compare(Object o1, Object o2) {
            URL url2;
            String p2;
            URL url1 = (URL)o1;
            String p1 = url1.getProtocol();
            if (p1.equals(p2 = (url2 = (URL)o2).getProtocol())) {
                return 0;
            }
            if (p1.equals("http")) {
                return 1;
            }
            if (p2.equals("http")) {
                return -1;
            }
            return 0;
        }
    }
}

