/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.engine;

import java.lang.reflect.Modifier;
import java.net.URL;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;
import oracle.ide.Ide;
import oracle.ide.controls.StatusBar;
import oracle.ide.model.Node;
import oracle.ide.model.NodeFactory;
import oracle.ide.model.Project;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFileSystemHelper;
import oracle.ide.net.URLPath;
import oracle.ide.util.IdeUtil;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.parser.java.v2.CallerContext;
import oracle.javatools.parser.java.v2.SourceFactory;
import oracle.javatools.parser.java.v2.common.PrimitiveType;
import oracle.javatools.parser.java.v2.model.JavaAnnotation;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.javatools.parser.java.v2.model.JavaElement;
import oracle.javatools.parser.java.v2.model.JavaMethod;
import oracle.javatools.parser.java.v2.model.JavaType;
import oracle.javatools.parser.java.v2.model.SourceAnnotation;
import oracle.javatools.parser.java.v2.model.SourceBlock;
import oracle.javatools.parser.java.v2.model.SourceClass;
import oracle.javatools.parser.java.v2.model.SourceElement;
import oracle.javatools.parser.java.v2.model.SourceFile;
import oracle.javatools.parser.java.v2.model.SourceImport;
import oracle.javatools.parser.java.v2.model.SourceMethod;
import oracle.javatools.parser.java.v2.model.SourceTypeArgument;
import oracle.javatools.parser.java.v2.model.SourceTypeReference;
import oracle.javatools.parser.java.v2.model.statement.SourceTryStatement;
import oracle.javatools.parser.java.v2.write.SourceSavepoint;
import oracle.javatools.parser.java.v2.write.SourceTransaction;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.engine.AnnotationUtils;
import oracle.jdeveloper.engine.EngineConstants;
import oracle.jdeveloper.engine.EngineException;
import oracle.jdeveloper.engine.FieldInfo;
import oracle.jdeveloper.engine.MethodInfo;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.JProjectUtil;
import oracle.jdeveloper.model.JavaClassNode;
import oracle.jdeveloper.model.JavaNode;
import oracle.jdeveloper.model.JavaProject;
import oracle.jdeveloper.model.JavaSourceNode;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdevimpl.config.JProjectPaths;

public class EngineUtils
implements EngineConstants {
    public static final String JAVA_LANG = "java.lang";
    public static final String JAVA_MATH = "java.math";
    private static String[][] collectionTypeMap = new String[][]{{"Collection", "java.util.Collection"}, {"List", "java.util.List"}, {"Set", "java.util.Set"}, {"Map", "java.util.Map"}, {"Vector", "java.util.Vector"}};
    private static String[][] primitiveTypeMap = new String[][]{{"boolean", "java.lang.Boolean"}, {"byte", "java.lang.Byte"}, {"char", "java.lang.Character"}, {"double", "java.lang.Double"}, {"float", "java.lang.Float"}, {"int", "java.lang.Integer"}, {"long", "java.lang.Long"}, {"short", "java.lang.Short"}};

    public static void printStatus(String statusType, String info) {
        StatusBar statusBar = Ide.getStatusBar();
        statusBar.setText(statusType + info);
    }

    public static String getShortName(String qualifiedClassName) {
        if (qualifiedClassName == null) {
            return null;
        }
        String genShortClassName = null;
        int genIndex = qualifiedClassName.indexOf(60);
        if (genIndex > 0) {
            String genClassName = qualifiedClassName.substring(genIndex + 1, qualifiedClassName.length() - 1);
            genShortClassName = EngineUtils.getShortName(genClassName);
            qualifiedClassName = qualifiedClassName.substring(0, genIndex);
        }
        String shortClassName = qualifiedClassName;
        int index = qualifiedClassName.lastIndexOf(46);
        if (index >= 0) {
            shortClassName = qualifiedClassName.substring(index + 1);
        }
        if (genIndex >= 0) {
            shortClassName = shortClassName + '<' + genShortClassName + '>';
        }
        return shortClassName;
    }

    public static final String getPackage(String qualifiedClassName) {
        int index;
        if (!ModelUtil.hasLength((String)qualifiedClassName)) {
            return "";
        }
        int genIndex = qualifiedClassName.indexOf(60);
        if (genIndex > 0) {
            qualifiedClassName = qualifiedClassName.substring(0, genIndex - 1);
        }
        return (index = qualifiedClassName.lastIndexOf(46)) >= 0 ? qualifiedClassName.substring(0, index) : "";
    }

    public static boolean isValidClassName(String name) {
        boolean result = false;
        if (name.length() > 0 && !name.startsWith(".") && !name.endsWith(".") && name.indexOf("..") == -1) {
            StringTokenizer tok = new StringTokenizer(name, ".");
            result = true;
            while (tok.hasMoreTokens()) {
                if (IdeUtil.isJavaIdentifier((String)tok.nextToken())) continue;
                result = false;
                break;
            }
        }
        return result;
    }

    public static String renderMethod(int modifiers, String methodType, String methodName, List parameters, Set thrown) {
        StringBuffer strBuf = new StringBuffer();
        if (modifiers >= 0) {
            strBuf.append(Modifier.toString(modifiers));
            strBuf.append(' ');
        }
        if (methodType != null) {
            strBuf.append(EngineUtils.getShortName(methodType));
            strBuf.append(' ');
        }
        if (methodName != null) {
            strBuf.append(methodName);
        }
        strBuf.append(EngineUtils.renderParams(parameters));
        if (thrown != null && thrown.size() > 0) {
            strBuf.append(" throws ");
            strBuf.append(EngineUtils.renderThrown(thrown));
        }
        return strBuf.toString();
    }

    public static String renderParams(List paramList) {
        return EngineUtils.renderParams(paramList, -1);
    }

    public static String renderParams(List paramList, int inset) {
        return EngineUtils.renderParams(paramList, inset, true);
    }

    public static String renderParams(List paramList, int inset, boolean includeParens) {
        Iterator itemIter;
        if (paramList == null || paramList.size() == 0) {
            return includeParens ? "()" : "";
        }
        char[] insetBuf = new char[inset + 2];
        Arrays.fill(insetBuf, ' ');
        StringBuffer strBuf = new StringBuffer();
        Iterator iter = paramList.iterator();
        Object item = iter.next();
        if (item instanceof List) {
            if (includeParens) {
                strBuf.append("( ");
            }
            itemIter = ((List)item).iterator();
            while (itemIter.hasNext()) {
                strBuf.append(EngineUtils.getShortName(itemIter.next().toString()));
                if (!itemIter.hasNext()) continue;
                strBuf.append(" ");
            }
        } else {
            strBuf.append(EngineUtils.getShortName(item.toString()));
        }
        while (iter.hasNext()) {
            if (inset >= 0) {
                strBuf.append(",\n");
                strBuf.append(insetBuf);
            } else {
                strBuf.append(", ");
            }
            item = iter.next();
            if (item instanceof List) {
                itemIter = ((List)item).iterator();
                while (itemIter.hasNext()) {
                    strBuf.append(EngineUtils.getShortName(itemIter.next().toString()));
                    if (!itemIter.hasNext()) continue;
                    strBuf.append(" ");
                }
                continue;
            }
            strBuf.append(EngineUtils.getShortName(item.toString()));
        }
        if (includeParens && strBuf.charAt(0) == '(') {
            strBuf.append(" )");
        }
        return strBuf.toString();
    }

    public static String renderThrown(Set throwList) {
        String value;
        if (throwList == null || throwList.size() == 0) {
            value = "";
        } else {
            StringBuffer strBuf = new StringBuffer();
            Iterator iter = throwList.iterator();
            boolean notFirst = false;
            while (iter.hasNext()) {
                if (notFirst) {
                    strBuf.append(", ");
                } else {
                    notFirst = true;
                }
                strBuf.append(EngineUtils.getShortName(iter.next().toString()));
            }
            value = strBuf.toString();
        }
        return value;
    }

    public static String renderColumn(ResultSet resultSet) {
        StringBuffer strBuf = new StringBuffer();
        try {
            int colSize;
            strBuf.append(resultSet.getString("TYPE_NAME"));
            if (!strBuf.toString().equals("DATE") && !strBuf.toString().startsWith("TIMESTAMP") && (colSize = resultSet.getInt("COLUMN_SIZE")) > 0) {
                strBuf.append('(');
                strBuf.append(colSize);
                int colPrec = resultSet.getInt("DECIMAL_DIGITS");
                if (colPrec > 0) {
                    strBuf.append(',');
                    strBuf.append(colPrec);
                }
                strBuf.append(')');
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return strBuf.toString();
    }

    public static String getJavaType(String colType) {
        if (colType.startsWith("NUMBER") || colType.startsWith("INTEGER")) {
            if (colType.indexOf(",") > 0) {
                return Double.class.getName();
            }
            return Long.class.getName();
        }
        if (colType.startsWith("FLOAT")) {
            return Float.class.getName();
        }
        if (colType.startsWith("DOUBLE")) {
            return Double.class.getName();
        }
        if (colType.startsWith("CLOB")) {
            return "char[]";
        }
        if (colType.startsWith("BLOB")) {
            return "byte[]";
        }
        if (colType.equals("DATE") || colType.startsWith("TIMESTAMP")) {
            return Timestamp.class.getName();
        }
        if (colType.toUpperCase().startsWith("TINYINT")) {
            return Byte.class.getName();
        }
        if (colType.toUpperCase().startsWith("SMALLINT")) {
            return Short.class.getName();
        }
        if (colType.toUpperCase().startsWith("MEDIUMINT") || colType.toUpperCase().startsWith("INT")) {
            return Integer.class.getName();
        }
        if (colType.toUpperCase().startsWith("BIGINT")) {
            return Long.class.getName();
        }
        if (colType.toUpperCase().startsWith("DECIMAL")) {
            return Number.class.getName();
        }
        if (colType.toUpperCase().startsWith("DATETIME") || colType.toUpperCase().startsWith("TIME")) {
            return Timestamp.class.getName();
        }
        return String.class.getName();
    }

    public static boolean isComplex(String type) {
        String pack;
        if (type == null) {
            return false;
        }
        return ModelUtil.hasLength((String)type) && PrimitiveType.lookupPrimitive((String)type) == null && (pack = EngineUtils.getPackage(type)) != null && !JAVA_LANG.equals(pack) && !JAVA_MATH.equals(pack) && !"java.sql".equals(pack) && !"java.util".equals(pack);
    }

    public static boolean isCollection(JavaManager javaMan, String type) {
        if (!EngineUtils.isCollection(type)) {
            JavaClass javaClass = javaMan.getClass(type);
            return javaClass != null && javaMan.getClass("java.util.Collection").isAssignableFrom((JavaType)javaClass);
        }
        return true;
    }

    public static boolean isCollection(String type) {
        if (type == null) {
            return false;
        }
        int j = EngineUtils.getPackage(type) == null ? 0 : 1;
        for (int i = 0; i < collectionTypeMap.length; ++i) {
            if (!type.startsWith(collectionTypeMap[i][j])) continue;
            return true;
        }
        return false;
    }

    public static boolean isArray(String type) {
        return type.indexOf(91) > 0;
    }

    public static void updateProjectAndNotify(Project project, Object origin, String[] libs, URL sourceDir) {
        EngineUtils.updateProjectAndNotify(project, origin, libs, sourceDir, null);
    }

    public static void updateProjectAndNotify(Project project, Object origin, String[] libs, URL sourceDir, URL classDir) {
        EngineUtils.updateProjectAndNotify(project, origin, libs, sourceDir, classDir, false);
    }

    public static void updateProjectAndNotify(final Project project, Object origin, final String[] libs, final URL sourceDir, final URL classDir, boolean notifyAlways) {
        project.applyBatchChanges(new Runnable(){

            @Override
            public void run() {
                JProjectPaths jJProjectPaths;
                URLPath classPath;
                if (classDir != null && !(classPath = (jJProjectPaths = JProjectPaths.getInstance((PropertyStorage)project)).getAdditionalClassPath()).contains(classDir)) {
                    classPath.add(classDir);
                    jJProjectPaths.setAdditionalClassPath(classPath);
                }
                if (libs != null) {
                    JProjectLibraries jlibs = JProjectLibraries.getInstance((PropertyStorage)project);
                    for (int i = 0; i < libs.length; ++i) {
                        jlibs.addLibrary((Object)libs[i]);
                    }
                }
                if (sourceDir != null) {
                    URLPath projSrcPath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
                    projSrcPath.add(sourceDir);
                    PathsConfiguration.getInstance((Project)project).setProjectSourcePath(projSrcPath);
                }
            }
        });
    }

    public static URL getProjectSourceDir(Project project) {
        URLPath projSourcePath;
        URL[] entries;
        URL projSourceDir = null;
        if (project != null && (entries = (projSourcePath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath()).getEntries()) != null) {
            for (int i = 0; i < entries.length; ++i) {
                if (!URLFileSystem.isDirectoryPath((URL)entries[i])) continue;
                projSourceDir = entries[i];
                break;
            }
        }
        return projSourceDir;
    }

    public static URL[] getProjectSourceDirs(Project project) {
        URL[] entries;
        URLPath projSourcePath;
        ArrayList<URL> dirList = new ArrayList<URL>();
        URLPath uRLPath = projSourcePath = project != null ? PathsConfiguration.getInstance((Project)project).getProjectSourcePath() : null;
        if (projSourcePath != null && (entries = projSourcePath.getEntries()) != null) {
            for (int i = 0; i < entries.length; ++i) {
                URLFileSystemHelper helper = URLFileSystem.findHelper((URL)entries[i]);
                if (!helper.isDirectoryPath(entries[i]) && !helper.isDirectory(entries[i])) continue;
                dirList.add(entries[i]);
            }
        }
        URL[] dirs = new URL[dirList.size()];
        dirList.toArray(dirs);
        return dirs;
    }

    public static boolean areEquivalentCollections(Collection coll1, Collection coll2) {
        return ModelUtil.areEqual((Object)coll1, (Object)coll2) || coll1 == null && coll2.size() == 0 || coll2 == null && coll1.size() == 0;
    }

    public static boolean areEquivalentParameters(Collection<List<String>> params1, Collection<List<String>> params2) {
        if (!(params1 != null && params1.size() != 0 || params2 != null && params2.size() != 0)) {
            return true;
        }
        if (params1 == null || params2 == null || params1.size() != params2.size()) {
            return false;
        }
        ArrayList<String> types1 = new ArrayList<String>(params1.size());
        for (List<String> param1List : params1) {
            types1.add(param1List.get(0));
        }
        ArrayList<String> types2 = new ArrayList<String>(params2.size());
        for (List<String> param2List : params2) {
            types2.add(param2List.get(0));
        }
        return ModelUtil.areEqual(types1, types2);
    }

    public static void expandTypes(SourceFile srcFile, MethodInfo methodInfo) {
        EngineUtils.expandType(srcFile, methodInfo);
        List params = methodInfo.parameters;
        int len = params != null ? params.size() : 0;
        for (int i = 0; i < len; ++i) {
            List param = (List)params.get(i);
            param.set(0, EngineUtils.expandType(srcFile, (String)param.get(0)));
        }
    }

    public static void expandType(SourceFile srcFile, FieldInfo fieldInfo) {
        if (fieldInfo != null) {
            fieldInfo.type = EngineUtils.expandType(srcFile, fieldInfo.type);
        }
    }

    public static String expandType(SourceFile srcFile, String type) {
        if (ModelUtil.hasLength((String)type) && "".equals(EngineUtils.getPackage(type))) {
            JavaType javaType;
            CallerContext context;
            if ("String".equals(type)) {
                return "java.lang.String";
            }
            if ("Boolean".equals(type)) {
                return "java.lang.Boolean";
            }
            if ("Byte".equals(type)) {
                return "java.lang.Byte";
            }
            if ("Character".equals(type)) {
                return "java.lang.Character";
            }
            if ("Double".equals(type)) {
                return "java.lang.Double";
            }
            if ("Float".equals(type)) {
                return "java.lang.Float";
            }
            if ("Integer".equals(type)) {
                return "java.lang.Integer";
            }
            if ("Long".equals(type)) {
                return "java.lang.Long";
            }
            if ("Number".equals(type)) {
                return "java.lang.Number";
            }
            if ("Short".equals(type)) {
                return "java.lang.Short";
            }
            if ("Void".equals(type)) {
                return "java.lang.Void";
            }
            if ("Object".equals(type)) {
                return "java.lang.Object";
            }
            if ("Date".equals(type)) {
                return "java.sql.Date";
            }
            if ("Timestamp".equals(type)) {
                return "java.sql.Timestamp";
            }
            if ("Collection".equals(type)) {
                return "java.util.Collection";
            }
            if ("List".equals(type)) {
                return "java.util.List";
            }
            if ("Set".equals(type)) {
                return "java.util.Set";
            }
            if ("Map".equals(type)) {
                return "java.util.Map";
            }
            if ("Iterator".equals(type)) {
                return "java.util.Iterator";
            }
            if ("Enumeration".equals(type)) {
                return "java.util.Enumeration";
            }
            if (type.startsWith("Set<") || type.startsWith("Collection<") || type.startsWith("List<")) {
                return "java.util." + type;
            }
            if (srcFile != null && (context = CallerContext.createContext((SourceElement)srcFile)) != null && (javaType = context.resolveTypeName(type)) != null) {
                return javaType.getQualifiedName();
            }
        }
        return type;
    }

    public static JavaClass getJavaClass(JavaManager javaManager, String className, int needs) {
        JavaClass javaClass = null;
        try {
            javaClass = javaManager.getClass(className);
        }
        catch (Exception e) {
            javaClass = null;
        }
        if (javaClass == null) {
            javaManager.getCacheSupport().flushCache();
            javaClass = javaManager.getClass(className);
        }
        return javaClass;
    }

    public static SourceClass getSourceClass(JavaManager javaManager, String className) {
        SourceClass srcClass = null;
        try {
            srcClass = javaManager.getSourceClass(className);
        }
        catch (Exception e) {
            srcClass = null;
        }
        if (srcClass == null) {
            javaManager.getCacheSupport().flushCache();
            srcClass = javaManager.getSourceClass(className);
        }
        return srcClass;
    }

    public static SourceFile getSourceFile(JavaManager javaManager, String className) {
        SourceClass srcClass = EngineUtils.getSourceClass(javaManager, className);
        return srcClass != null ? srcClass.getOwningSourceFile() : null;
    }

    public static SourceClass getSourceClass(JavaSourceNode javaSrcNode, Project project) {
        JavaClass javaClass;
        SourceFile srcFile = JavaManager.getJavaManager((Project)project).getSourceFile(javaSrcNode.getURL());
        if (srcFile != null && (javaClass = srcFile.getPrimaryClass()) != null) {
            return (SourceClass)javaClass.getSourceElement();
        }
        return null;
    }

    public static JavaNode getJavaNode(Project project, String className) {
        URL url;
        className = className.replace('.', '/');
        URLPath srcPath = PathsConfiguration.getInstance((Project)project).getProjectSourcePath();
        URL[] entries = srcPath.getEntries();
        for (int i = 0; i < entries.length; ++i) {
            Node node;
            url = URLFactory.newURL((URL)entries[i], (String)(className + ".java"));
            if (!URLFileSystem.isBound((URL)url) || (node = EngineUtils.findNode(JavaSourceNode.class, url)) == null) continue;
            return (JavaNode)node;
        }
        URL outDir = JavaProject.getInstance((Project)project).getOutputDirectory();
        url = URLFactory.newURL((URL)outDir, (String)(className + ".class"));
        if (URLFileSystem.isBound((URL)url)) {
            return (JavaNode)EngineUtils.findNode(JavaClassNode.class, url);
        }
        return null;
    }

    public static Node findNode(Class clazz, URL url) {
        Node node = NodeFactory.find((URL)url);
        if (node == null && URLFileSystem.isBound((URL)url)) {
            try {
                node = clazz != null ? NodeFactory.findOrCreate((Class)clazz, (URL)url) : NodeFactory.findOrCreate((URL)url);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return node;
    }

    public static boolean removeImport(SourceFile srcFile, String className) {
        if (srcFile != null && className != null && ModelUtil.hasLength((String)(className = EngineUtils.trimClass(className)))) {
            Iterator iter = srcFile.getSourceImports().iterator();
            while (iter.hasNext()) {
                SourceImport imp = (SourceImport)iter.next();
                if (!className.equals(imp.getName())) continue;
                EngineUtils.openTransaction(srcFile);
                iter.remove();
                return true;
            }
        }
        return false;
    }

    public static void addImport(String clazz, SourceFile srcFile) {
        EngineUtils.addImport(clazz, srcFile, false);
    }

    public static void addImport(String clazz, SourceFile srcFile, boolean isStatic) {
        if (ModelUtil.hasLength((String)clazz) && !"void".equals(clazz) && !clazz.startsWith("java.lang.")) {
            int genIndex = (clazz = EngineUtils.trimClass(clazz)).indexOf(60);
            if (genIndex > 0) {
                String genType = clazz.substring(genIndex + 1, clazz.length() - 1);
                EngineUtils.addImport(genType, srcFile);
                clazz = clazz.substring(0, genIndex);
            }
            if (ModelUtil.hasLength((String)clazz) && clazz.indexOf(46) > 0 && !EngineUtils.getPackage(clazz).equals(srcFile.getPackageName())) {
                SourceFactory factory = srcFile.getFactory();
                SourceTypeReference impType = EngineUtils.createType(factory, clazz);
                List imports = srcFile.getSourceImports();
                if (!impType.isPrimitive()) {
                    TreeSet<String> treeSet = new TreeSet<String>();
                    for (SourceImport imp : imports) {
                        if (clazz.equals(imp.getName())) {
                            return;
                        }
                        treeSet.add(imp.getName());
                    }
                    EngineUtils.openTransaction(srcFile);
                    SourceImport newImp = factory.createImportDeclaration(clazz);
                    if (isStatic) {
                        newImp.setModifiers(8);
                    }
                    int i = 0;
                    for (SourceImport imp : imports) {
                        if (clazz.compareTo(imp.getName()) < 0) {
                            imports.add(i, newImp);
                            return;
                        }
                        ++i;
                    }
                    imports.add(newImp);
                }
            }
        }
    }

    public static String getGenericCollectionType(String type) {
        int genIndex = type.indexOf(60);
        if (genIndex > 0) {
            int endIndex = type.lastIndexOf(62);
            return endIndex > genIndex ? type.substring(genIndex + 1, endIndex) : type;
        }
        return null;
    }

    public static SourceTypeReference createType(SourceFactory factory, String type) {
        int genIndex = type.indexOf(60);
        SourceTypeReference srcGenType = null;
        if (genIndex > 0) {
            String genType = type.substring(genIndex + 1, type.length() - 1);
            srcGenType = factory.createType(EngineUtils.getShortName(genType));
            type = type.substring(0, genIndex);
        }
        SourceTypeReference srcType = factory.createType(EngineUtils.getShortName(type));
        if (srcGenType != null) {
            SourceTypeArgument arg = factory.createTypeArgument(0, srcGenType);
            srcType.getTypeArguments().add(arg);
        }
        return srcType;
    }

    public static String trimClass(String clazz) {
        if (clazz != null) {
            clazz = clazz.trim();
            StringBuffer strBuf = new StringBuffer(clazz);
            for (int i = strBuf.length() - 1; i >= 0; --i) {
                if (strBuf.charAt(i) != '[') continue;
                strBuf.setLength(i);
                break;
            }
            return strBuf.toString().trim();
        }
        return clazz;
    }

    public static void removeInterface(SourceClass srcClass, String iface, boolean removeMethods) {
        SourceFile srcFile = srcClass.getOwningSourceFile();
        SourceFactory factory = srcFile.getFactory();
        EngineUtils.openTransaction(srcFile);
        List srcInterfaces = srcClass.getSourceInterfaces();
        Iterator iter = srcInterfaces.iterator();
        while (iter.hasNext()) {
            SourceTypeReference srcType = (SourceTypeReference)iter.next();
            JavaType javaType = srcType.getResolvedType();
            if (javaType == null || javaType.getName().compareTo(iface) != 0) continue;
            iter.remove();
        }
        srcClass.getSourceInterfaces().remove(EngineUtils.createType(factory, iface));
        if (removeMethods) {
            // empty if block
        }
    }

    public static boolean implementInterface(JavaManager javaManager, SourceClass srcClass, String iface) throws EngineException {
        return EngineUtils.implementInterface(javaManager, srcClass, iface, null);
    }

    public static boolean implementInterface(JavaManager javaManager, SourceClass srcClass, String iface, String internalIgnoreException) throws EngineException {
        return EngineUtils.addOrImplementInterface(javaManager, srcClass, iface, internalIgnoreException, true);
    }

    public static boolean addInterface(JavaManager javaManager, SourceClass srcClass, String iface) {
        boolean result = false;
        try {
            result = EngineUtils.addOrImplementInterface(javaManager, srcClass, iface, null, false);
        }
        catch (EngineException e) {
            // empty catch block
        }
        return result;
    }

    public static boolean addOrImplementInterface(JavaManager javaManager, SourceClass srcClass, String iface, String internalIgnoreException, boolean implement) throws EngineException {
        return EngineUtils.addOrImplementInterface(javaManager, srcClass, iface, internalIgnoreException, implement, false);
    }

    public static boolean addOrImplementInterface(JavaManager javaManager, SourceClass srcClass, String iface, String internalIgnoreException, boolean implement, boolean makePrimary) throws EngineException {
        JavaClass ifaceClass = EngineUtils.getJavaClass(javaManager, iface, -1);
        if (implement && ifaceClass == null) {
            throw new EngineException("Interface " + iface + " not found!");
        }
        if (implement && !ifaceClass.isInterface()) {
            throw new EngineException("Class " + iface + " is not an interface!");
        }
        SourceFile srcFile = srcClass.getOwningSourceFile();
        SourceFactory factory = srcFile.getFactory();
        EngineUtils.addImport(iface, srcFile);
        EngineUtils.openTransaction(srcFile);
        if (makePrimary) {
            srcClass.getSourceInterfaces().add(0, EngineUtils.createType(factory, iface));
        } else {
            srcClass.getSourceInterfaces().add(EngineUtils.createType(factory, iface));
        }
        if (implement) {
            List sourceMethods = srcClass.getSourceMethods();
            for (JavaMethod meth : ifaceClass.getDeclaredMethods()) {
                MethodInfo mi = new MethodInfo(meth);
                if (ModelUtil.hasLength((String)internalIgnoreException)) {
                    mi.removeException(internalIgnoreException);
                }
                mi.modifiers = 1;
                sourceMethods.add(mi.createSourceMethod(srcFile, true));
            }
        }
        return true;
    }

    public static SourceBlock createTryCatchClause(SourceFile srcFile, SourceFactory factory, SourceBlock codeBlock, String[] exceptions) {
        SourceBlock tryBlock = factory.createBlock();
        EngineUtils.addImport(exceptions[0], srcFile);
        SourceBlock catchBlock = factory.createBlock(new SourceElement[]{factory.createStatement("e.printStackTrace();")});
        SourceTryStatement tryStmt = factory.createTryCatchStatement(factory.createBlockStatement(tryBlock), factory.createLocalVariable(factory.createType(exceptions[0]), "e"), factory.createBlockStatement(catchBlock));
        for (int i = 1; i < exceptions.length; ++i) {
            EngineUtils.addImport(exceptions[i], srcFile);
            catchBlock = factory.createBlock(new SourceElement[]{factory.createStatement("e.printStackTrace();")});
            tryStmt.getCatchClauses().add(factory.createCatchClause(factory.createLocalVariable(factory.createType(exceptions[i]), "e"), factory.createBlockStatement(catchBlock)));
        }
        codeBlock.getCodeElements().add(tryStmt);
        return tryBlock;
    }

    public static final String getPackageFromFullClassName(String fullName) {
        return EngineUtils.getPackage(fullName);
    }

    public static SourceTransaction openTransaction(SourceFile srcFile) {
        SourceTransaction trans = srcFile.getTransaction();
        if (trans == null) {
            trans = srcFile.beginTransaction();
        }
        return trans;
    }

    public static SourceSavepoint createSavepoint(SourceFile srcFile) {
        return EngineUtils.openTransaction(srcFile).savepoint();
    }

    public static boolean isPublic(int modifiers) {
        return (modifiers & 1) != 0;
    }

    public static boolean isPrivate(int modifiers) {
        return (modifiers & 2) != 0;
    }

    public static boolean isProtected(int modifiers) {
        return (modifiers & 4) != 0;
    }

    public static boolean isAbstract(int modifiers) {
        return (modifiers & 0x400) != 0;
    }

    public static boolean isNative(int modifiers) {
        return (modifiers & 0x100) != 0;
    }

    public static boolean isFinal(int modifiers) {
        return (modifiers & 0x10) != 0;
    }

    public static String getPrimitiveFromClass(String type) {
        for (int i = 0; i < primitiveTypeMap.length; ++i) {
            if (!type.equals(primitiveTypeMap[i][1])) continue;
            return primitiveTypeMap[i][0];
        }
        return null;
    }

    public static String getClassFromPrimitive(String type) {
        for (int i = 0; i < primitiveTypeMap.length; ++i) {
            if (!type.equals(primitiveTypeMap[i][0])) continue;
            return primitiveTypeMap[i][1];
        }
        return null;
    }

    public static boolean fileExists(Project project, String packageName, String className) {
        URL url = EngineUtils.makeFileURL(project, packageName, className + ".java");
        return URLFileSystem.isBound((URL)url);
    }

    public static String capitalize(String propertyName) {
        if (!ModelUtil.hasLength((String)propertyName)) {
            return propertyName;
        }
        char[] chars = propertyName.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String makeReaderName(String propertyName, String type) {
        String string = type = type != null ? EngineUtils.getShortName(type) : type;
        if (type == null) {
            return propertyName;
        }
        return (type.toLowerCase().equals("boolean") ? "is" : "get") + EngineUtils.capitalize(propertyName);
    }

    public static String makeReaderName(String propertyName) {
        return "get" + EngineUtils.capitalize(propertyName);
    }

    public static String makeWriterName(String propertyName) {
        return "set" + EngineUtils.capitalize(propertyName);
    }

    public static Node createNode(Project project, String packageName, String fileName) {
        URL url = EngineUtils.makeFileURL(project, packageName, fileName);
        try {
            return NodeFactory.findOrCreate((URL)url);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String makeFilePath(Project project, String packageName, String fileName) {
        return URLFileSystem.getPlatformPathName((URL)EngineUtils.makeFileURL(project, packageName, fileName));
    }

    public static URL makeFileURL(Project project, String pkgName, String fileName) {
        URL baseURL = JProjectUtil.getProjectBasePath((Project)project);
        URL dir = pkgName != null && pkgName.length() > 0 ? URLFactory.newDirURL((URL)baseURL, (String)pkgName.replace('.', '/')) : baseURL;
        return URLFactory.newURL((URL)dir, (String)fileName);
    }

    public static void addAnnotation(SourceElement srcElem, String annoClass, List exprs) {
        AnnotationUtils.addAnnotation(srcElem, annoClass, exprs);
    }

    public static String getSourceAnnotationAttr(SourceElement srcElem, String annoClass, String attrName, String defaultValue) {
        return AnnotationUtils.getSourceAnnotationAttr(srcElem, annoClass, attrName, defaultValue);
    }

    public static String getSourceAnnotationAttr(SourceAnnotation srcAnno, String attrName, String defaultValue) {
        return AnnotationUtils.getSourceAnnotationAttr(srcAnno, attrName, defaultValue);
    }

    public static SourceAnnotation getSourceAnnotation(SourceElement srcElem, String annoClass) {
        return AnnotationUtils.getSourceAnnotation(srcElem, annoClass);
    }

    public static String getJavaAnnotationAttr(JavaElement javaElem, String annoClass, String attrName, String defaultValue) {
        return AnnotationUtils.getJavaAnnotationAttr(javaElem, annoClass, attrName, defaultValue);
    }

    public static String getJavaAnnotationAttr(JavaAnnotation javaAnno, String attrName, String defaultValue) {
        return AnnotationUtils.getJavaAnnotationAttr(javaAnno, attrName, defaultValue);
    }

    public static JavaAnnotation getJavaAnnotation(JavaElement javaElem, String annoClass) {
        return AnnotationUtils.getJavaAnnotation(javaElem, annoClass);
    }

    public static String sanitizeMethodName(String name) {
        char[] methodName = name.toCharArray();
        StringBuffer strBuf = new StringBuffer();
        boolean nextCharUppercase = false;
        for (int i = 0; i < methodName.length; ++i) {
            if (i == 0 && !Character.isJavaIdentifierStart(methodName[0]) && Character.isJavaIdentifierPart(methodName[0])) {
                strBuf.append('_');
                strBuf.append(methodName[0]);
                continue;
            }
            if (!Character.isJavaIdentifierPart(methodName[i])) {
                nextCharUppercase = true;
                continue;
            }
            if (nextCharUppercase) {
                strBuf.append(Character.toUpperCase(methodName[i]));
                nextCharUppercase = false;
                continue;
            }
            strBuf.append(methodName[i]);
        }
        return strBuf.toString();
    }

    public static boolean isInterfaceImplemented(SourceClass srcClass, String iface) {
        if (srcClass == null) {
            return false;
        }
        for (SourceTypeReference srcType : srcClass.getSourceInterfaces()) {
            JavaType javaType = srcType.getResolvedType();
            if (javaType == null || javaType.getName().compareTo(iface) != 0 && javaType.getQualifiedName().compareTo(iface) != 0) continue;
            return true;
        }
        return false;
    }

    public static String getInterfaceQualifiedName(SourceClass srcClass, String iface) {
        if (srcClass == null) {
            return iface;
        }
        for (SourceTypeReference srcType : srcClass.getSourceInterfaces()) {
            JavaType javaType = srcType.getResolvedType();
            if (javaType == null || javaType.getName().compareTo(iface) != 0 && javaType.getQualifiedName().compareTo(iface) != 0) continue;
            return javaType.getQualifiedName();
        }
        return iface;
    }

    public static void addDefaultConstructor(SourceClass srcClass) {
        if (srcClass.getSourceConstructor(null) == null) {
            SourceFactory factory = srcClass.getOwningSourceFile().getFactory();
            SourceMethod defaultConstructor = factory.createConstructor(null, null, null);
            defaultConstructor.setModifiers(1);
            srcClass.getSourceConstructors().add(defaultConstructor);
        }
    }
}

