/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.dialogs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import oracle.ide.Ide;
import oracle.ide.controls.KeyNavigationManager;
import oracle.ide.controls.WaitCursor;
import oracle.ide.util.SwingWorker;
import oracle.javatools.icons.OracleIcons;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.dialogs.ClassPackageBrowserContext;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageView;
import oracle.jdeveloper.java.JavaManager;
import oracle.jdeveloper.java.filter.ClassNameFilter;
import oracle.jdeveloper.java.filter.PackageNameFilter;
import oracle.jdeveloper.resource.DialogsArb;

public class ClassPackageTreePanel
extends JPanel
implements ClassPackageView {
    JScrollPane pkgScrollPane = new JScrollPane();
    JTree pkgTree = KeyNavigationManager.createNavigableTree();
    DefaultTreeModel pkgModel = new DefaultTreeModel(new DefaultMutableTreeNode("Packages"));
    DefaultTreeCellRenderer renderer = new TreeRenderer();
    GridBagLayout mainLayout = new GridBagLayout();
    TreeSelectionModel selModel = new DefaultTreeSelectionModel();
    private JavaManager _jmgr;
    private int mode = 1;
    private ClassPackageBrowserFilterV2 _filter;
    private boolean _multiSelect;
    private final ClassPackageBrowserContext _browserContext;

    public ClassPackageTreePanel(ClassPackageBrowserContext browseContext, ClassPackageBrowserFilterV2 filter) {
        this._browserContext = browseContext;
        this._filter = filter;
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void activateView() {
        this.enableControls();
    }

    @Override
    public String getTitle() {
        return DialogsArb.getString(19);
    }

    @Override
    public Component getComponent() {
        return this.pkgTree;
    }

    @Override
    public void setSelection(String singleSelection) {
        if (singleSelection != null) {
            String[] multiSelection = new String[]{singleSelection};
            this.setSelectedItems(multiSelection);
        }
    }

    @Override
    public String getSelection() {
        String[] sels = this.getSelectedItems();
        return sels.length > 0 ? sels[0] : null;
    }

    @Override
    public void setSelectedItems(String[] multiSelection) {
        this.setSelectedItemsImpl(multiSelection);
    }

    @Override
    public String[] getSelectedItems() {
        ArrayList<String> resultList = new ArrayList<String>();
        TreePath[] paths = this.pkgTree.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                Object o = paths[i].getLastPathComponent();
                if (o instanceof PackageNode && (this.mode & 1) > 0) {
                    resultList.add(((PackageNode)o).getPackage());
                    continue;
                }
                if (!(o instanceof ClassNode) || (this.mode & 2) <= 0) continue;
                resultList.add(((ClassNode)o).getClassName());
            }
        }
        return resultList.toArray(new String[resultList.size()]);
    }

    @Override
    public void setJavaManager(JavaManager javaManager) {
        this._jmgr = javaManager;
        Collection allPackages = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(allPackages.iterator());
    }

    @Override
    public void setClassAndPackageNameFilters(ClassNameFilter classFilter, PackageNameFilter pkgFilter) {
    }

    @Override
    public void setFilter(ClassPackageBrowserFilterV2 filterV2) {
        this._filter = filterV2;
        Collection allPackages = this._jmgr.getJavaClassLocator().getPackages("");
        this.setPackageList(allPackages.iterator());
    }

    @Override
    public void setMultiSelect(boolean isMultiSelect) {
        if (isMultiSelect != this._multiSelect) {
            this._multiSelect = isMultiSelect;
        }
        this.selModel.setSelectionMode(this._multiSelect ? 4 : 1);
    }

    @Override
    public void setMode(int classPackageMode) {
        this.mode = classPackageMode;
    }

    private void jbInit() throws Exception {
        this.pkgTree.setVisibleRowCount(10);
        this.pkgTree.setRootVisible(false);
        this.pkgTree.setShowsRootHandles(true);
        this.pkgTree.setModel(this.pkgModel);
        this.pkgTree.setCellRenderer(this.renderer);
        TreeAdapter treeListener = new TreeAdapter();
        this.pkgTree.addTreeSelectionListener(treeListener);
        this.pkgTree.addTreeWillExpandListener(treeListener);
        this.pkgTree.addFocusListener(treeListener);
        this.pkgTree.setSelectionModel(this.selModel);
        this.selModel.setSelectionMode(1);
        this.selModel.addTreeSelectionListener(treeListener);
        this.pkgScrollPane.getViewport().add((Component)this.pkgTree, null);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pkgScrollPane, "Center");
    }

    private void setPackageList(Iterator list) {
        MutableTreeNode root = (MutableTreeNode)this.pkgModel.getRoot();
        for (int i = root.getChildCount() - 1; i >= 0; --i) {
            root.remove(i);
        }
        while (list.hasNext()) {
            String pkg = list.next().toString();
            if (pkg == null || !this._filter.acceptPackage(pkg)) continue;
            PackageNode pkgNode = new PackageNode(pkg);
            pkgNode.loadChildren(false);
            if ((this.mode & 1) <= 0 && (this.mode ^ 1) > 0 && pkgNode.children() == DefaultMutableTreeNode.EMPTY_ENUMERATION) continue;
            root.insert(pkgNode, root.getChildCount());
        }
        if ((this.mode & 2) > 0) {
            for (String cname : this._jmgr.getJavaClassLocator().getClassesInPackage("")) {
                JavaClass cls = this._jmgr.getClass(cname);
                if (cls == null || !this._filter.acceptClass(cls)) continue;
                root.insert(new ClassNode(cls), root.getChildCount());
            }
        }
        if (root.getChildCount() == 0) {
            String label = DialogsArb.getString(12);
            root.insert(new DefaultMutableTreeNode(label), 0);
        }
        this.pkgModel.nodeChanged(root);
        this.pkgTree.updateUI();
        this.pkgTree.expandPath(new TreePath(new Object[]{root}));
    }

    private void setSelectedItemsImpl(String[] sel) {
        if (sel == null || sel.length == 0) {
            this.pkgTree.setSelectionRow(0);
        } else {
            String[] cleanSel = new String[sel.length];
            System.arraycopy(sel, 0, cleanSel, 0, sel.length);
            HashSet<String> pathSet = new HashSet<String>();
            for (int i = 0; i < cleanSel.length; ++i) {
                String path = cleanSel[i];
                if (path.endsWith(".*")) {
                    cleanSel[i] = path = path.substring(0, path.length() - 2);
                }
                int idx = path.lastIndexOf(46);
                while (idx != -1) {
                    path = path.substring(0, idx);
                    pathSet.add(path);
                    idx = path.lastIndexOf(46);
                }
            }
            Object[] paths = pathSet.toArray(new String[pathSet.size()]);
            Arrays.sort(paths);
            final MutableTreeNode root = (MutableTreeNode)this.pkgModel.getRoot();
            WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            SwingWorker worker = new SwingWorker((String[])paths, cleanSel, wc){
                final /* synthetic */ String[] val$paths;
                final /* synthetic */ String[] val$cleanSel;
                final /* synthetic */ WaitCursor val$wc;
                {
                    this.val$paths = stringArray;
                    this.val$cleanSel = stringArray2;
                    this.val$wc = waitCursor;
                }

                public Object construct() {
                    HashMap<String, TreePath> pathMap = new HashMap<String, TreePath>();
                    pathMap.put("", new TreePath(root));
                    for (int i = 0; i < this.val$paths.length; ++i) {
                        MutableTreeNode parentNode;
                        TreeNode child;
                        String pkg = this.val$paths[i];
                        int idx = pkg.lastIndexOf(46);
                        String base = idx != -1 ? pkg.substring(0, idx) : "";
                        String rest = pkg.substring(idx + 1);
                        TreePath parent = (TreePath)pathMap.get(base);
                        if (parent == null || !((child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) instanceof PackageNode)) continue;
                        PackageNode pNode = (PackageNode)child;
                        if (!pNode.isChildrenLoaded()) {
                            pNode.loadChildren(false);
                        }
                        TreePath childPath = parent.pathByAddingChild(pNode);
                        pathMap.put(pkg, childPath);
                    }
                    return pathMap;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void finished() {
                    try {
                        Object path;
                        int i;
                        Map pathMap = (Map)this.get();
                        for (i = 0; i < this.val$paths.length; ++i) {
                            path = (TreePath)pathMap.get(this.val$paths[i]);
                            if (path == null) continue;
                            ClassPackageTreePanel.this.pkgTree.expandPath((TreePath)path);
                        }
                        ClassPackageTreePanel.this.selModel.clearSelection();
                        for (i = 0; i < this.val$cleanSel.length; ++i) {
                            MutableTreeNode parentNode;
                            TreeNode child;
                            path = this.val$cleanSel[i];
                            int idx = ((String)path).lastIndexOf(46);
                            String base = idx != -1 ? ((String)path).substring(0, idx) : "";
                            String rest = ((String)path).substring(idx + 1);
                            TreePath parent = (TreePath)pathMap.get(base);
                            if (parent == null || (child = this.getChild(parentNode = (MutableTreeNode)parent.getLastPathComponent(), rest)) == null) continue;
                            TreePath newPath = parent.pathByAddingChild(child);
                            ClassPackageTreePanel.this.selModel.addSelectionPath(newPath);
                            ClassPackageTreePanel.this.pkgTree.scrollPathToVisible(newPath);
                        }
                    }
                    finally {
                        this.val$wc.hide();
                    }
                }

                private TreeNode getChild(MutableTreeNode parentNode, String name) {
                    TreeNode child = null;
                    int childCount = parentNode.getChildCount();
                    for (int i = 0; i < childCount; ++i) {
                        TreeNode node = parentNode.getChildAt(i);
                        if (!name.equals(node.toString())) continue;
                        child = node;
                        break;
                    }
                    return child;
                }
            };
            worker.start();
        }
    }

    private void enableControls() {
        boolean validSelection = false;
        TreePath[] paths = this.selModel.getSelectionPaths();
        if (paths != null) {
            for (int i = 0; !validSelection && i < paths.length; ++i) {
                TreePath path = paths[i];
                if (path == null) continue;
                Object o = path.getLastPathComponent();
                if (o instanceof PackageNode) {
                    validSelection = (this.mode & 1) > 0;
                    continue;
                }
                if (!(o instanceof ClassNode)) continue;
                validSelection = (this.mode & 2) > 0;
            }
        }
        this._browserContext.enableControls(validSelection);
    }

    void pkgTree_treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
        PackageNode node;
        final TreePath path = e.getPath();
        Object o = path.getLastPathComponent();
        if (o instanceof PackageNode && !(node = (PackageNode)o).isChildrenLoaded()) {
            final WaitCursor wc = Ide.getWaitCursor();
            wc.show();
            this.pkgModel.addTreeModelListener(new TreeModelListener(){

                @Override
                public void treeNodesChanged(TreeModelEvent e) {
                }

                @Override
                public void treeNodesInserted(TreeModelEvent e) {
                }

                @Override
                public void treeNodesRemoved(TreeModelEvent e) {
                }

                @Override
                public void treeStructureChanged(TreeModelEvent e) {
                    ClassPackageTreePanel.this.pkgTree.expandPath(path);
                    ClassPackageTreePanel.this.pkgModel.removeTreeModelListener(this);
                    wc.hide();
                }
            });
            node.loadChildren(true);
            throw new ExpandVetoException(e);
        }
    }

    private class TreeAdapter
    implements FocusListener,
    MouseListener,
    TreeSelectionListener,
    TreeWillExpandListener {
        int y;

        private TreeAdapter() {
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (ClassPackageTreePanel.this.pkgTree.getSelectionCount() == 0) {
                ClassPackageTreePanel.this.pkgTree.setSelectionInterval(0, 0);
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void valueChanged(TreeSelectionEvent e) {
            ClassPackageTreePanel.this.enableControls();
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent e) throws ExpandVetoException {
            ClassPackageTreePanel.this.pkgTree_treeWillExpand(e);
        }

        @Override
        public void treeWillCollapse(TreeExpansionEvent e) {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            TreePath path;
            int clicks = e.getClickCount();
            if (clicks == 1) {
                this.y = e.getY();
            }
            if (this.y == e.getY() && clicks == 2 && (path = ((JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && path.getLastPathComponent() instanceof ClassNode) {
                ClassPackageTreePanel.this._browserContext.classPackageSelected();
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }
    }

    private static final class TreeRenderer
    extends DefaultTreeCellRenderer {
        private TreeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (value instanceof PackageNode) {
                if (leaf) {
                    this.setLeafIcon(OracleIcons.getIcon((String)"package.png"));
                }
                if (expanded) {
                    this.setOpenIcon(OracleIcons.getIcon((String)"package.png"));
                } else {
                    this.setClosedIcon(OracleIcons.getIcon((String)"package.png"));
                }
            } else if (value instanceof ClassNode) {
                this.setLeafIcon(((ClassNode)value).isInterface() ? OracleIcons.getIcon((String)"interface.png") : OracleIcons.getIcon((String)"class.png"));
            }
            return super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
        }
    }

    private class ClassNode
    extends DefaultMutableTreeNode {
        private String displayName;
        private JavaClass cls;

        ClassNode(JavaClass cls) {
            super(cls, false);
            this.cls = cls;
            this.displayName = cls.getName();
        }

        @Override
        public String toString() {
            return this.displayName;
        }

        String getClassName() {
            return this.cls.getQualifiedName();
        }

        @Override
        public Object getUserObject() {
            return this.displayName;
        }

        public boolean isInterface() {
            return this.cls.isInterface();
        }
    }

    private class PackageNode
    extends DefaultMutableTreeNode {
        String displayName;
        String pkgName;
        boolean childrenFetched;
        boolean isSelectable;
        boolean loading;

        PackageNode(String pkgName) {
            this.pkgName = pkgName;
            int idx = pkgName.lastIndexOf(".");
            this.displayName = idx != -1 ? pkgName.substring(idx + 1) : pkgName;
            this.isSelectable = true;
        }

        Icon getIcon() {
            return null;
        }

        @Override
        public String toString() {
            return this.displayName;
        }

        public String getPackage() {
            return this.pkgName;
        }

        boolean isSelectable() {
            return this.isSelectable;
        }

        void setSelectable(boolean isSelectable) {
            this.isSelectable = isSelectable;
        }

        boolean isChildrenLoaded() {
            return this.childrenFetched;
        }

        void setChildrenLoaded(boolean childrenFetched) {
            this.childrenFetched = childrenFetched;
        }

        @Override
        public boolean isLeaf() {
            return !this.childrenFetched ? false : super.isLeaf();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void loadChildren(boolean useWorker) {
            if (this.loading) {
                return;
            }
            this.loading = true;
            if (useWorker) {
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        return PackageNode.this._loadChildList();
                    }

                    public void finished() {
                        PackageNode.this._finishChildLoad(this.get());
                    }
                };
                worker.start();
            } else {
                ArrayList children = null;
                try {
                    children = this._loadChildList();
                }
                finally {
                    this._finishChildLoad(children);
                }
            }
        }

        private ArrayList _loadChildList() {
            ArrayList<DefaultMutableTreeNode> nodes;
            block5: {
                nodes = new ArrayList<DefaultMutableTreeNode>();
                try {
                    Iterator iter = ClassPackageTreePanel.this._jmgr.getJavaClassLocator().getPackages(this.pkgName).iterator();
                    while (iter.hasNext()) {
                        String childPackage = this.pkgName.length() == 0 ? (String)iter.next() : this.pkgName + '.' + iter.next();
                        if (childPackage == null || !ClassPackageTreePanel.this._filter.acceptPackage(childPackage)) continue;
                        nodes.add(new PackageNode(childPackage));
                    }
                    if ((ClassPackageTreePanel.this.mode & 2) > 0) {
                        iter = ClassPackageTreePanel.this._jmgr.getJavaClassLocator().getClassesInPackage(this.pkgName).iterator();
                        while (iter.hasNext()) {
                            String cname = this.pkgName.length() == 0 ? (String)iter.next() : this.pkgName + '.' + iter.next();
                            JavaClass cls = ClassPackageTreePanel.this._jmgr.getClass(cname);
                            if (cls == null || !ClassPackageTreePanel.this._filter.acceptClass(cls)) continue;
                            nodes.add(new ClassNode(cls));
                        }
                    }
                }
                catch (Throwable t) {
                    if (!(t instanceof ThreadDeath)) break block5;
                    throw (ThreadDeath)t;
                }
            }
            return nodes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _finishChildLoad(Object obj) {
            try {
                if (obj instanceof ArrayList) {
                    ArrayList result = (ArrayList)obj;
                    Iterator iter = result.iterator();
                    while (iter.hasNext()) {
                        this.add((MutableTreeNode)iter.next());
                    }
                }
            }
            finally {
                this.childrenFetched = true;
                TreePath[] sel = ClassPackageTreePanel.this.selModel.getSelectionPaths();
                ClassPackageTreePanel.this.pkgModel.reload(this);
                ClassPackageTreePanel.this.selModel.setSelectionPaths(sel);
            }
        }

        @Override
        public Object getUserObject() {
            return this.displayName;
        }
    }
}

