/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.res;

import java.text.DateFormat;
import java.util.Calendar;
import oracle.jdeveloper.deploy.res.DeployArb;

public class DeployMessages {
    public static String deploymentStarted() {
        return DeployArb.getString(64);
    }

    public static String deploymentFinished() {
        return DeployArb.getString(66);
    }

    public static String deploymentIncomplete() {
        return DeployArb.getString(68);
    }

    public static String deploymentElapsed(long milliseconds) {
        long seconds = (milliseconds + 500L) / 1000L;
        if (seconds == 0L) {
            String fastText = DeployArb.getString(88);
            return DeployArb.format(79, fastText);
        }
        long minutes = seconds / 60L;
        seconds -= minutes * 60L;
        long hours = minutes / 60L;
        String secondsText = DeployArb.format(seconds == 1L ? 85 : 84, Long.toString(seconds));
        String minutesText = "";
        if ((minutes -= hours * 60L) > 0L) {
            minutesText = DeployArb.format(minutes == 1L ? 83 : 82, Long.toString(minutes));
        }
        String hoursText = "";
        if (hours > 0L) {
            hoursText = DeployArb.format(hours == 1L ? 81 : 80, Long.toString(hours));
        }
        String elapsedText = secondsText;
        if (hoursText.length() > 0) {
            elapsedText = DeployArb.format(87, hoursText, minutesText, secondsText);
        } else if (minutesText.length() > 0) {
            elapsedText = DeployArb.format(86, minutesText, secondsText);
        }
        return DeployArb.format(79, elapsedText);
    }

    public static String currentDateTime() {
        return DateFormat.getDateTimeInstance().format(Calendar.getInstance().getTime());
    }
}

