/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.meta.pattern.builder;

import java.util.List;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBBuilder;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBFramework;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBListener;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBRecognizer;
import oracle.jdeveloper.deploy.meta.pattern.builder.OBSpiRecognizer;

public abstract class OBContext<R, O, C> {
    final C context_;
    final OBContext parent_;
    final OBFramework<R, O, C> mainRecognizer_;
    private final int rSize_;
    OBSpiRecognizer<R, O, C> spiRecognizer_ = null;
    final List<OBRecognizer<R, O, C>> recognizers_;
    List<OBListener> generalListeners_ = null;

    public OBContext(OBFramework<R, O, C> mainProfiler, C context, List<OBRecognizer<R, O, C>> recognizers, int rSize, OBContext parent) {
        this.context_ = context;
        this.mainRecognizer_ = mainProfiler;
        this.parent_ = parent;
        this.recognizers_ = recognizers;
        this.rSize_ = rSize;
        this.spiRecognizer_ = this.newSpiRecognizer(this);
    }

    List<OBRecognizer<R, O, C>> recognizers() {
        return this.recognizers_;
    }

    int recognizersSize() {
        return this.rSize_;
    }

    public C getContext() {
        return this.context_;
    }

    OBContext<R, O, C> newOBContext(C context, int rSize) {
        return this.newOBContext(this.mainRecognizer_, context, this.recognizers_, rSize, this);
    }

    protected abstract OBContext<R, O, C> newOBContext(OBFramework<R, O, C> var1, C var2, List<OBRecognizer<R, O, C>> var3, int var4, OBContext<R, O, C> var5);

    public synchronized OBSpiRecognizer<R, O, C> getSpiRecognizer() {
        if (this.spiRecognizer_ == null) {
            this.spiRecognizer_ = this.newSpiRecognizer(this);
        }
        return this.spiRecognizer_;
    }

    protected abstract OBSpiRecognizer<R, O, C> newSpiRecognizer(OBContext<R, O, C> var1);

    public void firePreBuildEvent(Class<O> objectClass, OBBuilder<R, O, C> builder) {
        for (OBListener l : this.getGeneralListeners(objectClass)) {
            l.preBuild(objectClass, builder);
        }
    }

    public void firePostBuildEvent(O object, OBBuilder<R, O, C> builder) {
        for (OBListener l : this.getGeneralListeners(object.getClass())) {
            l.postBuild(object, builder);
        }
    }

    private synchronized List<OBListener> getGeneralListeners(Class pc) {
        if (this.generalListeners_ == null) {
            this.generalListeners_ = this.mainRecognizer_.getBuildListeners(pc);
        }
        return this.generalListeners_;
    }
}

