/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.jar;

import java.io.IOException;
import java.io.PrintWriter;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.util.ModelUtil;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.DeploymentModule;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.common.FileGroupPackager;
import oracle.jdeveloper.deploy.common.ModuleContext;
import oracle.jdeveloper.deploy.common.NodeDependable;
import oracle.jdeveloper.deploy.common.ProfileDependable;
import oracle.jdeveloper.deploy.jar.ArchiveOptions;
import oracle.jdeveloper.deploy.jar.ArchiveProfile;
import oracle.jdevimpl.deploy.common.ProfileDeployer;
import oracle.jdevimpl.deploy.fwk.JarUtil;
import oracle.jdevimpl.deploy.res.JarArb;

public class ArchiveDeployer
extends ProfileDeployer {
    protected final ArchiveProfile _profile;
    protected DeploymentModule _depMod = null;

    public ArchiveDeployer(int deploySequence, DeployShell shell) {
        super(deploySequence, shell);
        this._profile = (ArchiveProfile)DeployUtil.getProfile(shell);
    }

    @Override
    public void prepareImpl(int deploySequence, DeployShell dsh) throws DeployException {
        ArchiveProfile profile = this.getProfile();
        DeploymentModuleFactory factory = dsh.getDeploymentModuleFactory();
        this._depMod = factory.create(profile.getClass(), ModuleContext.newInstance(dsh, null, profile.getArchiveOptions()));
        this.setDeploymentModule(this._depMod, dsh);
        this.addInitialContentSet(profile, this._depMod, dsh);
        this.maybeSetManifestClassPath(this._depMod, this.getProfile(), dsh);
        this._depMod.setModuleId(profile.getName());
    }

    protected void addInitialContentSet(ArchiveProfile profile, DeploymentModule archive, DeployShell dsh) throws DeployException {
        FileGroupPackager.newInstance(profile.getFileGroups(), profile.getDataContainer(), profile, archive).process();
    }

    @Override
    public void deployImpl(int deploySequence, DeployShell dsh) throws DeployException {
        URL targetURL = this.getTargetURL(dsh);
        try {
            this._depMod.setURL(targetURL);
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
        this._depMod.commit();
        this.logFileWritten(dsh.getLogger(), targetURL);
    }

    @Override
    public void finishImpl(int deploySequence, DeployShell dsh) {
        this.release(this._depMod);
    }

    @Override
    public void cancelImpl(int deploySequence, DeployShell dsh) {
        this.release(this._depMod);
    }

    protected URL getTargetURL(DeployShell dsh) throws DeployException {
        URL targetURL = this._profile.getJarURL();
        if (targetURL == null) {
            dsh.getLog().println(JarArb.getString(24));
            throw new DeployException(JarArb.getString(24));
        }
        return targetURL;
    }

    @Deprecated
    public JarUtil getJarUtil() {
        return null;
    }

    @Deprecated
    public DefaultArchive getArchive() {
        return this._depMod;
    }

    @Deprecated
    protected void setJarUtil(JarUtil jarUtil) {
    }

    public DeploymentModule getDeploymentModule(DeployShell shell) {
        return DeployUtil.getDeploymentModule(shell, this.getProfile());
    }

    public void setDeploymentModule(DeploymentModule module, DeployShell shell) {
        DeployUtil.setDeploymentModule(shell, this.getProfile(), module);
    }

    @Override
    protected ArchiveProfile getProfile() {
        return this._profile;
    }

    @Deprecated
    protected void logFileWritten(PrintWriter log, String jarPath) {
        log.println(JarArb.format(28, jarPath));
    }

    protected void logFileWritten(Logger logger, URL jarURL) {
        logger.log(Level.INFO, JarArb.getString(28), jarURL);
    }

    @Deprecated
    protected void logFileUpToDate(PrintWriter log, String jarPath) {
        log.println(JarArb.format(31, jarPath));
    }

    protected void setDeploymentModuleURL(URL url, DeployShell shell) throws DeployException {
        try {
            this.getDeploymentModule(shell).setURL(url);
        }
        catch (IOException e) {
            throw new DeployException(e);
        }
    }

    protected void maybeSetManifestClassPath(DeploymentModule archive, ArchiveProfile profile, DeployShell dsh) {
        ArchiveEntry ae;
        ProfileDependable[] profileDependables;
        if (!dsh.findFlag("isAssembly")) {
            return;
        }
        if (profile.getLibraryDependencies().isIncludeLibrariesFromOtherContainers()) {
            return;
        }
        NodeDependable[] jarDependables = DeployUtil.getAllJarDependables(profile);
        if (jarDependables.length + (profileDependables = DeployUtil.getProfileDependables(profile, ArchiveProfile.class)).length == 0) {
            return;
        }
        ArchiveOptions options = (ArchiveOptions)profile.getArchiveOptions().copyTo(null);
        options.setHasManifest(true);
        StringBuffer cp = new StringBuffer();
        for (NodeDependable nodeDep : jarDependables) {
            ae = DeployUtil.createArchiveEntry(nodeDep, (String)null);
            cp.append(ae.getName()).append(" ");
        }
        for (ProfileDependable profileDep : profileDependables) {
            ae = DeployUtil.createArchiveEntry(profileDep, (String)null);
            cp.append(ae.getName()).append(" ");
        }
        int cpLen = cp.length();
        if (cpLen > 0) {
            cp.setLength(cpLen - 1);
            String curCp = archive.getMainAttribute("Class-Path");
            String cpStr = cp.toString();
            String wholeCp = ModelUtil.hasLength((String)curCp) ? curCp + " " + cpStr : cpStr;
            archive.setMainAttribute("Class-Path", wholeCp);
        }
    }

    protected void release(DeploymentModule depMod) {
        if (depMod == null) {
            return;
        }
        try {
            depMod.release();
        }
        catch (DeployException e) {
            e.printStackTrace();
        }
    }
}

