/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt.wizard.spi;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import oracle.ide.Ide;
import oracle.ide.model.Element;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployAction;
import oracle.jdeveloper.deploy.dt.wizard.spi.DeployActionsToolkit;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitBuilder;
import oracle.jdeveloper.deploy.tk.spi.AbstractToolkitProvider;
import oracle.jdeveloper.deploy.tk.spi.ToolkitContext;

public abstract class AbstractDeployActionProvider
extends AbstractToolkitProvider {
    public AbstractDeployActionProvider() {
        this((Class<? extends DeployActionsToolkit>)DeployActionsToolkit.class);
    }

    public AbstractDeployActionProvider(Class<? extends DeployActionsToolkit> clazz) {
        super(clazz);
    }

    @Override
    public AbstractToolkitBuilder create(final Element element, final ToolkitContext context, final Class classOrIntf) {
        if (!this.shouldCreateFor(element, context, classOrIntf)) {
            return null;
        }
        AbstractToolkitBuilder[] builders = context.getSpiToolkitRegistry().createBuilder(element, classOrIntf);
        final AbstractToolkitBuilder[] delegates = context.getSpiToolkitRegistry().narrow(builders);
        AbstractToolkitBuilder tkBuilder = new AbstractToolkitBuilder(this, context){

            @Override
            protected DeployActionsToolkit build() {
                DeployActionsToolkitImpl tk = new DeployActionsToolkitImpl();
                this.consolidateActions(tk, delegates);
                AbstractDeployActionProvider.this.updateActions(tk, element, context, classOrIntf);
                return tk;
            }

            private void consolidateActions(DeployActionsToolkit newTk, AbstractToolkitBuilder[] delegates2) {
                for (int i = 0; i < delegates2.length; ++i) {
                    DeployActionsToolkit tkn = (DeployActionsToolkit)delegates2[i].getToolkit();
                    for (String cmdName : tkn.getAllActions().keySet()) {
                        if (newTk.containsAction(cmdName)) continue;
                        DeployAction action = tkn.getAction(cmdName);
                        Object[] trans = tkn.getTransitions(cmdName);
                        newTk.putAction(cmdName, action, trans);
                    }
                }
            }

            @Override
            public Class getTypeForNarrow() {
                return AbstractDeployActionProvider.this.getTypeForNarrow(element, context, classOrIntf);
            }
        };
        return tkBuilder;
    }

    protected abstract void updateActions(DeployActionsToolkit var1, Element var2, ToolkitContext var3, Class var4);

    protected abstract boolean shouldCreateFor(Element var1, ToolkitContext var2, Class var3);

    protected Class getTypeForNarrow(Element element, ToolkitContext context, Class classOrIntf) {
        return element.getClass();
    }

    protected static class DeployActionsToolkitImpl
    implements DeployActionsToolkit {
        LinkedHashMap<String, DeployAction> cmds_ = new LinkedHashMap();
        HashMap<String, Object[]> transitions_ = new HashMap();

        protected DeployActionsToolkitImpl() {
        }

        @Override
        public DeployAction getAction(String cmdName) {
            return this.cmds_.get(cmdName);
        }

        @Override
        public DeployAction putAction(String cmdName, DeployAction action) {
            assert (cmdName.equals(Ide.findCmdName((int)action.getDeployCommand().getId())));
            return this.putAction(cmdName, action, new Object[]{cmdName});
        }

        @Override
        public boolean containsAction(String cmdName) {
            return this.cmds_.containsKey(cmdName);
        }

        @Override
        public Map<String, DeployAction> getAllActions() {
            return Collections.unmodifiableMap(this.cmds_);
        }

        @Override
        public DeployAction putAction(String cmdName, DeployAction action, Object[] transitions) {
            this.transitions_.put(cmdName, transitions);
            return this.cmds_.put(cmdName, action);
        }

        @Override
        public Object[] getTransitions(String cmdName) {
            Object[] arr = this.transitions_.get(cmdName);
            return arr == null ? new Object[]{} : arr;
        }
    }
}

