/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.io.File;
import java.net.URL;
import oracle.ide.model.DefaultDirtyable;
import oracle.javatools.util.Copyable;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeployShell;

public class DeploymentOptions
extends DefaultDirtyable
implements Copyable {
    public static final String DATA_KEY = "deployment-options";
    private boolean _compactJavaScript;
    private boolean _compileBeforeDeploy;
    private boolean _cleanBeforeCompile;
    private boolean _followDependencies;
    private File _oc4jHome;
    private boolean _autoUpdateWebXmlEjbRefs;
    private String _appRelativeOutputFolder;
    private URL _appAbsoluteOutputURL;
    private String _deployOutputFolder;
    private URL _deployOutputURL;
    private boolean _forceJarRewrite;
    private Integer _defaultDeployHeapSize;
    private boolean _includeDataSources;
    private boolean _autoGenerateMar;
    private boolean _accessInternalOC4JClasses;

    public DeploymentOptions() {
        this.setFollowDependencies(true);
        this.setCompileBeforeDeploy(true);
        this.setCleanBeforeCompile(false);
        this.setAutoUpdateWebXmlEjbRefs(true);
        this.setApplicationRelativeOutputFolder("deploy");
        this.setDeployOutputFolder("deploy");
        this.setIncludeDataSources(true);
        this.setAutoGenerateMar(true);
        this.setAccessInternalOC4JClasses(false);
    }

    public Object copyTo(Object target) {
        DeploymentOptions copy = target != null ? (DeploymentOptions)((Object)target) : new DeploymentOptions();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(DeploymentOptions copy) {
        copy._compactJavaScript = this._compactJavaScript;
        copy._compileBeforeDeploy = this._compileBeforeDeploy;
        copy._cleanBeforeCompile = this._cleanBeforeCompile;
        copy._followDependencies = this._followDependencies;
        copy._oc4jHome = this._oc4jHome;
        copy._autoUpdateWebXmlEjbRefs = this._autoUpdateWebXmlEjbRefs;
        copy._appRelativeOutputFolder = this._appRelativeOutputFolder;
        copy._appAbsoluteOutputURL = this._appAbsoluteOutputURL;
        copy._deployOutputFolder = this._deployOutputFolder;
        copy._deployOutputURL = this._deployOutputURL;
        copy._forceJarRewrite = this._forceJarRewrite;
        copy._defaultDeployHeapSize = this._defaultDeployHeapSize;
        copy._includeDataSources = this._includeDataSources;
        copy._autoGenerateMar = this._autoGenerateMar;
        copy._accessInternalOC4JClasses = this._accessInternalOC4JClasses;
    }

    public boolean isCompactJavaScript() {
        return this._compactJavaScript;
    }

    public void setCompactJavaScript(boolean compactJavaScript) {
        if (this._compactJavaScript != compactJavaScript) {
            this._compactJavaScript = compactJavaScript;
            this.markDirty(true);
        }
    }

    public boolean isCompileBeforeDeploy() {
        return this._compileBeforeDeploy;
    }

    public boolean isCleanBeforeCompile() {
        return this._cleanBeforeCompile;
    }

    public void setCompileBeforeDeploy(boolean compileBeforeDeploy) {
        if (this._compileBeforeDeploy != compileBeforeDeploy) {
            this._compileBeforeDeploy = compileBeforeDeploy;
            this.markDirty(true);
        }
    }

    public void setCleanBeforeCompile(boolean clean) {
        if (clean != this._cleanBeforeCompile) {
            this._cleanBeforeCompile = clean;
            this.markDirty(true);
        }
    }

    public boolean isFollowDependencies() {
        return this._followDependencies;
    }

    public void setFollowDependencies(boolean follow) {
        this._followDependencies = follow;
    }

    public File getOc4jHome() {
        return this._oc4jHome;
    }

    public void setOc4jHome(File oc4jHome) {
        if (ModelUtil.areDifferent((Object)this._oc4jHome, (Object)oc4jHome)) {
            this._oc4jHome = oc4jHome;
            this.markDirty(true);
        }
    }

    public boolean isAutoUpdateWebXmlEjbRefs() {
        return this._autoUpdateWebXmlEjbRefs;
    }

    public void setAutoUpdateWebXmlEjbRefs(boolean autoUpdateWebXmlEjbRefs) {
        if (this._autoUpdateWebXmlEjbRefs != autoUpdateWebXmlEjbRefs) {
            this._autoUpdateWebXmlEjbRefs = autoUpdateWebXmlEjbRefs;
            this.markDirty(true);
        }
    }

    public String getApplicationRelativeOutputFolder() {
        return this._appRelativeOutputFolder;
    }

    public void setApplicationRelativeOutputFolder(String appRelativeOutputFolder) {
        if (ModelUtil.areDifferent((Object)this._appRelativeOutputFolder, (Object)appRelativeOutputFolder)) {
            this._appRelativeOutputFolder = appRelativeOutputFolder;
            this._appAbsoluteOutputURL = null;
            this.markDirty(true);
        }
    }

    public URL getApplicationAbsoluteOutputURL() {
        return this._appAbsoluteOutputURL;
    }

    public void setApplicationAbsoluteOutputURL(URL appAbsoluteOutputURL) {
        if (ModelUtil.areDifferent((Object)this._appAbsoluteOutputURL, (Object)appAbsoluteOutputURL)) {
            this._appAbsoluteOutputURL = appAbsoluteOutputURL;
            this._appRelativeOutputFolder = null;
            this.markDirty(true);
        }
    }

    public String getDeployOutputFolder() {
        return this._deployOutputFolder;
    }

    public void setDeployOutputFolder(String deployOutputFolder) {
        if (ModelUtil.areDifferent((Object)this._deployOutputFolder, (Object)deployOutputFolder)) {
            this._deployOutputFolder = deployOutputFolder;
            this._deployOutputURL = null;
            this.markDirty(true);
        }
    }

    public URL getDeployOutputURL() {
        return this._deployOutputURL;
    }

    public void setDeployOutputURL(URL deployOutputURL) {
        if (ModelUtil.areDifferent((Object)this._deployOutputURL, (Object)deployOutputURL)) {
            this._deployOutputURL = deployOutputURL;
            this._deployOutputFolder = null;
            this.markDirty(true);
        }
    }

    public boolean isForceJarRewrite() {
        return this._forceJarRewrite;
    }

    public void setForceJarRewrite(boolean forceJarRewrite) {
        if (this._forceJarRewrite != forceJarRewrite) {
            this._forceJarRewrite = forceJarRewrite;
            this.markDirty(true);
        }
    }

    public Integer getDefaultDeployHeapSize() {
        return this._defaultDeployHeapSize;
    }

    public void setDefaultDeployHeapSize(Integer defaultDeployHeapSize) {
        if (ModelUtil.areDifferent((Object)this._defaultDeployHeapSize, (Object)defaultDeployHeapSize)) {
            this._defaultDeployHeapSize = defaultDeployHeapSize;
            this.markDirty(true);
        }
    }

    public boolean isIncludeDataSources() {
        return this._includeDataSources;
    }

    public void setIncludeDataSources(boolean includeDataSources) {
        if (this._includeDataSources != includeDataSources) {
            this._includeDataSources = includeDataSources;
            this.markDirty(true);
        }
    }

    public boolean isAutoGenerateMar() {
        return this._autoGenerateMar;
    }

    public void setAutoGenerateMar(boolean autoGenerateMar) {
        if (this._autoGenerateMar != autoGenerateMar) {
            this._autoGenerateMar = autoGenerateMar;
            this.markDirty(true);
        }
    }

    public boolean isAccessInternalOC4JClasses() {
        return this._accessInternalOC4JClasses;
    }

    public void setAccessInternalOC4JClasses(boolean accessInternalOC4JClasses) {
        if (this._accessInternalOC4JClasses != accessInternalOC4JClasses) {
            this._accessInternalOC4JClasses = accessInternalOC4JClasses;
            this.markDirty(true);
        }
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        return this.equalsImpl((DeploymentOptions)((Object)o));
    }

    protected final boolean equalsImpl(DeploymentOptions opt) {
        return this._compactJavaScript == opt._compactJavaScript && this._compileBeforeDeploy == opt._compileBeforeDeploy && this._cleanBeforeCompile == opt._cleanBeforeCompile && ModelUtil.areEqual((Object)this._oc4jHome, (Object)opt._oc4jHome) && this._autoUpdateWebXmlEjbRefs == opt._autoUpdateWebXmlEjbRefs && ModelUtil.areEqual((Object)this._appRelativeOutputFolder, (Object)opt._appRelativeOutputFolder) && ModelUtil.areEqual((Object)this._appAbsoluteOutputURL, (Object)opt._appAbsoluteOutputURL) && ModelUtil.areEqual((Object)this._deployOutputFolder, (Object)opt._deployOutputFolder) && ModelUtil.areEqual((Object)this._deployOutputURL, (Object)opt._deployOutputURL) && this._forceJarRewrite == opt._forceJarRewrite && ModelUtil.areEqual((Object)this._defaultDeployHeapSize, (Object)opt._defaultDeployHeapSize) && this._includeDataSources == opt._includeDataSources && this._autoGenerateMar == opt._autoGenerateMar && this._accessInternalOC4JClasses == opt._accessInternalOC4JClasses;
    }

    public void scatter(DeployShell shell) {
        if (this._compileBeforeDeploy) {
            shell.put("isCompileBeforeDeploy", Boolean.TRUE);
        }
        if (this._cleanBeforeCompile) {
            shell.put("isCleanBeforeCompile", Boolean.TRUE);
        }
        if (!this._followDependencies) {
            shell.put("ignoreDependencies", Boolean.TRUE);
        }
    }
}

