/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.dt;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.ide.controls.DescriptionScrollPane;
import oracle.ide.panels.DefaultTraversablePanel;
import oracle.ide.panels.TraversableContext;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.ResourceUtils;
import oracle.javatools.ui.Colors;
import oracle.jdeveloper.deploy.dt.DeployProfileDt;
import oracle.jdeveloper.deploy.dt.DeploymentProfiles;
import oracle.jdevimpl.deploy.res.DtArb;

final class CreateProfilePanel
extends DefaultTraversablePanel {
    private final JTextField tfProfileName = new JTextField();
    private Set usedNames = null;
    private DescriptionScrollPane descrScrollPane = new DescriptionScrollPane();

    CreateProfilePanel() {
        Dimension dim = new Dimension(500, 180);
        this.setPreferredSize(dim);
        JLabel profileDescr = new JLabel();
        profileDescr.setText(DtArb.getString(7));
        JLabel lblProfileName = new JLabel();
        ResourceUtils.resLabel((JLabel)lblProfileName, (Component)this.tfProfileName, (String)DtArb.getString(0));
        Dimension prefSize = this.tfProfileName.getPreferredSize();
        prefSize.width = 500;
        this.tfProfileName.setPreferredSize(prefSize);
        JButton btnBrowse = new JButton();
        ResourceUtils.resButton((AbstractButton)btnBrowse, (String)DtArb.getString(2));
        JLabel descrLabel = new JLabel();
        ResourceUtils.resLabel((JLabel)descrLabel, (Component)this.descrScrollPane.getLabelComponent(), (String)DtArb.getString(133));
        this.setLayout(new GridBagLayout());
        Insets in0550 = new Insets(0, 5, 5, 0);
        this.add(profileDescr, this.gbc(0, 0, 2, 1, 0.0, 0.0, 17, 0, new Insets(0, 5, 10, 0)));
        this.add(lblProfileName, this.gbc(0, 1, 2, 1, 0.0, 0.0, 17, 0, in0550));
        this.add(this.tfProfileName, this.gbc(0, 2, 2, 1, 1.0, 0.0, 17, 2, in0550));
        this.add(descrLabel, this.gbc(0, 3, 2, 1, 0.0, 0.0, 17, 0, in0550));
        this.add((Component)this.descrScrollPane, this.gbc(0, 4, 0, 0, 1.0, 1.0, 17, 1, in0550));
        this.setHelpID("f1_depsavedepprof_html");
    }

    public void onEntry(TraversableContext tc) {
        this.usedNames = (Set)tc.find("usedNames");
        String name = (String)tc.find("defaultProfileName");
        DeployProfileDt profileDt = (DeployProfileDt)tc.find("profileDt");
        this.descrScrollPane.setText(profileDt.getLongLabel());
        this.descrScrollPane.setForeground(Colors.HINT_TEXT);
        this.tfProfileName.setText(name);
    }

    public void onExit(TraversableContext tc) throws TraversalException {
        String name = this.tfProfileName.getText();
        try {
            DeploymentProfiles.validateProfileName(this.usedNames, name, "");
        }
        catch (TraversalException te) {
            this.tfProfileName.requestFocus();
            throw new TraversalException(te.getMessage());
        }
        tc.findAndReplace("profileName", (Object)this.tfProfileName.getText());
    }
}

