/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public final class SelectedProjectFiles
extends DefaultLinkedDirtyable
implements Copyable {
    public static final int AS_COMPILED_OUTPUT_ONLY = 0;
    public static final int AS_SOURCE_FILES_ONLY = 1;
    public static final int AS_BOTH_COMPILED_OUTPUT_AND_SOURCE_FILES = 2;
    private HashStructure _hash;

    public SelectedProjectFiles() {
        this(HashStructure.newInstance());
        this.setAutoInclude(true);
    }

    public SelectedProjectFiles(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object object) {
        SelectedProjectFiles copy = object != null ? (SelectedProjectFiles)object : new SelectedProjectFiles();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(SelectedProjectFiles copy) {
        this._hash.copyTo(copy._hash);
    }

    public boolean isAutoInclude() {
        return this._hash.getBoolean("autoInclude");
    }

    public void setAutoInclude(boolean b) {
        if (this.isAutoInclude() != b) {
            this._hash.putBoolean("autoInclude", b);
            this.markDirty(true);
        }
    }

    public URL[] getFiles() {
        ListStructure list = this._hash.getListStructure("files");
        if (list == null) {
            return null;
        }
        return (URL[])list.toArray((Object[])new URL[list.size()]);
    }

    public void setFiles(URL[] files) {
        if (!Arrays.equals(this.getFiles(), files)) {
            ListStructure list = this._hash.getOrCreateListStructure("files");
            list.clear();
            list.addAll(Arrays.asList(files));
            this.markDirty(true);
        }
    }

    public Class[] getSelectionFilters() {
        ListStructure list = this._hash.getListStructure("selectionFilters");
        if (list == null) {
            return null;
        }
        int n = list.size();
        Class[] selectionFilters = new Class[n];
        for (int i = 0; i < n; ++i) {
            String className = (String)list.get(i);
            if (className == null) {
                selectionFilters[i] = null;
                continue;
            }
            try {
                selectionFilters[i] = Class.forName(className);
                continue;
            }
            catch (ClassNotFoundException ce) {
                selectionFilters[i] = null;
            }
        }
        return selectionFilters;
    }

    public void setSelectionFilters(Class[] selectionFilters) {
        if (!Arrays.equals(this.getSelectionFilters(), selectionFilters)) {
            this.setSelectionFiltersImpl(selectionFilters);
            this.markDirty(true);
        }
    }

    private void setSelectionFiltersImpl(Class[] selectionFilters) {
        this._hash.remove("selectionFilters");
        if (selectionFilters != null) {
            ListStructure list = this._hash.getOrCreateListStructure("selectionFilters");
            for (int i = 0; i < selectionFilters.length; ++i) {
                Class selectionFilter = selectionFilters[i];
                if (selectionFilter != null) {
                    list.add((Object)selectionFilter.getName());
                    continue;
                }
                list.add((Object)null);
            }
            if (list.size() != 0) {
                this._hash.putListStructure("selectionFilters", list);
            } else {
                this._hash.remove("selectionFilters");
            }
        }
    }

    public int getDeploySourceAs() {
        return this._hash.getInt("deploySourceAs");
    }

    public void setDeploySourceAs(int deploySourceAs) {
        if (deploySourceAs < 0 || deploySourceAs > 2) {
            throw new IllegalArgumentException();
        }
        if (this.getDeploySourceAs() != deploySourceAs) {
            this._hash.putInt("deploySourceAs", deploySourceAs);
            this.markDirty(true);
        }
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((SelectedProjectFiles)o);
    }

    protected final boolean equalsImpl(SelectedProjectFiles spf) {
        return this._hash.equals((Object)spf._hash);
    }
}

