/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.util.Arrays;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;

public class LibraryDependencies
extends DefaultLinkedDirtyable
implements Copyable {
    private static String UNSELECTED_LIBRARIES = "unselectedLibraries";
    private static String INCLUDE_FROM_OTHER_CONTAINERS = "IncludeLibrariesFromOtherContainers";
    private HashStructure _hash;

    public LibraryDependencies() {
        this(HashStructure.newInstance());
    }

    public LibraryDependencies(HashStructure hash) {
        this._hash = hash;
    }

    public Object copyTo(Object object) {
        LibraryDependencies copy = object != null ? (LibraryDependencies)object : new LibraryDependencies();
        this.copyToImpl(copy);
        return copy;
    }

    protected final void copyToImpl(LibraryDependencies copy) {
        this._hash.copyTo(copy._hash);
    }

    public Object[] getUnselectedLibraryNames() {
        ListStructure list = this._hash.getListStructure(UNSELECTED_LIBRARIES);
        if (list == null) {
            return null;
        }
        return list.toArray();
    }

    public void setUnselectedLibraryNames(Object[] unselectedLibraryNames) {
        if (!Arrays.equals(this.getUnselectedLibraryNames(), unselectedLibraryNames)) {
            ListStructure list = this._hash.getOrCreateListStructure(UNSELECTED_LIBRARIES);
            list.clear();
            list.addAll(Arrays.asList(unselectedLibraryNames));
            this.markDirty(true);
        }
    }

    public boolean isIncludeLibrariesFromOtherContainers() {
        return this._hash.getBoolean(INCLUDE_FROM_OTHER_CONTAINERS);
    }

    public void setIncludeLibrariesFromOtherContainers(boolean includeFromOtherContainers) {
        this._hash.putBoolean(INCLUDE_FROM_OTHER_CONTAINERS, includeFromOtherContainers);
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((LibraryDependencies)o);
    }

    protected final boolean equalsImpl(LibraryDependencies ld) {
        return this._hash.equals((Object)ld._hash);
    }
}

