/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Element;
import oracle.ide.model.Project;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.ModelUtil;
import oracle.ide.util.TriStateBoolean;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.DefaultArchive;
import oracle.jdeveloper.deploy.common.CdaSettings;
import oracle.jdeveloper.deploy.common.ContribPathFilter;
import oracle.jdeveloper.deploy.common.FileGroup;
import oracle.jdeveloper.deploy.common.FileGroups;
import oracle.jdeveloper.deploy.common.LibraryFileGroup;
import oracle.jdeveloper.deploy.common.PackagingFileGroup;
import oracle.jdeveloper.deploy.common.ProjectFileGroup;
import oracle.jdeveloper.deploy.common.SelectedProjectFiles;
import oracle.jdeveloper.deploy.common.SelectionRule;
import oracle.jdeveloper.deploy.common.SelectionRules;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.CdaPacketFactory;
import oracle.jdevimpl.deploy.common.FileGroupsEditor;
import oracle.jdevimpl.deploy.common.SelectedProjectFilesDt;
import oracle.jdevimpl.deploy.res.CommonArb;

public class FileGroupPackager {
    protected ArrayList<String> messages_ = new ArrayList();
    protected Archive archive_ = null;
    protected FileGroups fileGroups_;
    protected DataContainer container_;
    protected ContribPathFilter contribPathFilter_;
    protected Element libraryElement_;

    protected FileGroupPackager(FileGroups fileGroups, DataContainer container, Element libraryElement, Archive archive) {
        this.libraryElement_ = libraryElement;
        this.fileGroups_ = fileGroups;
        this.container_ = container;
        this.archive_ = archive;
    }

    public static FileGroupPackager newInstance(FileGroups groups, DataContainer container, Element libraryElement, Archive archive) {
        return new FileGroupPackager(groups, container, libraryElement, archive);
    }

    public void process() {
        FileGroup[] groups;
        if (this.archive_ == null) {
            this.archive_ = DefaultArchive.create(false, false);
        }
        if (this.fileGroups_ != null && (groups = this.fileGroups_.getGroups()) != null) {
            for (FileGroup group : groups) {
                if (group == null) continue;
                int type = group.type();
                if (type == 2) {
                    this.processProjectGroup((ProjectFileGroup)group);
                    continue;
                }
                if (type == 1) {
                    this.processPackagingGroup((PackagingFileGroup)group);
                    continue;
                }
                if (type == 3) {
                    this.processLibraryGroup((LibraryFileGroup)group);
                    continue;
                }
                this.messages_.add(CommonArb.format(70, Integer.toString(type)));
            }
        }
    }

    protected final void processPackagingGroup(PackagingFileGroup group) {
        SelectionRule[] rules;
        URLPath contribPath = this.filterContribPath(FileGroupsEditor.getContribPath(group, this.container_));
        SelectionRules filters = group.getFilters();
        boolean wlsjspsFilterFound = false;
        if (filters != null && (rules = filters.getRules()) != null) {
            for (SelectionRule rule : rules) {
                if (rule.getPattern() == null || !rule.getPattern().equals(".wlsjsps/") || !rule.isExclude()) continue;
                wlsjspsFilterFound = true;
                break;
            }
        }
        if (!wlsjspsFilterFound) {
            filters.addExclude(".wlsjsps/", false);
        }
        CPF cpf = new CPF(contribPath, filters);
        cpf.recurseInPath(contribPath);
        this.archive_.addContents(cpf.getPackets(), FileGroupPackager.getTargetWithinJar(group));
    }

    protected final void processLibraryGroup(LibraryFileGroup group) {
        URLPath contribPath = this.filterContribPath(FileGroupsEditor.getContribPath(group, this.container_, this.libraryElement_));
        CPF cpf = new CPF(contribPath, group.getFilters());
        cpf.recurseInPath(contribPath);
        this.archive_.addContents(cpf.getPackets(), FileGroupPackager.getTargetWithinJar(group));
    }

    protected final void processProjectGroup(ProjectFileGroup group) {
        CdaSettings filters = group.getFilters();
        if (filters != null) {
            SelectedProjectFiles contributors = group.getContributors();
            SelectedProjectFilesDt spfdt = new SelectedProjectFilesDt((Project)this.container_, contributors);
            Map entryURLMap = spfdt.getEntryURLMap(filters, null);
            String targetWithinJar = FileGroupPackager.getTargetWithinJar(group);
            this.archive_.addContents(entryURLMap.values(), targetWithinJar);
            URL[] archivesToInclude = filters.getArchivesToInclude();
            if (archivesToInclude != null && archivesToInclude.length > 0) {
                switch (filters.getSelectedArchives().getSelectionMode()) {
                    case 0: {
                        this.archive_.addDirectoryTrees(archivesToInclude, targetWithinJar);
                        this.archive_.removeEntry("META-INF/MANIFEST.MF");
                        break;
                    }
                    case 1: {
                        int n = archivesToInclude.length;
                        ArrayList<CdaPacket> contents = new ArrayList<CdaPacket>(n);
                        for (int i = 0; i < n; ++i) {
                            URL url = archivesToInclude[i];
                            if (url == null) continue;
                            URL jarFileURL = JarUtil.getJarFileURL((URL)url);
                            String entryName = URLFileSystem.getFileName((URL)jarFileURL);
                            contents.add(new CdaPacket(entryName, jarFileURL));
                        }
                        this.archive_.addContents(contents, targetWithinJar);
                    }
                }
            }
        }
    }

    protected static final String getTargetWithinJar(FileGroup fileGroup) {
        String targetWithinJar = fileGroup.getTargetWithinJar();
        if (ModelUtil.hasLength((String)targetWithinJar) && !targetWithinJar.endsWith("/")) {
            return targetWithinJar + "/";
        }
        return targetWithinJar;
    }

    public static URLPath stripRegularFiles(URLPath contribPath) {
        URLPath regularFiles = new URLPath();
        Iterator iter = contribPath.iterator();
        while (iter.hasNext()) {
            URL url = (URL)iter.next();
            if (JarUtil.isJarURL((URL)url) || !URLFileSystem.isRegularFile((URL)url)) continue;
            iter.remove();
            regularFiles.add(url);
        }
        return regularFiles;
    }

    public void setContribPathFilter(ContribPathFilter path) {
        this.contribPathFilter_ = path;
    }

    public ContribPathFilter getContribPathFilter() {
        return this.contribPathFilter_;
    }

    private URLPath filterContribPath(URLPath urlPath) {
        if (this.contribPathFilter_ == null) {
            return urlPath;
        }
        return this.contribPathFilter_.filter(urlPath);
    }

    private static class CPF
    extends CdaPacketFactory {
        private final SelectionRules _rules;
        private final URLPath _contribPath;

        CPF(URLPath contribPath, SelectionRules rules) {
            URLPath contribs = new URLPath(contribPath);
            URLPath regularFiles = FileGroupPackager.stripRegularFiles(contribs);
            if (rules != null) {
                for (URL url : regularFiles) {
                    String name = URLFileSystem.getFileName((URL)url);
                    if (!rules.isIncluded(name)) continue;
                    this.add(new CdaPacket(name, url));
                }
            }
            this._contribPath = contribs;
            this._rules = rules;
        }

        @Override
        protected boolean shouldRecurseInto(URL url) {
            String path = this._contribPath.toRelativePath(url);
            if (path != null && path.indexOf(".ade_path") >= 0) {
                return false;
            }
            if (this._rules != null) {
                TriStateBoolean inference = this._rules.inferFromRules(this._contribPath.toRelativePath(url));
                return inference.isTrue() || inference.isTriState();
            }
            return false;
        }

        @Override
        protected boolean shouldAdd(URL url) {
            String relPath = this._contribPath.toRelativePath(url);
            return relPath == null || this._rules != null && this._rules.isIncluded(relPath);
        }
    }
}

