/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.ide.util.ModelUtil;
import oracle.javatools.data.HashStructure;
import oracle.javatools.marshal.AttributeMarker;
import oracle.javatools.util.Copyable;
import oracle.jdeveloper.deploy.DefaultLinkedDirtyable;
import oracle.jdeveloper.deploy.res.DeployArb;

public abstract class FileGroup
extends DefaultLinkedDirtyable
implements Copyable {
    public static final int PACKAGING_FILE_GROUP = 1;
    public static final int PROJECT_FILE_GROUP = 2;
    public static final int LIBRARY_FILE_GROUP = 3;
    protected HashStructure _hash;

    public abstract int type();

    public FileGroup() {
        this(HashStructure.newInstance());
    }

    public FileGroup(HashStructure hash) {
        this._hash = hash;
    }

    public FileGroup(String displayName) {
        this();
        this.setDisplayName(displayName);
    }

    public FileGroup(String displayName, String internalName) {
        this(displayName);
        this.setInternalName(internalName);
    }

    public abstract Object copyTo(Object var1);

    protected final void copyToImpl(FileGroup copy) {
        this._hash.copyTo(copy._hash);
    }

    public String getDisplayName() {
        return this._hash.getString("displayName");
    }

    public void setDisplayName(String displayName) {
        if (ModelUtil.areDifferent((Object)this.getDisplayName(), (Object)displayName)) {
            this._hash.putString("displayName", displayName);
            this.markDirty(true);
        }
    }

    public String getTargetWithinJar() {
        return this._hash.getString("targetWithinJar");
    }

    public void setTargetWithinJar(String targetWithinJar) {
        if (ModelUtil.areDifferent((Object)this.getTargetWithinJar(), (Object)targetWithinJar)) {
            this._hash.putString("targetWithinJar", targetWithinJar);
            this.markDirty(true);
        }
    }

    public String getInternalName() throws AttributeMarker {
        return this._hash.getString("internalName");
    }

    public void setInternalName(String internalName) {
        if (ModelUtil.areDifferent((Object)this.getInternalName(), (Object)internalName)) {
            if (this.getDisplayName() == null && "legacy-project-deps".equals(internalName)) {
                this.setDisplayName(DeployArb.getString(101));
            }
            this._hash.putString("internalName", internalName);
            this.markDirty(true);
        }
    }

    public boolean hasInternalName() {
        return this.getInternalName() != null;
    }

    public HashStructure getHashStructure() {
        return this._hash;
    }

    public boolean equals(Object o) {
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        return this.equalsImpl((FileGroup)o);
    }

    protected final boolean equalsImpl(FileGroup other) {
        return this._hash.equals((Object)other._hash);
    }
}

