/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import oracle.ide.Context;
import oracle.ide.compiler.CompileArguments;
import oracle.ide.compiler.Compiler;
import oracle.ide.model.DataContainer;
import oracle.ide.model.Dependable;
import oracle.ide.model.Element;
import oracle.ide.model.Folder;
import oracle.ide.model.Node;
import oracle.ide.model.Project;
import oracle.ide.model.Workspace;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.common.AbstractDeployer;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.res.DeployArb;
import oracle.jdevimpl.deploy.common.DependencyGraph;
import oracle.jdevimpl.deploy.res.LogArb;

public class BuildDeployer
extends AbstractDeployer {
    public static final String COMPILE_BEFORE_DEPLOY = "isCompileBeforeDeploy";
    public static final String CLEAN_BEFORE_COMPILE = "isCleanBeforeCompile";
    public static final String COMPILER_OUT_STREAM = "compilerOutputStream";
    public static final String COMPILER_ERR_STREAM = "compilerErrorStream";

    public BuildDeployer(int sequence, DeployShell shell) {
        super(sequence);
    }

    @Override
    protected void deployImpl(int deploySequenceId, DeployShell shell) throws DeployException {
        boolean compileBeforeDeploy = shell.findFlag(COMPILE_BEFORE_DEPLOY);
        if (compileBeforeDeploy) {
            if (shell.findFlag("ignoreDependencies")) {
                this.compileCurrent(shell);
            } else {
                this.compileDependants(shell);
            }
        }
    }

    protected void compileCurrent(DeployShell shell) throws DeployException {
        Context ctx = shell.getContext();
        DataContainer dc = null;
        if (ctx.getElement() instanceof Profile) {
            Profile profile = (Profile)ctx.getElement();
            dc = profile.getDataContainer();
        } else if (ctx.getElement() instanceof DataContainer) {
            dc = (DataContainer)ctx.getElement();
        } else {
            this.build(ctx, shell);
            return;
        }
        this.buildAll(new Node[]{dc}, shell);
    }

    public void compileDependants(DeployShell dsh) throws DeployException {
        DataContainer[] containersToBuild = this.getBuildDataContainers(dsh);
        this.buildAll((Node[])containersToBuild, dsh);
    }

    private Dependable[] getAllDependables(DeployShell shell) throws DeployException {
        return this.getDependables(shell, Dependable.class);
    }

    protected <T> T[] getDependables(DeployShell shell, Class<T> clazz) throws DeployException {
        DependencyGraph graph = DependencyGraph.findInNamespace(shell);
        if (graph == null) {
            throw new DeployException("Dependency Graph not found");
        }
        return graph.getDependables(clazz);
    }

    protected DataContainer[] getBuildDataContainers(DeployShell shell) throws DeployException {
        Dependable[] allDependables = this.getAllDependables(shell);
        ArrayList<URL> seen = new ArrayList<URL>();
        ArrayList<DataContainer> containers = new ArrayList<DataContainer>();
        for (Dependable dep : allDependables) {
            DataContainer dc;
            Element source = dep.getSource();
            Folder owner = dep.getSourceOwner();
            Object elementToAdd = null;
            if (source instanceof DataContainer) {
                elementToAdd = owner instanceof DataContainer && !seen.contains(((DataContainer)owner).getURL()) ? owner : source;
            } else if (owner instanceof DataContainer) {
                elementToAdd = owner;
            }
            if (elementToAdd == null || seen.contains((dc = (DataContainer)elementToAdd).getURL())) continue;
            containers.add(dc);
            seen.add(dc.getURL());
        }
        ArrayList<DataContainer> dc = BuildDeployer.sanitizeBuildDataContainers(containers, true);
        return dc.toArray(new DataContainer[dc.size()]);
    }

    private static ArrayList<DataContainer> sanitizeBuildDataContainers(ArrayList<DataContainer> containers, boolean removeWorkspace) {
        ArrayList<URL> seen = new ArrayList<URL>();
        ArrayList<DataContainer> newList = new ArrayList<DataContainer>();
        for (DataContainer dc : containers) {
            if (dc instanceof Workspace && !removeWorkspace) {
                Workspace ws = (Workspace)dc;
                Iterator iter = ws.getChildren();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof Project) || seen.contains(((DataContainer)o).getURL())) continue;
                    newList.add((DataContainer)o);
                    seen.add(((DataContainer)o).getURL());
                }
                continue;
            }
            if (!(dc instanceof Project) || seen.contains(dc.getURL())) continue;
            newList.add(dc);
            seen.add(dc.getURL());
        }
        return newList;
    }

    private void buildAll(Node[] containers, DeployShell dsh) throws DeployException {
        if (containers == null || containers.length <= 0) {
            return;
        }
        Context buildContext = BuildDeployer.newContext(containers[0], dsh);
        buildContext.setSelection((Element[])containers);
        this.build(buildContext, dsh);
    }

    private static Context newContext(Node container, DeployShell dsh) {
        Context buildContext = new Context(dsh.getContext());
        buildContext.setNode(container);
        if (container instanceof Project) {
            buildContext.setProject((Project)container);
        } else if (container instanceof Workspace) {
            buildContext.setWorkspace((Workspace)container);
        }
        if (dsh.findFlag("isAssembly")) {
            buildContext.setProperty("is-j2ee-application-assembly", (Object)Boolean.TRUE);
        }
        buildContext.setProperty("deploy-context-log", (Object)dsh.getLog());
        if (dsh.findFlag("ignoreDependencies")) {
            buildContext.setProperty("buildsystem.dont.compile.dependent.projects", (Object)Boolean.TRUE);
        }
        return buildContext;
    }

    void build(Context buildContext, DeployShell dsh) throws DeployException {
        try {
            PrintWriter log = dsh.getLog();
            log.println(DeployArb.getString(72));
            boolean shouldClean = dsh.findFlag(CLEAN_BEFORE_COMPILE);
            if (shouldClean) {
                Compiler.getCompiler().clean(buildContext, true, (OutputStream)System.out, (OutputStream)System.err);
            }
            CompileArguments compileArguments = new CompileArguments(buildContext);
            OutputStream out = (OutputStream)dsh.find(COMPILER_OUT_STREAM);
            compileArguments.setOutputStream(out);
            OutputStream err = (OutputStream)dsh.find(COMPILER_ERR_STREAM);
            compileArguments.setDiagnosticsStream(err);
            compileArguments.setRebuildAllSources(false);
            compileArguments.setWaitForTermination(true);
            compileArguments.setSaveBeforeCompiling(true);
            boolean result = Compiler.getCompiler().compile(compileArguments);
            if (!result) {
                log.println(LogArb.getString(5));
                log.println(LogArb.getString(6));
                throw new DeployException(LogArb.getString(5));
            }
        }
        catch (IOException e2) {
            DeployException e2;
            if (!(e2 instanceof DeployException)) {
                e2 = new DeployException(e2);
            }
            throw (DeployException)e2;
        }
    }
}

