/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.common;

import oracle.jdeveloper.deploy.DeployEvent;
import oracle.jdeveloper.deploy.DeployException;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.Deployer;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdevimpl.deploy.fwk.ListenerSupport;
import oracle.jdevimpl.deploy.fwk.WrappedDeployer;

public abstract class AbstractDeployer
implements Deployer {
    private DeployEvent deployEvent_ = null;
    private int sequenceId_;
    private ListenerSupport listenerSupport_ = DeploymentManager.getProfileListenerSupport();

    public AbstractDeployer(int deploymentSequenceId) {
        this.sequenceId_ = deploymentSequenceId;
    }

    public int getSequenceId() {
        return this.sequenceId_;
    }

    @Override
    public boolean canDeploy(int deploySequenceId) {
        return this.sequenceId_ == deploySequenceId;
    }

    public String getName() {
        return this.getClass().getName();
    }

    @Override
    public void prepare(int deploySequenceId, DeployShell shell) throws DeployException {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillPrepare(deployEvent);
        try {
            this.prepareImpl(deploySequenceId, shell);
        }
        catch (DeployException e) {
            e.setSource(this);
            throw e;
        }
        this.listenerSupport_.firePrepared(deployEvent);
        shell.getSequenceStack().pop();
    }

    @Override
    public void deploy(int deploySequenceId, DeployShell shell) throws DeployException {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillDeploy(deployEvent);
        try {
            this.deployImpl(deploySequenceId, shell);
        }
        catch (DeployException e) {
            e.setSource(this);
            throw e;
        }
        this.listenerSupport_.fireDeployed(deployEvent);
        shell.getSequenceStack().pop();
    }

    @Override
    public void finish(int deploySequenceId, DeployShell shell) {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillFinish(deployEvent);
        this.finishImpl(deploySequenceId, shell);
        this.listenerSupport_.fireFinished(deployEvent);
        shell.getSequenceStack().pop();
    }

    @Override
    public void cancel(int deploySequenceId, DeployShell shell) {
        shell.getSequenceStack().push(this.sequenceId_);
        DeployEvent deployEvent = this.createEvent(deploySequenceId, this.getSequenceId(), shell);
        this.listenerSupport_.fireWillCancel(deployEvent);
        this.cancelImpl(deploySequenceId, shell);
        this.listenerSupport_.fireCancelled(deployEvent);
        shell.getSequenceStack().pop();
    }

    protected void prepareImpl(int deploySequenceId, DeployShell shell) throws DeployException {
    }

    protected abstract void deployImpl(int var1, DeployShell var2) throws DeployException;

    protected void finishImpl(int deploySequenceId, DeployShell shell) {
    }

    protected void cancelImpl(int deploySequenceId, DeployShell shell) {
    }

    private synchronized DeployEvent createEvent(int originalSequence, int currentSequence, DeployShell shell) {
        if (this.deployEvent_ == null) {
            this.deployEvent_ = DeployEvent.create(0, 0, null, AbstractDeployer.unwrap(this));
        }
        this.deployEvent_.setOriginalSequence(originalSequence);
        this.deployEvent_.setCurrentSequence(currentSequence);
        this.deployEvent_.setShell(shell);
        return this.deployEvent_;
    }

    private static Deployer unwrap(Deployer deployer) {
        if (deployer instanceof WrappedDeployer) {
            return AbstractDeployer.unwrap(((WrappedDeployer)deployer).getDeployer());
        }
        return deployer;
    }

    public String toString() {
        return "<deployer  class=\"" + this.getClass().getName() + "\" seqId=\"" + this.sequenceId_ + "\" seqName=\"" + DeploymentManager.getDeploymentSequenceName(this.sequenceId_) + "\"/>";
    }
}

