/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd;

import oracle.ide.Context;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DeployUtil;
import oracle.jdeveloper.deploy.PlatformDeployable;
import oracle.jdeveloper.deploy.cmd.DeployCommand;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.cmd.ProfileDeployCmdState;
import oracle.jdeveloper.deploy.dt.Profile;
import oracle.jdeveloper.deploy.meta.Platform;

public abstract class ProfileDeployCmd
extends DeployCommand {
    public ProfileDeployCmd(int cmdId, int type, int sequence) {
        super(cmdId, type, sequence);
    }

    public ProfileDeployCmd(HashStructure hash) {
        super(hash);
    }

    @Override
    protected Class<? extends DeployCommandState> getStateClass() {
        return ProfileDeployCmdState.class;
    }

    public Profile getProfile() {
        return this.state().getProfile();
    }

    public String getProfileName() {
        return this.state().getProfileName();
    }

    public void setProfile(Profile profile) {
        this.state().setProfile(profile);
    }

    public void setContext(Context context) {
        super.setContext(new Context(context));
        if (this.getContext().getElement() instanceof Profile) {
            this.setProfile((Profile)this.getContext().getElement());
        }
    }

    @Override
    protected boolean isReady() {
        return this.getProfile() != null && this.getContext() != null;
    }

    @Override
    protected ProfileDeployCmdState state() {
        return (ProfileDeployCmdState)super.state();
    }

    @Override
    public int doit() throws Exception {
        DeployUtil.setProfile(this.getContext(), this.getProfile());
        return super.doit();
    }

    @Override
    public String getLongLabel() {
        return this.getShortLabel();
    }

    @Override
    public Platform getPlatform() {
        Profile profile;
        Platform platform = super.getPlatform();
        if (platform == null && (profile = this.getProfile()) instanceof PlatformDeployable) {
            return ((PlatformDeployable)((Object)profile)).getPlatform();
        }
        return platform;
    }

    public static class ProfileNotFoundException
    extends DeployCommand.CommandInstantiationException {
        public ProfileNotFoundException(String msg) {
            super(msg, null);
        }
    }
}

