/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy.cmd;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import javax.swing.Icon;
import oracle.ide.controller.Command;
import oracle.ide.model.Attributes;
import oracle.ide.model.Element;
import oracle.javatools.data.HashStructure;
import oracle.jdeveloper.deploy.DefaultDeployShellFactory;
import oracle.jdeveloper.deploy.DeployShell;
import oracle.jdeveloper.deploy.DeployShellFactory;
import oracle.jdeveloper.deploy.DeploymentManager;
import oracle.jdeveloper.deploy.cmd.DeployCommandState;
import oracle.jdeveloper.deploy.meta.Platform;
import oracle.jdeveloper.deploy.shell.JavaDeployment;

public abstract class DeployCommand
extends Command
implements Element {
    private Callback callback_;
    private Status status_ = Status.NOT_READY;
    private DeployCommandState state_;
    private Platform platform_ = null;

    public boolean mayHaveChildren() {
        return false;
    }

    public Iterator<Element> getChildren() {
        return null;
    }

    public Attributes getAttributes() {
        return null;
    }

    public Icon getIcon() {
        return null;
    }

    public String getToolTipText() {
        return this.getShortLabel();
    }

    public String getLongLabel() {
        return this.getShortLabel();
    }

    public void setPlatform(Platform platform) {
        this.platform_ = platform;
    }

    public Platform getPlatform() {
        return this.platform_;
    }

    public DeployCommand(int cmdId, int type, int sequenceId) {
        super(cmdId, type);
        this.state_ = this.newState();
        this.state_.setDeploySequence(sequenceId);
        this.state_.setCommandId(cmdId);
        this.state_.setCommandType(type);
    }

    public DeployCommand(HashStructure hash) {
        super(DeployCommandState.getCommandId(hash), DeployCommandState.getCommandType(hash));
        this.state_ = this.newState(hash);
    }

    public int getSequenceId() {
        return this.state_.getDeploySequence();
    }

    public void setCallback(Callback callback) {
        this.callback_ = callback;
    }

    public synchronized Status getStatus() {
        this.updateStatus();
        return this.status_;
    }

    protected void updateStatus() {
        if (this.status_ == Status.NOT_READY || this.status_ == Status.READY) {
            if (this.isReady()) {
                this.setStatus(Status.READY);
            } else {
                this.setStatus(Status.NOT_READY);
            }
        }
    }

    protected DeployCommandState newState() {
        Class<? extends DeployCommandState> stateClass = this.getStateClass();
        try {
            return stateClass.newInstance();
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    protected DeployCommandState newState(HashStructure hash) {
        Class<? extends DeployCommandState> stateClass = this.getStateClass();
        try {
            Constructor<? extends DeployCommandState> ctor = stateClass.getConstructor(HashStructure.class);
            return ctor.newInstance(hash);
        }
        catch (NoSuchMethodException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    protected abstract Class<? extends DeployCommandState> getStateClass();

    protected synchronized void setStatus(Status status) {
        this.status_ = status;
    }

    protected abstract boolean isReady();

    public int doit() throws Exception {
        if (this.getStatus() != Status.READY) {
            throw new IllegalStateException("Command not in ready state");
        }
        this.setStatus(Status.DEPLOYING);
        DeployShellFactory shellFactory = this.getDeployShellFactory();
        DeployShell shell = shellFactory.create(this.getSequenceId(), this.getContext(), null);
        this.prepare(shell);
        if (this.getPlatform() != null) {
            JavaDeployment shellAdapter = JavaDeployment.getInstance(shell);
            shellAdapter.setPlatform(this.getPlatform());
        }
        try {
            if (this.callback_ != null) {
                this.callback_.start(shell);
            }
            this.deploy(shell);
            this.setStatus(Status.SUCCESS);
            if (this.callback_ != null) {
                this.callback_.finished(shell);
            }
        }
        catch (Exception e) {
            this.setStatus(Status.FAILED);
            this.exception(e, shell);
            if (this.callback_ != null) {
                this.callback_.exception(e, shell);
            }
            throw e;
        }
        finally {
            this.finished(shell);
            if (this.callback_ != null) {
                this.callback_.finished(shell);
            }
        }
        return shell.getDeployException() == null ? 0 : 1;
    }

    protected void prepare(DeployShell shell) {
    }

    protected void deploy(DeployShell shell) throws Exception {
        int sequenceId = this.getSequenceId();
        DeploymentManager.deploy(sequenceId, shell, shell.getContext());
    }

    protected void exception(Exception e, DeployShell shell) {
    }

    protected void finished(DeployShell shell) {
    }

    protected DeployShellFactory getDeployShellFactory() {
        return DefaultDeployShellFactory.getInstance();
    }

    protected DeployCommandState state() {
        return this.state_;
    }

    public abstract String getShortLabel();

    public DeployCommandState getState() {
        return (DeployCommandState)((Object)this.state().copyTo(null));
    }

    public void setState(DeployCommandState state) {
        this.state_ = state;
    }

    public static DeployCommand create(HashStructure hash) {
        try {
            String className = DeployCommandState.getCommandClassName(hash);
            Class<?> cl = Class.forName(className);
            Constructor<?> ctor = cl.getConstructor(HashStructure.class);
            DeployCommand cmd = (DeployCommand)((Object)ctor.newInstance(hash));
            return cmd;
        }
        catch (InstantiationException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (IllegalAccessException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (InvocationTargetException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (NoSuchMethodException e) {
            DeployCommand.commandInstantiationException(e);
        }
        catch (ClassNotFoundException e) {
            DeployCommand.commandInstantiationException(e);
        }
        return null;
    }

    private static void commandInstantiationException(Exception e) {
        throw new CommandInstantiationException("Could not read command", e);
    }

    public static class CommandInstantiationException
    extends RuntimeException {
        CommandInstantiationException(String msg, Exception e) {
            super(msg, e);
        }
    }

    public static interface Callback {
        public void start(DeployShell var1);

        public void finished(DeployShell var1);

        public void exception(Exception var1, DeployShell var2);
    }

    public static enum Status {
        NOT_READY,
        READY,
        DEPLOYING,
        SUCCESS,
        FAILED;

    }
}

