/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.deploy;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import oracle.ide.ProductInformation;
import oracle.ide.Version;
import oracle.ide.net.URLFileSystem;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.Archive;
import oracle.jdeveloper.deploy.ArchiveEntry;
import oracle.jdeveloper.deploy.ArchiveEntryFactory;
import oracle.jdevimpl.deploy.CdaPacket;
import oracle.jdevimpl.deploy.CdaPacketFactory;
import oracle.jdevimpl.deploy.fwk.JarIO;

public class DefaultArchive
implements Archive {
    private Manifest _manifest = new Manifest();
    private final TreeSet _cdaPackets = new TreeSet(Archive.ARCHIVE_ENTRY_NAME_COMPARATOR);
    private final SortedSet _missingEntryNames = new TreeSet();
    private final boolean _forceRewrite;
    private boolean _includeManifest = true;
    private boolean _compressed = false;
    private int _compressionLevel = -1;
    private boolean _reportNameCollisions = true;
    private ArrayList<ArchiveEntry[]> _nameCollisions;
    private transient boolean _hasContents = false;
    private transient boolean _recalcMissingEntryNames = false;

    protected DefaultArchive(boolean forceRewrite) {
        Attributes mainAttributes = this._manifest.getMainAttributes();
        mainAttributes.put(new Attributes.Name("Manifest-Version"), "1.0");
        this._forceRewrite = forceRewrite;
    }

    public static DefaultArchive create(boolean includeManifest, boolean forceRewrite) {
        DefaultArchive archive = new DefaultArchive(forceRewrite);
        archive.setIncludeManifest(includeManifest);
        archive.setCreatedBy(DefaultArchive.getJarFileCreatedBy());
        return archive;
    }

    protected static String getJarFileCreatedBy() {
        ProductInformation product = ProductInformation.getProductInformation();
        return product.getName() + " " + Version.VER;
    }

    @Override
    public Manifest getManifest() {
        return this._manifest;
    }

    @Override
    public String getManifestAsString() throws IOException {
        if (this._manifest == null || !this.isIncludeManifest()) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this._manifest.write(out);
        return out.toString();
    }

    @Override
    public void setCreatedBy(String creator) {
        this.setMainAttribute("Created-By", creator);
    }

    @Override
    public String getMainAttribute(String attrName) {
        if (!ModelUtil.hasLength((String)attrName)) {
            return null;
        }
        Attributes mainAttributes = this._manifest.getMainAttributes();
        return mainAttributes.getValue(attrName);
    }

    @Override
    public void setMainAttribute(String attrName, String attrValue) {
        if (!ModelUtil.hasLength((String)attrName)) {
            return;
        }
        Attributes mainAttributes = this._manifest.getMainAttributes();
        Attributes.Name mainClassAttr = new Attributes.Name(attrName);
        if (attrValue != null) {
            mainAttributes.put(mainClassAttr, attrValue);
        } else {
            mainAttributes.remove(mainClassAttr);
        }
    }

    @Override
    public void setMainClass(String mainClass) {
        this.setMainAttribute("Main-Class", mainClass);
    }

    @Override
    public void setCompressed(boolean compressed) {
        this._compressed = compressed;
    }

    @Override
    public void setCompressionLevel(int level) {
        this._compressionLevel = level;
    }

    @Override
    public boolean isCompressed() {
        return this._compressed;
    }

    @Override
    public int getCompressionLevel() {
        return this._compressionLevel;
    }

    @Override
    public boolean isIncludeManifest() {
        return this._includeManifest;
    }

    @Override
    public void setIncludeManifest(boolean includeManifest) {
        this._includeManifest = includeManifest;
    }

    @Override
    @Deprecated
    public void setReportNameCollisions(boolean reportNameCollisions) {
        this._reportNameCollisions = reportNameCollisions;
    }

    public ArrayList<ArchiveEntry[]> getCollisions() {
        return this._nameCollisions;
    }

    @Override
    public void mergeManifest(Manifest manifest) {
        if (manifest == null) {
            return;
        }
        Map<String, Attributes> curEntries = this._manifest.getEntries();
        Map<String, Attributes> newEntries = manifest.getEntries();
        for (String key : newEntries.keySet()) {
            Attributes newAttributes = newEntries.get(key);
            if (!curEntries.containsKey(key)) {
                curEntries.put(key, newAttributes);
                continue;
            }
            Attributes curAttributes = curEntries.get(key);
            for (Object key2 : newAttributes.keySet()) {
                Object value2 = newAttributes.get(key2);
                curAttributes.put(key2, value2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mergeManifest(URL manifestURL) throws IOException {
        if (manifestURL == null) {
            return;
        }
        InputStream in = null;
        try {
            in = URLFileSystem.openInputStream((URL)manifestURL);
            this._manifest.read(in);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    @Override
    public void addContents(Collection cdaPackets, String entryNamePrefix) {
        if (entryNamePrefix == null || entryNamePrefix.length() == 0) {
            this.addContents(cdaPackets);
            return;
        }
        int entryNamePrefixLen = entryNamePrefix.length();
        StringBuffer sb = new StringBuffer(entryNamePrefix);
        HashSet<ArchiveEntry> newCdaPackets = new HashSet<ArchiveEntry>();
        for (ArchiveEntry cdaPacket : cdaPackets) {
            sb.setLength(entryNamePrefixLen);
            sb.append(cdaPacket.getName());
            ArchiveEntry newCdaPacket = new ArchiveEntry(sb.toString(), cdaPacket.getURL());
            newCdaPackets.add(newCdaPacket);
        }
        this.addContents(newCdaPackets);
    }

    @Override
    public void addContents(Collection cdaPackets) {
        for (ArchiveEntry cdaPacket : cdaPackets) {
            this.addContents(cdaPacket);
        }
    }

    @Override
    public void addContents(ArchiveEntry cdaPacket) {
        if (cdaPacket != null && cdaPacket.getName() != null) {
            SortedSet<ArchiveEntry> existingSet;
            ArchiveEntry existing;
            if (!this._cdaPackets.contains(cdaPacket)) {
                this._cdaPackets.add(cdaPacket);
                this._recalcMissingEntryNames = true;
            } else if (this._reportNameCollisions && !URLFileSystem.equals((URL)(existing = (existingSet = this._cdaPackets.tailSet(cdaPacket)).first()).getURL(), (URL)cdaPacket.getURL()) && existing != null) {
                if (this._nameCollisions == null) {
                    this._nameCollisions = new ArrayList();
                }
                for (ArchiveEntry[] cdaPair : this._nameCollisions) {
                    ArchiveEntry alreadyReportedConflict = cdaPair[0];
                    if (!ModelUtil.areEqual((Object)alreadyReportedConflict.getName(), (Object)cdaPacket.getName())) continue;
                    if (!URLFileSystem.equals((URL)alreadyReportedConflict.getURL(), (URL)cdaPacket.getURL())) break;
                    return;
                }
                ArchiveEntry[] cdaPair = new ArchiveEntry[]{cdaPacket, existing};
                this._nameCollisions.add(cdaPair);
            }
        }
    }

    @Override
    public boolean containsEntry(String entryName) {
        for (ArchiveEntry packet : this._cdaPackets) {
            if (!entryName.equals(packet.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    public ArchiveEntry removeEntry(String entryName) {
        Iterator iter = this._cdaPackets.iterator();
        while (iter.hasNext()) {
            ArchiveEntry packet = (ArchiveEntry)iter.next();
            if (!entryName.equals(packet.getName())) continue;
            iter.remove();
            return packet;
        }
        return null;
    }

    @Override
    public void addContents(ArchiveEntry[] cdaPackets) {
        this.addContents(Arrays.asList(cdaPackets));
    }

    private void addDirectoryTree(URL dir, String entryNamePrefix) {
        ArchiveEntryFactory aef = new ArchiveEntryFactory();
        aef.recurseInDirectory(dir);
        this.addContents(aef.getPackets(), entryNamePrefix);
    }

    @Override
    public void addDirectoryTrees(URL[] dirs, String entryNamePrefix) {
        if (dirs != null) {
            int n = dirs.length;
            for (int i = 0; i < n; ++i) {
                this.addDirectoryTree(dirs[i], entryNamePrefix);
            }
        }
    }

    @Deprecated
    public CdaPacket[] getCdaPackets() {
        CdaPacket[] archiveEntries = CdaPacketFactory.toArray(this._cdaPackets);
        CdaPacket[] cdaPackets = new CdaPacket[archiveEntries.length];
        System.arraycopy(archiveEntries, 0, cdaPackets, 0, archiveEntries.length);
        return cdaPackets;
    }

    @Override
    public SortedSet getMissingEntryNames() {
        if (this._recalcMissingEntryNames) {
            for (ArchiveEntry cdaPacket : this._cdaPackets) {
                if (cdaPacket.getURL() != null) continue;
                this._missingEntryNames.add(cdaPacket.getName());
            }
            this._recalcMissingEntryNames = false;
        }
        return Collections.unmodifiableSortedSet(this._missingEntryNames);
    }

    @Override
    public boolean hasContents() {
        this.getMissingEntryNames();
        this._hasContents = this._cdaPackets.size() != this._missingEntryNames.size();
        return this._hasContents;
    }

    public synchronized boolean writeJarFile(URL outputURL, PrintWriter printWriter) throws IOException {
        return DefaultArchive.writeJarFile(this, outputURL, printWriter, this._forceRewrite, this._compressed);
    }

    public static synchronized boolean writeJarFile(Archive archive, URL outputURL, PrintWriter printWriter, boolean forceRewrite, boolean compressed) throws IOException {
        JarIO _jarIO = new JarIO(compressed);
        _jarIO.write(archive, outputURL, printWriter, forceRewrite);
        return true;
    }

    @Override
    public Iterator<ArchiveEntry> getArchiveEntries() {
        return this._cdaPackets.iterator();
    }

    public Object copyTo(Object target) {
        DefaultArchive copy = target != null ? (DefaultArchive)target : new DefaultArchive(false);
        this.copyToImpl(copy);
        return copy;
    }

    protected void copyToImpl(DefaultArchive copy) {
        copy._compressed = this._compressed;
        copy._includeManifest = this._includeManifest;
        copy._reportNameCollisions = this._reportNameCollisions;
        copy._manifest = new Manifest(this._manifest);
        Iterator<ArchiveEntry> iter = this.getArchiveEntries();
        while (iter.hasNext()) {
            copy.addContents(iter.next());
        }
    }

    @Override
    public ArchiveEntry getEntryByName(String entryName) {
        for (Object e : this._cdaPackets) {
            if (!((ArchiveEntry)e).getName().equals(entryName)) continue;
            return (ArchiveEntry)e;
        }
        return null;
    }

    @Override
    public ArchiveEntry renameEntry(String fromName, String toName) {
        if (fromName.equals(toName)) {
            return null;
        }
        ArchiveEntry entry = this.getEntryByName(fromName);
        if (entry == null) {
            return null;
        }
        ArchiveEntry newEntry = new ArchiveEntry(toName, entry.getURL());
        this.addContents(newEntry);
        this.removeEntry(fromName);
        return newEntry;
    }
}

