/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.controls;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.JTextField;
import oracle.ide.controls.AbstractPicker;
import oracle.ide.model.Project;
import oracle.javatools.parser.java.v2.model.JavaClass;
import oracle.jdeveloper.builder.cls.ClassBuilderModel;
import oracle.jdeveloper.controls.classpick.ClassPickerFactory;
import oracle.jdeveloper.controls.classpick.TextFieldAdapter;
import oracle.jdeveloper.dialogs.BrowseHandler;
import oracle.jdeveloper.dialogs.ClassPackageBrowserFilterV2;
import oracle.jdeveloper.dialogs.ClassPackageBrowserV2;
import oracle.jdeveloper.java.JavaManager;

public class ClassPopup
extends JTextField
implements ActionListener {
    private Project _proj;
    protected JavaManager _javaManager;
    protected BrowseHandler _browseHandler;
    protected AbstractPicker.PickerResultValidator validator = null;
    protected ClassBuilderModel cbModel = null;

    public ClassPopup() {
        this.addFocusListener(new SelectOnFocusListener());
    }

    public ClassPopup(Project proj) {
        this();
        this.setProject(proj);
    }

    public void setProject(Project proj) {
        this._proj = proj;
        this._javaManager = JavaManager.getJavaManager((Project)this._proj);
    }

    public Project getProject() {
        return this._proj;
    }

    public AbstractPicker.PickerResultValidator getValidator() {
        return this.validator;
    }

    public void setValidator(AbstractPicker.PickerResultValidator newValidator) {
        this.validator = newValidator;
    }

    public ClassBuilderModel getClassBuilderModel() {
        return this.cbModel;
    }

    public void setClassBuilderModel(ClassBuilderModel classBuilderModel) {
        this.cbModel = classBuilderModel;
        TextFieldAdapter textFieldAdapter = ClassPickerFactory.attach((JTextField)this, this.cbModel.getContext(), 8);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doBrowse();
    }

    protected void doBrowse() {
        String initialSelection;
        String[] classes;
        if (this._proj != null && (classes = ClassPackageBrowserV2.browseClassOrPackage((Component)this, this._proj, 2, false, new ClassFilter(), initialSelection = this.getText())).length > 0) {
            this.setBrowseResult(classes[0]);
        }
    }

    protected final void setBrowseResult(Object result) {
        if (this.validator == null || this.validator.isResultValid(result)) {
            Object value = this.cbModel != null ? this.cbModel.encodeValue(result) : result;
            this.setText(value.toString());
        }
    }

    private class SelectOnFocusListener
    implements FocusListener {
        private SelectOnFocusListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
        }

        @Override
        public void focusGained(FocusEvent e) {
            ClassPopup.this.selectAll();
        }
    }

    private class ClassFilter
    implements ClassPackageBrowserFilterV2 {
        private ClassFilter() {
        }

        @Override
        public boolean acceptPackage(String pkg) {
            return true;
        }

        @Override
        public boolean acceptClass(JavaClass cls) {
            return ClassPopup.this.validator == null || ClassPopup.this.validator.isResultValid((Object)cls);
        }
    }
}

